/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.net.SocketAddress;
import java.security.AccessController;
import java.util.Map;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerMask$1;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerMask$2;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    static final int MASK_EXCEPTION_CAUGHT = 1;
    static final int MASK_CHANNEL_REGISTERED = 2;
    static final int MASK_CHANNEL_UNREGISTERED = 4;
    static final int MASK_CHANNEL_ACTIVE = 8;
    static final int MASK_CHANNEL_INACTIVE = 16;
    static final int MASK_CHANNEL_READ = 32;
    static final int MASK_CHANNEL_READ_COMPLETE = 64;
    static final int MASK_USER_EVENT_TRIGGERED = 128;
    static final int MASK_CHANNEL_WRITABILITY_CHANGED = 256;
    static final int MASK_BIND = 512;
    static final int MASK_CONNECT = 1024;
    static final int MASK_DISCONNECT = 2048;
    static final int MASK_CLOSE = 4096;
    static final int MASK_DEREGISTER = 8192;
    static final int MASK_READ = 16384;
    static final int MASK_WRITE = 32768;
    static final int MASK_FLUSH = 65536;
    static final int MASK_ONLY_INBOUND = 510;
    private static final int MASK_ALL_INBOUND = 511;
    static final int MASK_ONLY_OUTBOUND = 130560;
    private static final int MASK_ALL_OUTBOUND = 130561;
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new ChannelHandlerMask$1();

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map<Class<? extends ChannelHandler>, Integer> map = MASKS.get();
        Integer n = map.get(clazz);
        if (n == null) {
            n = ChannelHandlerMask.mask0(clazz);
            map.put(clazz, n);
        }
        return n;
    }

    private static int mask0(Class<? extends ChannelHandler> clazz) {
        int n = 1;
        try {
            if (ChannelInboundHandler.class.isAssignableFrom(clazz)) {
                n |= 0x1FF;
                if (ChannelHandlerMask.isSkippable(clazz, "channelRegistered", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFFFD;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelUnregistered", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFFFB;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelActive", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFFF7;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelInactive", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFFEF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelRead", ChannelHandlerContext.class, Object.class)) {
                    n &= 0xFFFFFFDF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelReadComplete", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFFBF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "channelWritabilityChanged", ChannelHandlerContext.class)) {
                    n &= 0xFFFFFEFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "userEventTriggered", ChannelHandlerContext.class, Object.class)) {
                    n &= 0xFFFFFF7F;
                }
            }
            if (ChannelOutboundHandler.class.isAssignableFrom(clazz)) {
                n |= 0x1FE01;
                if (ChannelHandlerMask.isSkippable(clazz, "bind", ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class)) {
                    n &= 0xFFFFFDFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "connect", ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class)) {
                    n &= 0xFFFFFBFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "disconnect", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n &= 0xFFFFF7FF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "close", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n &= 0xFFFFEFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "deregister", ChannelHandlerContext.class, ChannelPromise.class)) {
                    n &= 0xFFFFDFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "read", ChannelHandlerContext.class)) {
                    n &= 0xFFFFBFFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "write", ChannelHandlerContext.class, Object.class, ChannelPromise.class)) {
                    n &= 0xFFFF7FFF;
                }
                if (ChannelHandlerMask.isSkippable(clazz, "flush", ChannelHandlerContext.class)) {
                    n &= 0xFFFEFFFF;
                }
            }
            if (ChannelHandlerMask.isSkippable(clazz, "exceptionCaught", ChannelHandlerContext.class, Throwable.class)) {
                n &= 0xFFFFFFFE;
            }
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        return n;
    }

    private static boolean isSkippable(Class<?> clazz, String string, Class<?> ... classArray) {
        return AccessController.doPrivileged(new ChannelHandlerMask$2(clazz, string, classArray));
    }

    private ChannelHandlerMask() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

