/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ServerChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioMessageChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketUtil;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioServerDomainSocketChannel$NioDomainServerSocketChannelConfig;
import pro.gravit.repackage.io.netty.channel.socket.nio.SelectorProviderUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NioServerDomainSocketChannel
extends AbstractNioMessageChannel
implements ServerChannel {
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openServerSocketChannel");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerDomainSocketChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final NioServerDomainSocketChannel$NioDomainServerSocketChannelConfig config;
    private volatile boolean bound;

    static ServerSocketChannel newChannel(SelectorProvider selectorProvider) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        try {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider);
            if (serverSocketChannel == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return serverSocketChannel;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    @Override
    protected ServerSocketChannel javaChannel() {
        return (ServerSocketChannel)super.javaChannel();
    }

    public NioServerDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioServerDomainSocketChannel(SelectorProvider selectorProvider) {
        this(NioServerDomainSocketChannel.newChannel(selectorProvider));
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public NioServerDomainSocketChannel(ServerSocketChannel serverSocketChannel) {
        super(null, serverSocketChannel, 16);
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported with Java 16+");
        }
        this.config = new NioServerDomainSocketChannel$NioDomainServerSocketChannelConfig(this, this, null);
        try {
            this.bound = serverSocketChannel.getLocalAddress() != null;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.bound;
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress, NioServerDomainSocketChannel$NioDomainServerSocketChannelConfig.access$100(this.config));
        this.bound = true;
    }

    @Override
    protected void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int doReadMessages(List<Object> list) {
        SocketChannel socketChannel = SocketUtils.accept(this.javaChannel());
        try {
            if (socketChannel != null) {
                list.add(new NioDomainSocketChannel((Channel)this, socketChannel));
                return 1;
            }
        }
        catch (Throwable throwable) {
            logger.warn("Failed to create a new channel from an accepted socket.", throwable);
            try {
                socketChannel.close();
            }
            catch (Throwable throwable2) {
                logger.warn("Failed to close a socket.", throwable2);
            }
        }
        return 0;
    }

    @Override
    protected boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doClose() {
        SocketAddress socketAddress = this.localAddress();
        try {
            super.doClose();
        }
        finally {
            this.javaChannel().close();
            if (socketAddress != null) {
                NioDomainSocketUtil.deleteSocketFile(socketAddress);
            }
        }
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected boolean closeOnReadError(Throwable throwable) {
        return super.closeOnReadError(throwable);
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFinishConnect() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ void access$200(NioServerDomainSocketChannel nioServerDomainSocketChannel) {
        nioServerDomainSocketChannel.clearReadPending();
    }
}

