/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$NameValidator;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$ValueValidator;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeadersImpl;
import pro.gravit.repackage.io.netty.handler.codec.Headers;
import pro.gravit.repackage.io.netty.handler.codec.HeadersUtils;
import pro.gravit.repackage.io.netty.handler.codec.ValueConverter;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeaders$1;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeaders$HeaderValueConverter;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.util.AsciiString;

public class DefaultHttpHeaders
extends HttpHeaders {
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(DefaultHttpHeaders.nameValidator(true), DefaultHttpHeaders.valueValidator(true));
    }

    @Deprecated
    public DefaultHttpHeaders(boolean bl) {
        this(DefaultHttpHeaders.nameValidator(bl), DefaultHttpHeaders.valueValidator(bl));
    }

    protected DefaultHttpHeaders(boolean bl, DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator) {
        this(defaultHeaders$NameValidator, DefaultHttpHeaders.valueValidator(bl));
    }

    protected DefaultHttpHeaders(DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator, DefaultHeaders$ValueValidator<CharSequence> defaultHeaders$ValueValidator) {
        this(defaultHeaders$NameValidator, defaultHeaders$ValueValidator, 16);
    }

    protected DefaultHttpHeaders(DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator, DefaultHeaders$ValueValidator<CharSequence> defaultHeaders$ValueValidator, int n) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, DefaultHttpHeaders$HeaderValueConverter.INSTANCE, defaultHeaders$NameValidator, n, defaultHeaders$ValueValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> defaultHeaders) {
        this.headers = defaultHeaders;
    }

    public Headers<CharSequence, CharSequence, ?> unwrap() {
        return this.headers;
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        this.headers.addObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        this.headers.addObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        this.headers.addObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.addObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders addInt(CharSequence charSequence, int n) {
        this.headers.addInt(charSequence, n);
        return this;
    }

    @Override
    public HttpHeaders addShort(CharSequence charSequence, short s) {
        this.headers.addShort(charSequence, s);
        return this;
    }

    @Override
    public HttpHeaders remove(String string) {
        this.headers.remove(string);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        this.headers.remove(charSequence);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        this.headers.setObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        this.headers.setObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        this.headers.setObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.setObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n) {
        this.headers.setInt(charSequence, n);
        return this;
    }

    @Override
    public HttpHeaders setShort(CharSequence charSequence, short s) {
        this.headers.setShort(charSequence, s);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String string) {
        return this.get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        return HeadersUtils.getAsString(this.headers, charSequence);
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        return this.headers.getInt(charSequence);
    }

    @Override
    public int getInt(CharSequence charSequence, int n) {
        return this.headers.getInt(charSequence, n);
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        return this.headers.getShort(charSequence);
    }

    @Override
    public short getShort(CharSequence charSequence, short s) {
        return this.headers.getShort(charSequence, s);
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        return this.headers.getTimeMillis(charSequence);
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l) {
        return this.headers.getTimeMillis(charSequence, l);
    }

    @Override
    public List<String> getAll(String string) {
        return this.getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this.headers, charSequence);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.headers.size());
        for (Map.Entry<String, String> entry : this) {
            arrayList.add(entry);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        Iterator<CharSequence> iterator = this.valueCharSequenceIterator(charSequence);
        return new DefaultHttpHeaders$1(this, iterator);
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.headers.valueIterator(charSequence);
    }

    @Override
    public boolean contains(String string) {
        return this.contains((CharSequence)string);
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.headers.contains(charSequence);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String string, String string2, boolean bl) {
        return this.contains((CharSequence)string, (CharSequence)string2, bl);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return this.headers.contains(charSequence, charSequence2, bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public Set<String> names() {
        return HeadersUtils.namesAsString(this.headers);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)object).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    static ValueConverter<CharSequence> valueConverter() {
        return DefaultHttpHeaders$HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders$ValueValidator<CharSequence> valueValidator(boolean bl) {
        return bl ? DefaultHttpHeadersFactory.headersFactory().getValueValidator() : DefaultHttpHeadersFactory.headersFactory().withValidation(false).getValueValidator();
    }

    static DefaultHeaders$NameValidator<CharSequence> nameValidator(boolean bl) {
        return bl ? DefaultHttpHeadersFactory.headersFactory().getNameValidator() : DefaultHttpHeadersFactory.headersFactory().withNameValidation(false).getNameValidator();
    }
}

