/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel;
import pro.gravit.repackage.io.netty.handler.codec.CodecException;
import pro.gravit.repackage.io.netty.handler.codec.DecoderResult;
import pro.gravit.repackage.io.netty.handler.codec.MessageToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.ComposedLastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObject;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;
    private boolean needRead = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        try {
            HttpObject httpObject2;
            if (httpObject instanceof HttpResponse && ((HttpResponse)httpObject).status().code() == 100) {
                if (!(httpObject instanceof LastHttpContent)) {
                    this.continueResponse = true;
                }
                list.add(ReferenceCountUtil.retain(httpObject));
                return;
            }
            if (this.continueResponse) {
                if (httpObject instanceof LastHttpContent) {
                    this.continueResponse = false;
                }
                list.add(ReferenceCountUtil.retain(httpObject));
                return;
            }
            if (httpObject instanceof HttpMessage) {
                int n;
                String string;
                this.cleanup();
                httpObject2 = (HttpMessage)httpObject;
                HttpHeaders httpHeaders = httpObject2.headers();
                String string2 = httpHeaders.get(HttpHeaderNames.CONTENT_ENCODING);
                string2 = string2 != null ? string2.trim() : ((string = httpHeaders.get(HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((n = string.indexOf(",")) != -1 ? string.substring(0, n).trim() : string.trim()) : IDENTITY);
                this.decoder = this.newContentDecoder(string2);
                if (this.decoder == null) {
                    if (httpObject2 instanceof HttpContent) {
                        ((HttpContent)httpObject2).retain();
                    }
                    list.add(httpObject2);
                    return;
                }
                if (httpHeaders.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                    httpHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
                    httpHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                if (HttpHeaderValues.IDENTITY.contentEquals(string = this.getTargetContentEncoding(string2))) {
                    httpHeaders.remove(HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)string);
                }
                if (httpObject2 instanceof HttpContent) {
                    DefaultHttpMessage defaultHttpMessage;
                    if (httpObject2 instanceof HttpRequest) {
                        HttpRequest httpRequest = (HttpRequest)httpObject2;
                        defaultHttpMessage = new DefaultHttpRequest(httpRequest.protocolVersion(), httpRequest.method(), httpRequest.uri());
                    } else if (httpObject2 instanceof HttpResponse) {
                        HttpResponse httpResponse = (HttpResponse)httpObject2;
                        defaultHttpMessage = new DefaultHttpResponse(httpResponse.protocolVersion(), httpResponse.status());
                    } else {
                        throw new CodecException("Object of class " + httpObject2.getClass().getName() + " is not an HttpRequest or HttpResponse");
                    }
                    defaultHttpMessage.headers().set(httpObject2.headers());
                    defaultHttpMessage.setDecoderResult(httpObject2.decoderResult());
                    list.add(defaultHttpMessage);
                } else {
                    list.add(httpObject2);
                }
            }
            if (httpObject instanceof HttpContent) {
                httpObject2 = (HttpContent)httpObject;
                if (this.decoder == null) {
                    list.add(httpObject2.retain());
                } else {
                    this.decodeContent((HttpContent)httpObject2, list);
                }
            }
        }
        finally {
            this.needRead = list.isEmpty();
        }
    }

    private void decodeContent(HttpContent httpContent, List<Object> list) {
        ByteBuf byteBuf = httpContent.content();
        this.decode(byteBuf, list);
        if (httpContent instanceof LastHttpContent) {
            this.finishDecode(list);
            LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
            HttpHeaders httpHeaders = lastHttpContent.trailingHeaders();
            if (httpHeaders.isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                list.add(new ComposedLastHttpContent(httpHeaders, DecoderResult.SUCCESS));
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        boolean bl = this.needRead;
        this.needRead = true;
        try {
            channelHandlerContext.fireChannelReadComplete();
        }
        finally {
            if (bl && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1);

    protected String getTargetContentEncoding(String string) {
        return IDENTITY;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanupSafely(channelHandlerContext);
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext channelHandlerContext) {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private void decode(ByteBuf byteBuf, List<Object> list) {
        this.decoder.writeInbound(byteBuf.retain());
        this.fetchDecoderOutput(list);
    }

    private void finishDecode(List<Object> list) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(list);
        }
        this.decoder = null;
    }

    private void fetchDecoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }
}

