/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.flush;

import java.util.concurrent.Future;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.flush.FlushConsolidationHandler$1;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private final boolean consolidateWhenNoReadInProgress;
    private final Runnable flushTask;
    private int flushPendingCount;
    private boolean readInProgress;
    private ChannelHandlerContext ctx;
    private Future<?> nextScheduledFlush;
    public static final int DEFAULT_EXPLICIT_FLUSH_AFTER_FLUSHES = 256;

    public FlushConsolidationHandler() {
        this(256, false);
    }

    public FlushConsolidationHandler(int n) {
        this(n, false);
    }

    public FlushConsolidationHandler(int n, boolean bl) {
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive(n, "explicitFlushAfterFlushes");
        this.consolidateWhenNoReadInProgress = bl;
        this.flushTask = bl ? new FlushConsolidationHandler$1(this) : null;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.readInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(channelHandlerContext);
            }
        } else if (this.consolidateWhenNoReadInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(channelHandlerContext);
            } else {
                this.scheduleFlush(channelHandlerContext);
            }
        } else {
            this.flushNow(channelHandlerContext);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.readInProgress = true;
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.resetReadAndFlushIfNeeded(channelHandlerContext);
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().isWritable()) {
            this.flushIfNeeded(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.flushIfNeeded(channelHandlerContext);
    }

    private void resetReadAndFlushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        this.readInProgress = false;
        this.flushIfNeeded(channelHandlerContext);
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.flushPendingCount > 0) {
            this.flushNow(channelHandlerContext);
        }
    }

    private void flushNow(ChannelHandlerContext channelHandlerContext) {
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        channelHandlerContext.flush();
    }

    private void scheduleFlush(ChannelHandlerContext channelHandlerContext) {
        if (this.nextScheduledFlush == null) {
            this.nextScheduledFlush = channelHandlerContext.channel().eventLoop().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }

    static /* synthetic */ int access$000(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.flushPendingCount;
    }

    static /* synthetic */ boolean access$100(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.readInProgress;
    }

    static /* synthetic */ int access$002(FlushConsolidationHandler flushConsolidationHandler, int n) {
        flushConsolidationHandler.flushPendingCount = n;
        return flushConsolidationHandler.flushPendingCount;
    }

    static /* synthetic */ Future access$202(FlushConsolidationHandler flushConsolidationHandler, Future future) {
        flushConsolidationHandler.nextScheduledFlush = future;
        return flushConsolidationHandler.nextScheduledFlush;
    }

    static /* synthetic */ ChannelHandlerContext access$300(FlushConsolidationHandler flushConsolidationHandler) {
        return flushConsolidationHandler.ctx;
    }
}

