/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolConfig;
import pro.gravit.repackage.io.netty.handler.ssl.CipherSuiteFilter;
import pro.gravit.repackage.io.netty.handler.ssl.ClientAuth;
import pro.gravit.repackage.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import pro.gravit.repackage.io.netty.handler.ssl.Java7SslParametersUtils;
import pro.gravit.repackage.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$SslEngineWrapperFactory;
import pro.gravit.repackage.io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslContext$Defaults;
import pro.gravit.repackage.io.netty.handler.ssl.ResumptionController;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
    static final String PROTOCOL = "TLS";
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;
    private final String endpointIdentificationAlgorithm;

    private static String[] defaultProtocols(SSLContext sSLContext, SSLEngine sSLEngine) {
        String[] stringArray = sSLContext.getDefaultSSLParameters().getProtocols();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(hashSet, arrayList, "TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            String string2 = "TLS_" + string.substring("SSL_".length());
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string2});
                linkedHashSet.add(string2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl, ClientAuth clientAuth) {
        this(sSLContext, bl, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, JdkDefaultApplicationProtocolNegotiator.INSTANCE, clientAuth, null, false);
    }

    @Deprecated
    public JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, applicationProtocolConfig, clientAuth, null, false);
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth, String[] stringArray, boolean bl2) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, JdkSslContext.toNegotiator(applicationProtocolConfig, !bl), clientAuth, stringArray == null ? null : (String[])stringArray.clone(), bl2);
    }

    JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl2) {
        this(sSLContext, bl, iterable, cipherSuiteFilter, jdkApplicationProtocolNegotiator, clientAuth, stringArray, bl2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdkSslContext(SSLContext sSLContext, boolean bl, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl2, String string, ResumptionController resumptionController) {
        super(bl2, resumptionController);
        List<String> list;
        Set<String> set;
        this.apn = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "apn");
        this.clientAuth = ObjectUtil.checkNotNull(clientAuth, "clientAuth");
        this.sslContext = ObjectUtil.checkNotNull(sSLContext, "sslContext");
        this.endpointIdentificationAlgorithm = string;
        if (DEFAULT_PROVIDER.equals(sSLContext.getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols(sSLContext, sSLEngine) : stringArray;
                set = JdkSslContext.supportedCiphers(sSLEngine);
                list = JdkSslContext.defaultCiphers(sSLEngine, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    for (String string2 : SslUtils.DEFAULT_TLSV13_CIPHER_SUITES) {
                        set.remove(string2);
                        list.remove(string2);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release(sSLEngine);
            }
        }
        this.cipherSuites = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(), byteBufAllocator);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(string, n), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(this.isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        this.configureEndpointVerification(sSLEngine);
        JdkApplicationProtocolNegotiator$SslEngineWrapperFactory jdkApplicationProtocolNegotiator$SslEngineWrapperFactory = this.apn.wrapperFactory();
        if (jdkApplicationProtocolNegotiator$SslEngineWrapperFactory instanceof JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator$AllocatorAwareSslEngineWrapperFactory)jdkApplicationProtocolNegotiator$SslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return jdkApplicationProtocolNegotiator$SslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    private void configureEndpointVerification(SSLEngine sSLEngine) {
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            SSLParameters sSLParameters = sSLEngine.getSSLParameters();
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(sSLParameters, this.endpointIdentificationAlgorithm);
            sSLEngine.setSSLParameters(sSLParameters);
        }
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory, String string2) {
        String string3 = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (string3 == null) {
            string3 = "SunX509";
        }
        return JdkSslContext.buildKeyManagerFactory(file, string3, file2, string, keyManagerFactory, string2);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(file, file2, string, keyManagerFactory, KeyStore.getDefaultType());
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory, String string3) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, string3);
    }

    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory) {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, KeyStore.getDefaultType());
    }

    static /* synthetic */ String[] access$100(SSLContext sSLContext, SSLEngine sSLEngine) {
        return JdkSslContext.defaultProtocols(sSLContext, sSLEngine);
    }

    static /* synthetic */ Set access$200(SSLEngine sSLEngine) {
        return JdkSslContext.supportedCiphers(sSLEngine);
    }

    static /* synthetic */ List access$300(SSLEngine sSLEngine, Set set) {
        return JdkSslContext.defaultCiphers(sSLEngine, set);
    }

    static {
        JdkSslContext$Defaults jdkSslContext$Defaults = new JdkSslContext$Defaults();
        jdkSslContext$Defaults.init();
        DEFAULT_PROVIDER = jdkSslContext$Defaults.defaultProvider;
        DEFAULT_PROTOCOLS = jdkSslContext$Defaults.defaultProtocols;
        SUPPORTED_CIPHERS = jdkSslContext$Defaults.supportedCiphers;
        DEFAULT_CIPHERS = jdkSslContext$Defaults.defaultCiphers;
        DEFAULT_CIPHERS_NON_TLSV13 = jdkSslContext$Defaults.defaultCiphersNonTLSv13;
        SUPPORTED_CIPHERS_NON_TLSV13 = jdkSslContext$Defaults.supportedCiphersNonTLSv13;
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", (Object)Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", (Object)DEFAULT_CIPHERS);
        }
    }
}

