/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.io.File;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslX509KeyManagerFactory$OpenSslKeyStore;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class OpenSslX509KeyManagerFactory
extends KeyManagerFactory {
    private final OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi spi;

    public OpenSslX509KeyManagerFactory() {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null));
    }

    public OpenSslX509KeyManagerFactory(Provider provider) {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(provider));
    }

    public OpenSslX509KeyManagerFactory(String string, Provider provider) {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(string, provider));
    }

    private OpenSslX509KeyManagerFactory(OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi openSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi) {
        super(openSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi, openSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi.kmf.getProvider(), openSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi.kmf.getAlgorithm());
        this.spi = openSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi;
    }

    private static OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(Provider provider) {
        try {
            return OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    private static OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(String string, Provider provider) {
        if (string == null) {
            string = KeyManagerFactory.getDefaultAlgorithm();
        }
        return new OpenSslX509KeyManagerFactory$OpenSslKeyManagerFactorySpi(provider == null ? KeyManagerFactory.getInstance(string) : KeyManagerFactory.getInstance(string, provider));
    }

    OpenSslKeyMaterialProvider newProvider() {
        return this.spi.newProvider();
    }

    public static OpenSslX509KeyManagerFactory newEngineBased(File file, String string) {
        return OpenSslX509KeyManagerFactory.newEngineBased(SslContext.toX509Certificates(file), string);
    }

    public static OpenSslX509KeyManagerFactory newEngineBased(X509Certificate[] x509CertificateArray, String string) {
        ObjectUtil.checkNotNull(x509CertificateArray, "certificateChain");
        OpenSslX509KeyManagerFactory$OpenSslKeyStore openSslX509KeyManagerFactory$OpenSslKeyStore = new OpenSslX509KeyManagerFactory$OpenSslKeyStore((X509Certificate[])x509CertificateArray.clone(), false, null);
        openSslX509KeyManagerFactory$OpenSslKeyStore.load(null, null);
        OpenSslX509KeyManagerFactory openSslX509KeyManagerFactory = new OpenSslX509KeyManagerFactory();
        openSslX509KeyManagerFactory.init(openSslX509KeyManagerFactory$OpenSslKeyStore, string == null ? null : string.toCharArray());
        return openSslX509KeyManagerFactory;
    }

    public static OpenSslX509KeyManagerFactory newKeyless(File file) {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(file));
    }

    public static OpenSslX509KeyManagerFactory newKeyless(InputStream inputStream) {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(inputStream));
    }

    public static OpenSslX509KeyManagerFactory newKeyless(X509Certificate ... x509CertificateArray) {
        ObjectUtil.checkNotNull(x509CertificateArray, "certificateChain");
        OpenSslX509KeyManagerFactory$OpenSslKeyStore openSslX509KeyManagerFactory$OpenSslKeyStore = new OpenSslX509KeyManagerFactory$OpenSslKeyStore((X509Certificate[])x509CertificateArray.clone(), true, null);
        openSslX509KeyManagerFactory$OpenSslKeyStore.load(null, null);
        OpenSslX509KeyManagerFactory openSslX509KeyManagerFactory = new OpenSslX509KeyManagerFactory();
        openSslX509KeyManagerFactory.init(openSslX509KeyManagerFactory$OpenSslKeyStore, null);
        return openSslX509KeyManagerFactory;
    }
}

