/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.ocsp;

import javax.net.ssl.SSLHandshakeException;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class OcspClientHandler
extends ChannelInboundHandlerAdapter {
    private final ReferenceCountedOpenSslEngine engine;

    protected OcspClientHandler(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        this.engine = ObjectUtil.checkNotNull(referenceCountedOpenSslEngine, "engine");
    }

    protected abstract boolean verify(ChannelHandlerContext var1, ReferenceCountedOpenSslEngine var2);

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SslHandshakeCompletionEvent) {
            channelHandlerContext.pipeline().remove(this);
            SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)object;
            if (sslHandshakeCompletionEvent.isSuccess() && !this.verify(channelHandlerContext, this.engine)) {
                throw new SSLHandshakeException("Bad OCSP response");
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }
}

