/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pro.gravit.repackage.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class FingerprintTrustManagerFactoryBuilder {
    private final String algorithm;
    private final List<String> fingerprints = new ArrayList<String>();

    FingerprintTrustManagerFactoryBuilder(String string) {
        this.algorithm = ObjectUtil.checkNotNull(string, "algorithm");
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(CharSequence ... charSequenceArray) {
        return this.fingerprints(Arrays.asList((Object[])ObjectUtil.checkNotNull(charSequenceArray, "fingerprints")));
    }

    public FingerprintTrustManagerFactoryBuilder fingerprints(Iterable<? extends CharSequence> iterable) {
        ObjectUtil.checkNotNull(iterable, "fingerprints");
        for (CharSequence charSequence : iterable) {
            ObjectUtil.checkNotNullWithIAE(charSequence, "fingerprint");
            this.fingerprints.add(charSequence.toString());
        }
        return this;
    }

    public FingerprintTrustManagerFactory build() {
        if (this.fingerprints.isEmpty()) {
            throw new IllegalStateException("No fingerprints provided");
        }
        return new FingerprintTrustManagerFactory(this.algorithm, FingerprintTrustManagerFactory.toFingerprintArray(this.fingerprints));
    }
}

