/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.stream;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedWriteHandler$1;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedWriteHandler$2;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedWriteHandler$3;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedWriteHandler$PendingWrite;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private Queue<ChunkedWriteHandler$PendingWrite> queue;
    private volatile ChannelHandlerContext ctx;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int n) {
        ObjectUtil.checkPositive(n, "maxPendingWrites");
    }

    private void allocateQueue() {
        if (this.queue == null) {
            this.queue = new ArrayDeque<ChunkedWriteHandler$PendingWrite>();
        }
    }

    private boolean queueIsEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            this.resumeTransfer0(channelHandlerContext);
        } else {
            channelHandlerContext.executor().execute(new ChunkedWriteHandler$1(this, channelHandlerContext));
        }
    }

    private void resumeTransfer0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.doFlush(channelHandlerContext);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while sending chunks.", exception);
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!this.queueIsEmpty() || object instanceof ChunkedInput) {
            this.allocateQueue();
            this.queue.add(new ChunkedWriteHandler$PendingWrite(object, channelPromise));
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite;
        if (this.queueIsEmpty()) {
            return;
        }
        while ((chunkedWriteHandler$PendingWrite = this.queue.poll()) != null) {
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                long l;
                boolean bl;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                try {
                    bl = chunkedInput.isEndOfInput();
                    l = chunkedInput.length();
                    ChunkedWriteHandler.closeInput(chunkedInput);
                }
                catch (Exception exception) {
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    chunkedWriteHandler$PendingWrite.fail(exception);
                    logger.warn("ChunkedInput failed", exception);
                    continue;
                }
                if (!bl) {
                    if (throwable == null) {
                        throwable = new ClosedChannelException();
                    }
                    chunkedWriteHandler$PendingWrite.fail(throwable);
                    continue;
                }
                chunkedWriteHandler$PendingWrite.success(l);
                continue;
            }
            if (throwable == null) {
                throwable = new ClosedChannelException();
            }
            chunkedWriteHandler$PendingWrite.fail(throwable);
        }
    }

    private void doFlush(ChannelHandlerContext channelHandlerContext) {
        ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite;
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            channelHandlerContext.flush();
            return;
        }
        if (this.queueIsEmpty()) {
            channelHandlerContext.flush();
            return;
        }
        boolean bl = true;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        while (channel.isWritable() && (chunkedWriteHandler$PendingWrite = this.queue.peek()) != null) {
            if (chunkedWriteHandler$PendingWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                boolean bl2;
                boolean bl3;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = (ByteBuf)chunkedInput.readChunk(byteBufAllocator);
                    bl3 = chunkedInput.isEndOfInput();
                    bl2 = byteBuf == null && !bl3;
                }
                catch (Throwable throwable) {
                    this.queue.remove();
                    if (byteBuf != null) {
                        ReferenceCountUtil.release(byteBuf);
                    }
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    chunkedWriteHandler$PendingWrite.fail(throwable);
                    break;
                }
                if (bl2) break;
                if (byteBuf == null) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                }
                if (bl3) {
                    this.queue.remove();
                }
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(byteBuf);
                if (bl3) {
                    if (channelFuture.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, chunkedInput, chunkedWriteHandler$PendingWrite);
                    } else {
                        channelFuture.addListener(new ChunkedWriteHandler$2(this, chunkedInput, chunkedWriteHandler$PendingWrite));
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = !channel.isWritable();
                    if (channelFuture.isDone()) {
                        this.handleFuture(channelFuture, chunkedInput, chunkedWriteHandler$PendingWrite, bl4);
                    } else {
                        channelFuture.addListener(new ChunkedWriteHandler$3(this, chunkedInput, chunkedWriteHandler$PendingWrite, bl4));
                    }
                }
                bl = false;
            } else {
                this.queue.remove();
                channelHandlerContext.write(object, chunkedWriteHandler$PendingWrite.promise);
                bl = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl) {
            channelHandlerContext.flush();
        }
    }

    private static void handleEndOfInputFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite) {
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            chunkedWriteHandler$PendingWrite.fail(channelFuture.cause());
        } else {
            long l = chunkedInput.progress();
            long l2 = chunkedInput.length();
            ChunkedWriteHandler.closeInput(chunkedInput);
            chunkedWriteHandler$PendingWrite.progress(l, l2);
            chunkedWriteHandler$PendingWrite.success(l2);
        }
    }

    private void handleFuture(ChannelFuture channelFuture, ChunkedInput<?> chunkedInput, ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite, boolean bl) {
        if (!channelFuture.isSuccess()) {
            ChunkedWriteHandler.closeInput(chunkedInput);
            chunkedWriteHandler$PendingWrite.fail(channelFuture.cause());
        } else {
            chunkedWriteHandler$PendingWrite.progress(chunkedInput.progress(), chunkedInput.length());
            if (bl && channelFuture.channel().isWritable()) {
                this.resumeTransfer();
            }
        }
    }

    private static void closeInput(ChunkedInput<?> chunkedInput) {
        try {
            chunkedInput.close();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to close a ChunkedInput.", throwable);
        }
    }

    static /* synthetic */ void access$000(ChunkedWriteHandler chunkedWriteHandler, ChannelHandlerContext channelHandlerContext) {
        chunkedWriteHandler.resumeTransfer0(channelHandlerContext);
    }

    static /* synthetic */ void access$100(ChannelFuture channelFuture, ChunkedInput chunkedInput, ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite) {
        ChunkedWriteHandler.handleEndOfInputFuture(channelFuture, chunkedInput, chunkedWriteHandler$PendingWrite);
    }

    static /* synthetic */ void access$200(ChunkedWriteHandler chunkedWriteHandler, ChannelFuture channelFuture, ChunkedInput chunkedInput, ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite, boolean bl) {
        chunkedWriteHandler.handleFuture(channelFuture, chunkedInput, chunkedWriteHandler$PendingWrite, bl);
    }
}

