/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.traffic;

import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalTrafficShapingHandler$1;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalTrafficShapingHandler$PerChannel;
import pro.gravit.repackage.io.netty.handler.traffic.GlobalTrafficShapingHandler$ToSend;
import pro.gravit.repackage.io.netty.handler.traffic.TrafficCounter;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

@ChannelHandler.Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, GlobalTrafficShapingHandler$PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    void createGlobalTrafficCounter(ScheduledExecutorService scheduledExecutorService) {
        TrafficCounter trafficCounter = new TrafficCounter(this, ObjectUtil.checkNotNull(scheduledExecutorService, "executor"), "GlobalTC", this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 2;
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3, long l4) {
        super(l, l2, l3, l4);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3) {
        super(l, l2, l3);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2) {
        super(l, l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l) {
        super(l);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(EventExecutor eventExecutor) {
        this.createGlobalTrafficCounter(eventExecutor);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l) {
        this.maxGlobalWriteSize = l;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private GlobalTrafficShapingHandler$PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalTrafficShapingHandler$PerChannel == null) {
            globalTrafficShapingHandler$PerChannel = new GlobalTrafficShapingHandler$PerChannel(null);
            globalTrafficShapingHandler$PerChannel.messagesQueue = new ArrayDeque();
            globalTrafficShapingHandler$PerChannel.queueSize = 0L;
            globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = globalTrafficShapingHandler$PerChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put(n, globalTrafficShapingHandler$PerChannel);
        }
        return globalTrafficShapingHandler$PerChannel;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        super.handlerAdded(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.remove(n);
        if (globalTrafficShapingHandler$PerChannel != null) {
            GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
            synchronized (globalTrafficShapingHandler$PerChannel2) {
                if (channel.isActive()) {
                    for (GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend : globalTrafficShapingHandler$PerChannel.messagesQueue) {
                        long l = this.calculateSize(globalTrafficShapingHandler$ToSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l);
                        globalTrafficShapingHandler$PerChannel.queueSize -= l;
                        this.queuesSize.addAndGet(-l);
                        channelHandlerContext.write(globalTrafficShapingHandler$ToSend.toSend, globalTrafficShapingHandler$ToSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-globalTrafficShapingHandler$PerChannel.queueSize);
                    for (GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend : globalTrafficShapingHandler$PerChannel.messagesQueue) {
                        if (!(globalTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)globalTrafficShapingHandler$ToSend.toSend).release();
                    }
                }
                globalTrafficShapingHandler$PerChannel.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    long checkWaitReadTime(ChannelHandlerContext channelHandlerContext, long l, long l2) {
        Integer n = channelHandlerContext.channel().hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalTrafficShapingHandler$PerChannel != null && l > this.maxTime && l2 + l - globalTrafficShapingHandler$PerChannel.lastReadTimestamp > this.maxTime) {
            l = this.maxTime;
        }
        return l;
    }

    @Override
    void informReadOperation(ChannelHandlerContext channelHandlerContext, long l) {
        Integer n = channelHandlerContext.channel().hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalTrafficShapingHandler$PerChannel != null) {
            globalTrafficShapingHandler$PerChannel.lastReadTimestamp = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l, long l2, long l3, ChannelPromise channelPromise) {
        GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend;
        Channel channel = channelHandlerContext.channel();
        Integer n = channel.hashCode();
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel = (GlobalTrafficShapingHandler$PerChannel)this.channelQueues.get(n);
        if (globalTrafficShapingHandler$PerChannel == null) {
            globalTrafficShapingHandler$PerChannel = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l4 = l2;
        boolean bl = false;
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
        synchronized (globalTrafficShapingHandler$PerChannel2) {
            if (l2 == 0L && globalTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l);
                channelHandlerContext.write(object, channelPromise);
                globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = l3;
                return;
            }
            if (l4 > this.maxTime && l3 + l4 - globalTrafficShapingHandler$PerChannel.lastWriteTimestamp > this.maxTime) {
                l4 = this.maxTime;
            }
            globalTrafficShapingHandler$ToSend = new GlobalTrafficShapingHandler$ToSend(l4 + l3, object, l, channelPromise, null);
            globalTrafficShapingHandler$PerChannel.messagesQueue.addLast(globalTrafficShapingHandler$ToSend);
            globalTrafficShapingHandler$PerChannel.queueSize += l;
            this.queuesSize.addAndGet(l);
            this.checkWriteSuspend(channelHandlerContext, l4, globalTrafficShapingHandler$PerChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl = true;
            }
        }
        if (bl) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l5 = globalTrafficShapingHandler$ToSend.relativeTimeAction;
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel3 = globalTrafficShapingHandler$PerChannel;
        channelHandlerContext.executor().schedule(new GlobalTrafficShapingHandler$1(this, channelHandlerContext, globalTrafficShapingHandler$PerChannel3, l5), l4, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext channelHandlerContext, GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel, long l) {
        GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel2 = globalTrafficShapingHandler$PerChannel;
        synchronized (globalTrafficShapingHandler$PerChannel2) {
            GlobalTrafficShapingHandler$ToSend globalTrafficShapingHandler$ToSend = globalTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            while (globalTrafficShapingHandler$ToSend != null) {
                long l2;
                if (globalTrafficShapingHandler$ToSend.relativeTimeAction <= l) {
                    l2 = globalTrafficShapingHandler$ToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    globalTrafficShapingHandler$PerChannel.queueSize -= l2;
                } else {
                    globalTrafficShapingHandler$PerChannel.messagesQueue.addFirst(globalTrafficShapingHandler$ToSend);
                    break;
                }
                this.queuesSize.addAndGet(-l2);
                channelHandlerContext.write(globalTrafficShapingHandler$ToSend.toSend, globalTrafficShapingHandler$ToSend.promise);
                globalTrafficShapingHandler$PerChannel.lastWriteTimestamp = l;
                globalTrafficShapingHandler$ToSend = globalTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            }
            if (globalTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    static /* synthetic */ void access$200(GlobalTrafficShapingHandler globalTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, GlobalTrafficShapingHandler$PerChannel globalTrafficShapingHandler$PerChannel, long l) {
        globalTrafficShapingHandler.sendAllValid(channelHandlerContext, globalTrafficShapingHandler$PerChannel, l);
    }
}

