/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SWARUtil;

final class AsciiStringUtil {
    static AsciiString toLowerCase(AsciiString asciiString) {
        int n;
        int n2;
        byte[] byArray = asciiString.array();
        if (!AsciiStringUtil.containsUpperCase(byArray, n2 = asciiString.arrayOffset(), n = asciiString.length())) {
            return asciiString;
        }
        byte[] byArray2 = PlatformDependent.allocateUninitializedArray(n);
        AsciiStringUtil.toLowerCase(byArray, n2, byArray2);
        return new AsciiString(byArray2, false);
    }

    private static boolean containsUpperCase(byte[] byArray, int n, int n2) {
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsUpperCase(byArray, n, n2);
        }
        int n3 = n2 >>> 3;
        for (int i = 0; i < n3; ++i) {
            long l = PlatformDependent.getLong(byArray, n);
            if (SWARUtil.containsUpperCase(l)) {
                return true;
            }
            n += 8;
        }
        return AsciiStringUtil.unrolledContainsUpperCase(byArray, n, n2 & 7);
    }

    private static boolean linearContainsUpperCase(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!AsciiStringUtil.isUpperCase(byArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean unrolledContainsUpperCase(byte[] byArray, int n, int n2) {
        assert (n2 >= 0 && n2 < 8);
        if ((n2 & 4) != 0) {
            int n3 = PlatformDependent.getInt(byArray, n);
            if (SWARUtil.containsUpperCase(n3)) {
                return true;
            }
            n += 4;
        }
        if ((n2 & 2) != 0) {
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byArray, n))) {
                return true;
            }
            if (AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byArray, n + 1))) {
                return true;
            }
            n += 2;
        }
        if ((n2 & 1) != 0) {
            return AsciiStringUtil.isUpperCase(PlatformDependent.getByte(byArray, n));
        }
        return false;
    }

    private static void toLowerCase(byte[] byArray, int n, byte[] byArray2) {
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToLowerCase(byArray, n, byArray2);
            return;
        }
        int n2 = byArray2.length;
        int n3 = n2 >>> 3;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            long l = PlatformDependent.getLong(byArray, n + n4);
            PlatformDependent.putLong(byArray2, n4, SWARUtil.toLowerCase(l));
            n4 += 8;
        }
        AsciiStringUtil.unrolledToLowerCase(byArray, n + n4, byArray2, n4, n2 & 7);
    }

    private static void linearToLowerCase(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = AsciiStringUtil.toLowerCase(byArray[n + i]);
        }
    }

    private static void unrolledToLowerCase(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        assert (n3 >= 0 && n3 < 8);
        int n5 = 0;
        if ((n3 & 4) != 0) {
            n4 = PlatformDependent.getInt(byArray, n + n5);
            PlatformDependent.putInt(byArray2, n2 + n5, SWARUtil.toLowerCase(n4));
            n5 += 4;
        }
        if ((n3 & 2) != 0) {
            n4 = PlatformDependent.getShort(byArray, n + n5);
            short s = (short)(AsciiStringUtil.toLowerCase((byte)(n4 >>> 8)) << 8 | AsciiStringUtil.toLowerCase((byte)n4));
            PlatformDependent.putShort(byArray2, n2 + n5, s);
            n5 += 2;
        }
        if ((n3 & 1) != 0) {
            PlatformDependent.putByte(byArray2, n2 + n5, AsciiStringUtil.toLowerCase(PlatformDependent.getByte(byArray, n + n5)));
        }
    }

    static AsciiString toUpperCase(AsciiString asciiString) {
        int n;
        int n2;
        byte[] byArray = asciiString.array();
        if (!AsciiStringUtil.containsLowerCase(byArray, n2 = asciiString.arrayOffset(), n = asciiString.length())) {
            return asciiString;
        }
        byte[] byArray2 = PlatformDependent.allocateUninitializedArray(n);
        AsciiStringUtil.toUpperCase(byArray, n2, byArray2);
        return new AsciiString(byArray2, false);
    }

    private static boolean containsLowerCase(byte[] byArray, int n, int n2) {
        if (!PlatformDependent.isUnaligned()) {
            return AsciiStringUtil.linearContainsLowerCase(byArray, n, n2);
        }
        int n3 = n2 >>> 3;
        for (int i = 0; i < n3; ++i) {
            long l = PlatformDependent.getLong(byArray, n);
            if (SWARUtil.containsLowerCase(l)) {
                return true;
            }
            n += 8;
        }
        return AsciiStringUtil.unrolledContainsLowerCase(byArray, n, n2 & 7);
    }

    private static boolean linearContainsLowerCase(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!AsciiStringUtil.isLowerCase(byArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean unrolledContainsLowerCase(byte[] byArray, int n, int n2) {
        assert (n2 >= 0 && n2 < 8);
        if ((n2 & 4) != 0) {
            int n3 = PlatformDependent.getInt(byArray, n);
            if (SWARUtil.containsLowerCase(n3)) {
                return true;
            }
            n += 4;
        }
        if ((n2 & 2) != 0) {
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byArray, n))) {
                return true;
            }
            if (AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byArray, n + 1))) {
                return true;
            }
            n += 2;
        }
        if ((n2 & 1) != 0) {
            return AsciiStringUtil.isLowerCase(PlatformDependent.getByte(byArray, n));
        }
        return false;
    }

    private static void toUpperCase(byte[] byArray, int n, byte[] byArray2) {
        if (!PlatformDependent.isUnaligned()) {
            AsciiStringUtil.linearToUpperCase(byArray, n, byArray2);
            return;
        }
        int n2 = byArray2.length;
        int n3 = n2 >>> 3;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            long l = PlatformDependent.getLong(byArray, n + n4);
            PlatformDependent.putLong(byArray2, n4, SWARUtil.toUpperCase(l));
            n4 += 8;
        }
        AsciiStringUtil.unrolledToUpperCase(byArray, n + n4, byArray2, n4, n2 & 7);
    }

    private static void linearToUpperCase(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = AsciiStringUtil.toUpperCase(byArray[n + i]);
        }
    }

    private static void unrolledToUpperCase(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        assert (n3 >= 0 && n3 < 8);
        int n5 = 0;
        if ((n3 & 4) != 0) {
            n4 = PlatformDependent.getInt(byArray, n + n5);
            PlatformDependent.putInt(byArray2, n2 + n5, SWARUtil.toUpperCase(n4));
            n5 += 4;
        }
        if ((n3 & 2) != 0) {
            n4 = PlatformDependent.getShort(byArray, n + n5);
            short s = (short)(AsciiStringUtil.toUpperCase((byte)(n4 >>> 8)) << 8 | AsciiStringUtil.toUpperCase((byte)n4));
            PlatformDependent.putShort(byArray2, n2 + n5, s);
            n5 += 2;
        }
        if ((n3 & 1) != 0) {
            PlatformDependent.putByte(byArray2, n2 + n5, AsciiStringUtil.toUpperCase(PlatformDependent.getByte(byArray, n + n5)));
        }
    }

    private static boolean isLowerCase(byte by) {
        return by >= 97 && by <= 122;
    }

    static boolean isUpperCase(byte by) {
        return by >= 65 && by <= 90;
    }

    static byte toLowerCase(byte by) {
        return AsciiStringUtil.isUpperCase(by) ? (byte)(by + 32) : by;
    }

    static byte toUpperCase(byte by) {
        return AsciiStringUtil.isLowerCase(by) ? (byte)(by - 32) : by;
    }

    private AsciiStringUtil() {
    }
}

