/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.util.Constant;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> clazz, String string) {
        return this.valueOf(ObjectUtil.checkNotNull(clazz, "firstNameComponent").getName() + '#' + ObjectUtil.checkNotNull(string, "secondNameComponent"));
    }

    public T valueOf(String string) {
        return this.getOrCreate(ObjectUtil.checkNonEmpty(string, "name"));
    }

    private T getOrCreate(String string) {
        T t;
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(string, t = this.newConstant(this.nextId(), string))) == null) {
            return t;
        }
        return (T)constant;
    }

    public boolean exists(String string) {
        return this.constants.containsKey(ObjectUtil.checkNonEmpty(string, "name"));
    }

    public T newInstance(String string) {
        return this.createOrThrow(ObjectUtil.checkNonEmpty(string, "name"));
    }

    private T createOrThrow(String string) {
        T t;
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(string, t = this.newConstant(this.nextId(), string))) == null) {
            return t;
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", string));
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

