/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import pro.gravit.repackage.io.netty.util.ResourceLeak;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector$TraceRecord;
import pro.gravit.repackage.io.netty.util.ResourceLeakTracker;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

final class ResourceLeakDetector$DefaultResourceLeak<T>
extends WeakReference<Object>
implements ResourceLeak,
ResourceLeakTracker<T> {
    private static final AtomicReferenceFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>, ResourceLeakDetector$TraceRecord> headUpdater;
    private static final AtomicIntegerFieldUpdater<ResourceLeakDetector$DefaultResourceLeak<?>> droppedRecordsUpdater;
    private volatile ResourceLeakDetector$TraceRecord head;
    private volatile int droppedRecords;
    private final Set<ResourceLeakDetector$DefaultResourceLeak<?>> allLeaks;
    private final int trackedHash;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResourceLeakDetector$DefaultResourceLeak(Object object, ReferenceQueue<Object> referenceQueue, Set<ResourceLeakDetector$DefaultResourceLeak<?>> set, Object object2) {
        super(object, referenceQueue);
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        this.trackedHash = System.identityHashCode(object);
        set.add(this);
        headUpdater.set(this, object2 == null ? new ResourceLeakDetector$TraceRecord(ResourceLeakDetector$TraceRecord.access$100()) : new ResourceLeakDetector$TraceRecord(ResourceLeakDetector$TraceRecord.access$100(), object2));
        this.allLeaks = set;
    }

    @Override
    public void record() {
        this.record0(null);
    }

    @Override
    public void record(Object object) {
        this.record0(object);
    }

    private void record0(Object object) {
        if (ResourceLeakDetector.access$200() > 0) {
            boolean bl;
            ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord;
            ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord2;
            ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord3;
            do {
                resourceLeakDetector$TraceRecord = resourceLeakDetector$TraceRecord3 = headUpdater.get(this);
                if (resourceLeakDetector$TraceRecord3 == null) {
                    return;
                }
                int n = ResourceLeakDetector$TraceRecord.access$300(resourceLeakDetector$TraceRecord3) + 1;
                if (n >= ResourceLeakDetector.access$200()) {
                    int n2 = Math.min(n - ResourceLeakDetector.access$200(), 30);
                    bl = PlatformDependent.threadLocalRandom().nextInt(1 << n2) != 0;
                    if (!bl) continue;
                    resourceLeakDetector$TraceRecord = ResourceLeakDetector$TraceRecord.access$400(resourceLeakDetector$TraceRecord3);
                    continue;
                }
                bl = false;
            } while (!headUpdater.compareAndSet(this, resourceLeakDetector$TraceRecord3, resourceLeakDetector$TraceRecord2 = object != null ? new ResourceLeakDetector$TraceRecord(resourceLeakDetector$TraceRecord, object) : new ResourceLeakDetector$TraceRecord(resourceLeakDetector$TraceRecord)));
            if (bl) {
                droppedRecordsUpdater.incrementAndGet(this);
            }
        }
    }

    boolean dispose() {
        this.clear();
        return this.allLeaks.remove(this);
    }

    @Override
    public boolean close() {
        if (this.allLeaks.remove(this)) {
            this.clear();
            headUpdater.set(this, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean close(T t) {
        if (!$assertionsDisabled && this.trackedHash != System.identityHashCode(t)) {
            throw new AssertionError();
        }
        try {
            boolean bl = this.close();
            return bl;
        }
        finally {
            ResourceLeakDetector$DefaultResourceLeak.reachabilityFence0(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reachabilityFence0(Object object) {
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
            }
        }
    }

    public String toString() {
        ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord = headUpdater.get(this);
        return this.generateReport(resourceLeakDetector$TraceRecord);
    }

    String getReportAndClearRecords() {
        ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord = headUpdater.getAndSet(this, null);
        return this.generateReport(resourceLeakDetector$TraceRecord);
    }

    private String generateReport(ResourceLeakDetector$TraceRecord resourceLeakDetector$TraceRecord) {
        if (resourceLeakDetector$TraceRecord == null) {
            return "";
        }
        int n = droppedRecordsUpdater.get(this);
        int n2 = 0;
        int n3 = ResourceLeakDetector$TraceRecord.access$300(resourceLeakDetector$TraceRecord) + 1;
        StringBuilder stringBuilder = new StringBuilder(n3 * 2048).append(StringUtil.NEWLINE);
        stringBuilder.append("Recent access records: ").append(StringUtil.NEWLINE);
        int n4 = 1;
        HashSet<String> hashSet = new HashSet<String>(n3);
        while (resourceLeakDetector$TraceRecord != ResourceLeakDetector$TraceRecord.access$100()) {
            String string = resourceLeakDetector$TraceRecord.toString();
            if (hashSet.add(string)) {
                if (ResourceLeakDetector$TraceRecord.access$400(resourceLeakDetector$TraceRecord) == ResourceLeakDetector$TraceRecord.access$100()) {
                    stringBuilder.append("Created at:").append(StringUtil.NEWLINE).append(string);
                } else {
                    stringBuilder.append('#').append(n4++).append(':').append(StringUtil.NEWLINE).append(string);
                }
            } else {
                ++n2;
            }
            resourceLeakDetector$TraceRecord = ResourceLeakDetector$TraceRecord.access$400(resourceLeakDetector$TraceRecord);
        }
        if (n2 > 0) {
            stringBuilder.append(": ").append(n2).append(" leak records were discarded because they were duplicates").append(StringUtil.NEWLINE);
        }
        if (n > 0) {
            stringBuilder.append(": ").append(n).append(" leak records were discarded because the leak record count is targeted to ").append(ResourceLeakDetector.access$200()).append(". Use system property ").append("pro.gravit.repackage.io.netty.leakDetection.targetRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
        }
        stringBuilder.setLength(stringBuilder.length() - StringUtil.NEWLINE.length());
        return stringBuilder.toString();
    }

    static {
        $assertionsDisabled = !ResourceLeakDetector.class.desiredAssertionStatus();
        headUpdater = AtomicReferenceFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, ResourceLeakDetector$TraceRecord.class, "head");
        droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(ResourceLeakDetector$DefaultResourceLeak.class, "droppedRecords");
    }
}

