/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

public final class SWARUtil {
    public static long compilePattern(byte by) {
        return ((long)by & 0xFFL) * 0x101010101010101L;
    }

    public static long applyPattern(long l, long l2) {
        long l3 = l ^ l2;
        long l4 = (l3 & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
        return (l4 | l3 | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int getIndex(long l, boolean bl) {
        int n = bl ? Long.numberOfLeadingZeros(l) : Long.numberOfTrailingZeros(l);
        return n >>> 3;
    }

    private static long applyUpperCasePattern(long l) {
        long l2 = l & 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x2525252525252525L;
        l2 &= 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x1A1A1A1A1A1A1A1AL;
        l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        return l2 &= 0x8080808080808080L;
    }

    private static int applyUpperCasePattern(int n) {
        int n2 = n & 0x7F7F7F7F;
        n2 += 0x25252525;
        n2 &= 0x7F7F7F7F;
        n2 += 0x1A1A1A1A;
        n2 &= ~n;
        return n2 &= 0x80808080;
    }

    private static long applyLowerCasePattern(long l) {
        long l2 = l & 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x505050505050505L;
        l2 &= 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x1A1A1A1A1A1A1A1AL;
        l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        return l2 &= 0x8080808080808080L;
    }

    private static int applyLowerCasePattern(int n) {
        int n2 = n & 0x7F7F7F7F;
        n2 += 0x5050505;
        n2 &= 0x7F7F7F7F;
        n2 += 0x1A1A1A1A;
        n2 &= ~n;
        return n2 &= 0x80808080;
    }

    public static boolean containsUpperCase(long l) {
        return SWARUtil.applyUpperCasePattern(l) != 0L;
    }

    public static boolean containsUpperCase(int n) {
        return SWARUtil.applyUpperCasePattern(n) != 0;
    }

    public static boolean containsLowerCase(long l) {
        return SWARUtil.applyLowerCasePattern(l) != 0L;
    }

    public static boolean containsLowerCase(int n) {
        return SWARUtil.applyLowerCasePattern(n) != 0;
    }

    public static long toLowerCase(long l) {
        long l2 = SWARUtil.applyUpperCasePattern(l) >>> 2;
        return l | l2;
    }

    public static int toLowerCase(int n) {
        int n2 = SWARUtil.applyUpperCasePattern(n) >>> 2;
        return n | n2;
    }

    public static long toUpperCase(long l) {
        long l2 = SWARUtil.applyLowerCasePattern(l) >>> 2;
        return l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int toUpperCase(int n) {
        int n2 = SWARUtil.applyLowerCasePattern(n) >>> 2;
        return n & ~n2;
    }

    private SWARUtil() {
    }
}

