/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class SecurityHelper$DigestAlgorithm
extends Enum<SecurityHelper$DigestAlgorithm> {
    public static final /* enum */ SecurityHelper$DigestAlgorithm PLAIN;
    public static final /* enum */ SecurityHelper$DigestAlgorithm MD5;
    public static final /* enum */ SecurityHelper$DigestAlgorithm SHA1;
    public static final /* enum */ SecurityHelper$DigestAlgorithm SHA224;
    public static final /* enum */ SecurityHelper$DigestAlgorithm SHA256;
    public static final /* enum */ SecurityHelper$DigestAlgorithm SHA512;
    private static final Map<String, SecurityHelper$DigestAlgorithm> ALGORITHMS;
    public final String name;
    public final int bits;
    public final int bytes;
    private static final /* synthetic */ SecurityHelper$DigestAlgorithm[] $VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SecurityHelper$DigestAlgorithm[] values() {
        return (SecurityHelper$DigestAlgorithm[])$VALUES.clone();
    }

    public static SecurityHelper$DigestAlgorithm valueOf(String string) {
        return Enum.valueOf(SecurityHelper$DigestAlgorithm.class, string);
    }

    private SecurityHelper$DigestAlgorithm(String string2, int n2) {
        this.name = string2;
        this.bits = n2;
        this.bytes = n2 / 8;
        if (!$assertionsDisabled && n2 % 8 != 0) {
            throw new AssertionError();
        }
    }

    public static SecurityHelper$DigestAlgorithm byName(String string) {
        return VerifyHelper.getMapValue(ALGORITHMS, string, String.format("Unknown digest algorithm: '%s'", string));
    }

    public String toString() {
        return this.name;
    }

    public byte[] verify(byte[] byArray) {
        if (byArray.length != this.bytes) {
            throw new IllegalArgumentException("Invalid digest length: " + byArray.length);
        }
        return byArray;
    }

    private static /* synthetic */ SecurityHelper$DigestAlgorithm[] $values() {
        return new SecurityHelper$DigestAlgorithm[]{PLAIN, MD5, SHA1, SHA224, SHA256, SHA512};
    }

    static {
        $assertionsDisabled = !SecurityHelper.class.desiredAssertionStatus();
        PLAIN = new SecurityHelper$DigestAlgorithm("plain", -1);
        MD5 = new SecurityHelper$DigestAlgorithm("MD5", 128);
        SHA1 = new SecurityHelper$DigestAlgorithm("SHA-1", 160);
        SHA224 = new SecurityHelper$DigestAlgorithm("SHA-224", 224);
        SHA256 = new SecurityHelper$DigestAlgorithm("SHA-256", 256);
        SHA512 = new SecurityHelper$DigestAlgorithm("SHA-512", 512);
        $VALUES = SecurityHelper$DigestAlgorithm.$values();
        SecurityHelper$DigestAlgorithm[] securityHelper$DigestAlgorithmArray = SecurityHelper$DigestAlgorithm.values();
        ALGORITHMS = new HashMap<String, SecurityHelper$DigestAlgorithm>(securityHelper$DigestAlgorithmArray.length);
        for (SecurityHelper$DigestAlgorithm securityHelper$DigestAlgorithm : securityHelper$DigestAlgorithmArray) {
            ALGORITHMS.put(securityHelper$DigestAlgorithm.name, securityHelper$DigestAlgorithm);
        }
    }
}

