/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASJReflectionHelper {
    public static final Field modifiersField;

    public static void setModifier(Field field, int mod, boolean flag) {
        try {
            field.setAccessible(true);
            int modifiers = modifiersField.getInt(field);
            modifiers = flag ? (modifiers |= mod) : (modifiers &= ~mod);
            modifiersField.setInt(field, modifiers);
        }
        catch (Throwable ex) {
            CSLog.error(ex);
        }
    }

    public static Class getCallerClass() {
        try {
            return Class.forName(ASJReflectionHelper.getCallerClassName());
        }
        catch (ClassNotFoundException ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static String getCallerClassName() {
        StackTraceElement ste = ASJReflectionHelper.getCaller();
        return ste != null ? ste.getClassName() : "java.lang.Object";
    }

    public static StackTraceElement getCaller() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String callerClassName = null;
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            String className = ste.getClassName();
            if (ASJReflectionHelper.class.getName().equals(className) || className.startsWith("java.lang.Thread")) continue;
            if (callerClassName == null) {
                callerClassName = className;
                continue;
            }
            if (callerClassName.equals(className)) continue;
            return ste;
        }
        return null;
    }

    public static Method getMethod(Class clazz, Object object) {
        Object[] aobject;
        if (object == null) {
            throw new NullPointerException("Cannot get null method!");
        }
        Class<?> c = object.getClass();
        if (c == Method.class) {
            return (Method)object;
        }
        if (c == Integer.TYPE) {
            return ASJReflectionHelper.getMethod(clazz, (Integer)object);
        }
        if (c == Object[].class && (aobject = (Object[])object).length == 2) {
            if (aobject[0] instanceof String) {
                return ASJReflectionHelper.getMethod(clazz, (String)aobject[0], (Class[])aobject[1]);
            }
            if (aobject[0] instanceof String[]) {
                return ASJReflectionHelper.getMethod(clazz, (String[])aobject[0], (Class[])aobject[1]);
            }
        }
        CSLog.error("Unable to get method specified with " + object);
        return null;
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (m != null) {
                return m;
            }
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Method getMethod(Class clazz, String[] methodNames, Class[] parameterTypes) {
        for (String methodName : methodNames) {
            Method m = ASJReflectionHelper.getMethod(clazz, methodName, parameterTypes);
            if (m == null) continue;
            return m;
        }
        CSLog.error(new NoSuchMethodException("Method not found! (Class: " + clazz + "; Expected field names: " + Arrays.toString(methodNames)));
        return null;
    }

    public static Method getMethod(Class clazz, int methodID) {
        return clazz.getDeclaredMethods()[methodID];
    }

    public static <T, R> R invokeStatic(Class<? super T> clazz, Object[] args2, Object method) {
        return ASJReflectionHelper.invoke(clazz, null, args2, method);
    }

    public static <T, R> R invoke(T instance, Object[] args2, Object method) {
        return ASJReflectionHelper.invoke(instance.getClass(), instance, args2, method);
    }

    public static <T, R> R invoke(Class<? super T> clazz, T instance, Object[] args2, Object method) {
        Method m = ASJReflectionHelper.getMethod(clazz, method);
        return ASJReflectionHelper.invoke(m, instance, args2);
    }

    public static <T, R> R invokeStatic(Class<? super T> clazz, Object[] args2, int methodID) {
        return ASJReflectionHelper.invoke(clazz, null, args2, methodID);
    }

    public static <T, R> R invoke(T instance, Object[] args2, int methodID) {
        return ASJReflectionHelper.invoke(instance.getClass(), instance, args2, methodID);
    }

    public static <T, R> R invoke(Class<? super T> clazz, T instance, Object[] args2, int methodID) {
        Method m = ASJReflectionHelper.getMethod(clazz, methodID);
        return ASJReflectionHelper.invoke(m, instance, args2);
    }

    public static <T, R> R invoke(Method method, Object instance, Object[] args2) {
        try {
            method.setAccessible(true);
            return (R)method.invoke(instance, args2);
        }
        catch (Exception ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static <T> T[] getStaticObjects(Class clazz, Class<T> fieldType, boolean subtypes) {
        return ASJReflectionHelper.getObjects(clazz, null, fieldType, subtypes);
    }

    public static <T> T[] getObjects(Class clazz, Object instance, Class<T> fieldType, boolean subtypes) {
        Field[] fields;
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                Class<?> c = field.getType();
                Object o = field.get(instance);
                if (c != fieldType && (!subtypes || !fieldType.isAssignableFrom(c))) continue;
                list.add(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list.toArray();
    }

    public static Field getField(Class clazz, String name) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Field getField(Class clazz, String ... fieldNames) {
        Field[] fields = clazz.getDeclaredFields();
        for (String fieldName : fieldNames) {
            for (Field field : fields) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
        }
        CSLog.error(new NoSuchFieldException("Field not found! (Class: " + clazz + "; Expected field names: " + Arrays.toString(fieldNames)));
        return null;
    }

    public static Field getField(Class clazz, int fieldID) {
        return clazz.getDeclaredFields()[fieldID];
    }

    public static <T, R> R getStaticValue(Class<? super T> clazz, String ... fieldNames) {
        return ASJReflectionHelper.getValue(clazz, null, fieldNames);
    }

    public static <T, R> R getValue(T instance, String ... fieldNames) {
        return ASJReflectionHelper.getValue(instance.getClass(), instance, fieldNames);
    }

    public static <T, R> R getValue(Class<? super T> clazz, T instance, String ... fieldNames) {
        Field f = ASJReflectionHelper.getField(clazz, fieldNames);
        return (R)ASJReflectionHelper.getValue(f, instance);
    }

    public static <T, R> R getStaticValue(Class<? super T> clazz, int fieldID) {
        return ASJReflectionHelper.getValue(clazz, null, fieldID);
    }

    public static <T, R> R getValue(T instance, int fieldID) {
        return ASJReflectionHelper.getValue(instance.getClass(), instance, fieldID);
    }

    public static <T, R> R getValue(Class<? super T> clazz, T instance, int fieldID) {
        Field f = ASJReflectionHelper.getField(clazz, fieldID);
        return (R)ASJReflectionHelper.getValue(f, instance);
    }

    public static <T> T getValue(Field field, Object instance) {
        return ASJReflectionHelper.getValue(field, instance, true);
    }

    public static <T> T getValue(Field field, Object instance, boolean checkAccessible) {
        try {
            if (checkAccessible) {
                field.setAccessible(true);
            }
            return (T)field.get(instance);
        }
        catch (Exception ex) {
            CSLog.error(ex);
            return null;
        }
    }

    public static <T, V> void setStaticValue(Class<? super T> clazz, V value, String ... fieldNames) {
        ASJReflectionHelper.setValue(clazz, null, value, fieldNames);
    }

    public static <T, V> void setValue(T instance, V value, String ... fieldNames) {
        ASJReflectionHelper.setValue(instance.getClass(), instance, value, fieldNames);
    }

    public static <T, V> void setValue(Class<? super T> clazz, T instance, V value, String ... fieldNames) {
        Field f = ASJReflectionHelper.getField(clazz, fieldNames);
        ASJReflectionHelper.setValue(f, instance, value);
    }

    public static <T, V> void setStaticValue(Class<? super T> clazz, V value, int fieldID) {
        ASJReflectionHelper.setValue(clazz, null, value, fieldID);
    }

    public static <T, V> void setValue(T instance, V value, int fieldID) {
        ASJReflectionHelper.setValue(instance.getClass(), instance, value, fieldID);
    }

    public static <T, V> void setValue(Class<? super T> clazz, T instance, V value, int fieldID) {
        Field f = ASJReflectionHelper.getField(clazz, fieldID);
        ASJReflectionHelper.setValue(f, instance, value);
    }

    public static <T, V> void setValue(Field field, T instance, V value) {
        ASJReflectionHelper.setValue(field, instance, value, true);
    }

    public static <T, V> void setValue(Field field, T instance, V value, boolean checkAccessible) {
        try {
            if (checkAccessible) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (Exception ex) {
            CSLog.error(ex);
        }
    }

    public static <T, V> void setStaticFinalValue(Class<? super T> clazz, V value, String ... fieldNames) {
        ASJReflectionHelper.setFinalValue(clazz, null, value, fieldNames);
    }

    public static <T, V> void setFinalValue(T instance, V value, String ... fieldNames) {
        ASJReflectionHelper.setFinalValue(instance.getClass(), instance, value, fieldNames);
    }

    public static <T, V> void setFinalValue(Class<? super T> clazz, T instance, V value, String ... fieldNames) {
        Field f = ASJReflectionHelper.getField(clazz, fieldNames);
        ASJReflectionHelper.setFinalValue(f, instance, value);
    }

    public static <T, V> void setStaticFinalValue(Class<? super T> clazz, V value, int fieldID) {
        ASJReflectionHelper.setFinalValue(clazz, null, value, fieldID);
    }

    public static <T, V> void setFinalValue(T instance, V value, int fieldID) {
        ASJReflectionHelper.setFinalValue(instance.getClass(), instance, value, fieldID);
    }

    public static <T, V> void setFinalValue(Class<? super T> clazz, T instance, V value, int fieldID) {
        Field f = ASJReflectionHelper.getField(clazz, fieldID);
        ASJReflectionHelper.setFinalValue(f, instance, value);
    }

    public static <T, V> void setFinalValue(Field field, T instance, V value) {
        ASJReflectionHelper.setFinalValue(field, instance, value, true);
    }

    public static <T, V> void setFinalValue(Field field, T instance, V value, boolean checkAccessible) {
        try {
            if (checkAccessible) {
                field.setAccessible(true);
            }
            int mods = field.getModifiers();
            modifiersField.setInt(field, mods & 0xFFFFFFEF);
            field.set(instance, value);
            modifiersField.setInt(field, mods);
        }
        catch (Exception ex) {
            CSLog.error(ex);
        }
    }

    public static <T> T createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return (T)c.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T createInstance(Class<T> c) {
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T createInstance(Class<T> c, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] == null) continue;
            parameterTypes[i] = parameters[i].getClass();
        }
        return ASJReflectionHelper.createInstance(c, parameterTypes, parameters);
    }

    public static <T> T createInstance(Class<T> c, Class[] parameterTypes, Object ... parameters) {
        try {
            Constructor<T> constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        Field f = null;
        try {
            f = Field.class.getDeclaredField("modifiers");
            f.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        modifiersField = f;
    }

    public static class CSLog {
        public static final CSLogger logger = new CSLogger();

        public static void print(String string) {
            logger.log(Level.INFO, string);
        }

        public static void info(String string) {
            logger.log(Level.INFO, string);
        }

        public static void warning(String string) {
            logger.log(Level.WARNING, string);
        }

        public static void error(String string) {
            logger.log(Level.SEVERE, string);
        }

        public static void print(Object object) {
            CSLog.print(String.valueOf(object));
        }

        public static void info(Object object) {
            CSLog.info(String.valueOf(object));
        }

        public static void warning(Object object) {
            CSLog.warning(String.valueOf(object));
        }

        public static void error(Object object) {
            CSLog.error(String.valueOf(object));
        }

        public static void error(Throwable throwable) {
            logger.log(Level.SEVERE, throwable);
        }

        public static void print(String format, Object ... args2) {
            CSLog.print(String.format(format, args2));
        }

        public static void info(String format, Object ... args2) {
            CSLog.info(String.format(format, args2));
        }

        public static void warning(String format, Object ... args2) {
            CSLog.warning(String.format(format, args2));
        }

        public static void error(String format, Object ... args2) {
            CSLog.error(String.format(format, args2));
        }

        public static class CSLogger {
            public static final Logger log = Logger.getLogger("global");

            public void log(Level level, String msg) {
                log.log(level, msg);
            }

            public void log(Level level, Throwable error) {
                log.log(level, error.getMessage(), error);
            }
        }
    }
}

