/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib;

import alexsocol.asjlib.BlockElement;
import alexsocol.asjlib.LocationElement;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2(\b\u0002\u0010\r\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ.\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f\u00a8\u0006\u0014"}, d2={"Lalexsocol/asjlib/SchemaUtils;", "", "()V", "checkStructure", "", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "structure", "", "onFail", "Lkotlin/Function4;", "", "generate", "schemaText", "loadStructure", "path", "1.7.10-ASJCore"})
public final class SchemaUtils {
    @NotNull
    public static final SchemaUtils INSTANCE;

    public final void generate(@NotNull World world, int x, int y, int z, @NotNull String schemaText) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(schemaText, "schemaText");
        Type type2 = new TypeToken<List<? extends BlockElement>>(){}.getType();
        List arr = (List)new Gson().fromJson(schemaText, type2);
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        for (BlockElement ele : arr) {
            for (LocationElement loc : ele.getLocation()) {
                TileEntity tile;
                world.func_147465_d(x + loc.getX(), y + loc.getY(), z + loc.getZ(), Block.func_149684_b((String)ele.getBlock()), loc.getMeta(), 3);
                if (loc.getNbt() == null) continue;
                NBTBase nBTBase = JsonToNBT.func_150315_a((String)loc.getNbt());
                if (nBTBase == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                }
                if (TileEntity.func_145827_c((NBTTagCompound)((NBTTagCompound)nBTBase)) == null) {
                    return;
                }
                tile.field_145851_c = x + loc.getX();
                tile.field_145848_d = y + loc.getY();
                tile.field_145849_e = z + loc.getZ();
                world.func_147455_a(x + loc.getX(), y + loc.getY(), z + loc.getZ(), tile);
            }
        }
    }

    public final boolean checkStructure(@NotNull World world, int x, int y, int z, @NotNull String structure, @Nullable Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> onFail) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(structure, "structure");
        Type type2 = new TypeToken<List<? extends BlockElement>>(){}.getType();
        List arr = (List)new Gson().fromJson(structure, type2);
        for (BlockElement ele : arr) {
            for (LocationElement loc : ele.getLocation()) {
                int k;
                int j;
                int i;
                Function0<Boolean> $fun$check$1 = new Function0<Boolean>(loc, world, i = x + loc.getX(), j = y + loc.getY(), k = z + loc.getZ(), ele){
                    final /* synthetic */ LocationElement $loc;
                    final /* synthetic */ World $world;
                    final /* synthetic */ int $i;
                    final /* synthetic */ int $j;
                    final /* synthetic */ int $k;
                    final /* synthetic */ BlockElement $ele;

                    public final boolean invoke() {
                        if (Intrinsics.areEqual(this.$world.func_147439_a(this.$i, this.$j, this.$k), Block.func_149684_b((String)this.$ele.getBlock())) ^ true || this.$world.func_72805_g(this.$i, this.$j, this.$k) != this.$loc.getMeta()) {
                            return false;
                        }
                        if (this.$loc.getNbt() == null) {
                            return true;
                        }
                        NBTBase nBTBase = JsonToNBT.func_150315_a((String)this.$loc.getNbt());
                        if (nBTBase == null) {
                            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
                        }
                        NBTTagCompound locNBT = (NBTTagCompound)nBTBase;
                        TileEntity tileEntity = this.$world.func_147438_o(this.$i, this.$j, this.$k);
                        if (tileEntity == null) {
                            return false;
                        }
                        TileEntity tile = tileEntity;
                        NBTTagCompound landNBT = new NBTTagCompound();
                        tile.func_145841_b(landNBT);
                        Map map = locNBT.field_74784_a;
                        Intrinsics.checkNotNullExpressionValue(map, "locNBT.tagMap");
                        Map map2 = map;
                        boolean bl = false;
                        for (Map.Entry<K, V> entry : map2.entrySet()) {
                            if (!(Intrinsics.areEqual(entry.getValue(), landNBT.field_74784_a.get(entry.getKey())) ^ true)) continue;
                            return false;
                        }
                        return true;
                    }
                    {
                        this.$loc = locationElement;
                        this.$world = world;
                        this.$i = n;
                        this.$j = n2;
                        this.$k = n3;
                        this.$ele = blockElement;
                        super(0);
                    }
                };
                if ($fun$check$1.invoke()) continue;
                Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> function4 = onFail;
                if (function4 != null) {
                    function4.invoke((Integer)world.field_73011_w.field_76574_g, (Integer)i, (Integer)j, (Integer)k);
                }
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean checkStructure$default(SchemaUtils schemaUtils, World world, int n, int n2, int n3, String string, Function4 function4, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            function4 = null;
        }
        return schemaUtils.checkStructure(world, n, n2, n3, string, function4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String loadStructure(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter(path, "path");
        Closeable closeable = this.getClass().getResourceAsStream("/assets/" + path);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            InputStream inputStream = it;
            Intrinsics.checkNotNullExpressionValue(inputStream, "it");
            byte[] byArray = ByteStreamsKt.readBytes(inputStream);
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            boolean bl5 = false;
            string = new String(byArray, charset);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return string;
    }

    private SchemaUtils() {
    }

    static {
        SchemaUtils schemaUtils;
        INSTANCE = schemaUtils = new SchemaUtils();
    }
}

