/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.math;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Quaternion;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 X2\u00020\u0001:\u0001XB%\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J$\u0010$\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0000J\t\u0010*\u001a\u00020\u0019H\u0086\u0002J\t\u0010+\u001a\u00020\u0019H\u0086\u0002J\t\u0010,\u001a\u00020\u0019H\u0086\u0002J\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u000e\u00100\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0000J\u001e\u00100\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u0013\u00101\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0002J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J&\u00105\u001a\u00020\u00002\b\b\u0002\u00106\u001a\u00020\u00032\b\b\u0002\u00107\u001a\u00020\u00032\b\b\u0002\u00108\u001a\u00020\u0003H\u0007J\b\u00109\u001a\u00020\u0011H\u0016J\u000e\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020\u0019J\u0006\u0010>\u001a\u00020\u0019J\u0011\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0000J$\u0010@\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u0006\u0010B\u001a\u00020\u0000J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0000J\u0006\u0010G\u001a\u00020\u0000J\u0016\u0010H\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u0000J\u000e\u0010J\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0000J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\"\u0010K\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J$\u0010M\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0007J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\b\u0010N\u001a\u00020OH\u0016J\u0006\u0010P\u001a\u00020\tJ\b\u0010Q\u001a\u00020RH\u0007J\b\u0010S\u001a\u00020TH\u0007J\u0006\u0010U\u001a\u00020\u0000J\u0006\u0010V\u001a\u00020\u0000J\u0006\u0010W\u001a\u00020\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006Y"}, d2={"Lalexsocol/asjlib/math/Vector3;", "Ljava/io/Serializable;", "d", "", "d1", "d2", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "vec", "(Lalexsocol/asjlib/math/Vector3;)V", "Lnet/minecraft/util/Vec3;", "(Lnet/minecraft/util/Vec3;)V", "F", "", "", "getF", "()[Ljava/lang/Float;", "I", "", "getI", "()[Ljava/lang/Integer;", "isAxial", "", "()Z", "isZero", "x", "", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "add", "e", "Lnet/minecraft/entity/Entity;", "te", "Lnet/minecraft/tileentity/TileEntity;", "angle", "component1", "component2", "component3", "copy", "crossProduct", "discard", "dotProduct", "equals", "other", "", "extend", "glVertex", "xOff", "yOff", "zOff", "hashCode", "isInside", "aabb", "Lnet/minecraft/util/AxisAlignedBB;", "length", "lengthSquared", "mf", "mul", "f", "negate", "normalize", "perpendicular", "project", "b", "rand", "rotate", "axis", "scalarProject", "set", "shrink", "sub", "toString", "", "toVec3", "vector3f", "Lorg/lwjgl/util/vector/Vector3f;", "vector4f", "Lorg/lwjgl/util/vector/Vector4f;", "xCrossProduct", "yCrossProduct", "zCrossProduct", "Companion", "1.7.10-ASJCore"})
public final class Vector3
implements Serializable {
    private double x;
    private double y;
    private double z;
    private static final long serialVersionUID = 84148136481306L;
    @NotNull
    private static final transient Vector3 fallback;
    @NotNull
    private static final transient Vector3 zero;
    @NotNull
    private static final transient Vector3 one;
    @NotNull
    private static final transient Vector3 center;
    @NotNull
    private static final transient Vector3 oX;
    @NotNull
    private static final transient Vector3 oY;
    @NotNull
    private static final transient Vector3 oZ;
    @NotNull
    public static final Companion Companion;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Integer[] mf() {
        return new Integer[]{ExtensionsKt.mfloor(this.x), ExtensionsKt.mfloor(this.y), ExtensionsKt.mfloor(this.z)};
    }

    @NotNull
    public final Integer[] getI() {
        return new Integer[]{ExtensionsKt.getI(this.x), ExtensionsKt.getI(this.y), ExtensionsKt.getI(this.z)};
    }

    @NotNull
    public final Float[] getF() {
        return new Float[]{Float.valueOf(ExtensionsKt.getF(this.x)), Float.valueOf(ExtensionsKt.getF(this.y)), Float.valueOf(ExtensionsKt.getF(this.z))};
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public final boolean isAxial() {
        return this.x == 0.0 ? this.y == 0.0 || this.z == 0.0 : this.y == 0.0 && this.z == 0.0;
    }

    @NotNull
    public final Vec3 toVec3() {
        Vec3 vec3 = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
        Intrinsics.checkNotNull(vec3);
        return vec3;
    }

    @NotNull
    public final Vector3 copy() {
        return new Vector3(this);
    }

    @NotNull
    public final Vector3 discard() {
        return this.set(0, 0, 0);
    }

    @NotNull
    public final Vector3 set(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x = ExtensionsKt.getD(d);
        this.y = ExtensionsKt.getD(d1);
        this.z = ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 set$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.set(number, number2, number3);
    }

    @NotNull
    public final Vector3 set(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x = e.field_70165_t;
        this.y = e.field_70163_u;
        this.z = e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 set(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x = ExtensionsKt.getD(te.field_145851_c);
        this.y = ExtensionsKt.getD(te.field_145848_d);
        this.z = ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @NotNull
    public final Vector3 rand() {
        this.x = Math.random();
        this.y = Math.random();
        this.z = Math.random();
        return this;
    }

    public final double dotProduct(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = vec.x * this.x + vec.y * this.y + vec.z * this.z;
        if (d > 1.0 && d < 1.00001) {
            d = 1.0;
        } else if (d < (double)-1 && d > -1.00001) {
            d = -1.0;
        }
        return d;
    }

    public final double dotProduct(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        return ExtensionsKt.getD(d) * this.x + ExtensionsKt.getD(d1) * this.y + ExtensionsKt.getD(d2) * this.z;
    }

    @NotNull
    public final Vector3 crossProduct(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = this.y * vec.z - this.z * vec.y;
        double d1 = this.z * vec.x - this.x * vec.z;
        double d2 = this.x * vec.y - this.y * vec.x;
        this.x = d;
        this.y = d1;
        this.z = d2;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x += ExtensionsKt.getD(d);
        this.y += ExtensionsKt.getD(d1);
        this.z += ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 add$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.add(number, number2, number3);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d, @NotNull Number d1) {
        return Vector3.add$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 add(@NotNull Number d) {
        return Vector3.add$default(this, d, null, null, 6, null);
    }

    @NotNull
    public final Vector3 add(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    @NotNull
    public final Vector3 add(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x += e.field_70165_t;
        this.y += e.field_70163_u;
        this.z += e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 add(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x += ExtensionsKt.getD(te.field_145851_c);
        this.y += ExtensionsKt.getD(te.field_145848_d);
        this.z += ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x -= ExtensionsKt.getD(d);
        this.y -= ExtensionsKt.getD(d1);
        this.z -= ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 sub$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.sub(number, number2, number3);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d, @NotNull Number d1) {
        return Vector3.sub$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 sub(@NotNull Number d) {
        return Vector3.sub$default(this, d, null, null, 6, null);
    }

    @NotNull
    public final Vector3 sub(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.x -= e.field_70165_t;
        this.y -= e.field_70163_u;
        this.z -= e.field_70161_v;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull TileEntity te) {
        Intrinsics.checkNotNullParameter(te, "te");
        this.x -= ExtensionsKt.getD(te.field_145851_c);
        this.y -= ExtensionsKt.getD(te.field_145848_d);
        this.z -= ExtensionsKt.getD(te.field_145849_e);
        return this;
    }

    @NotNull
    public final Vector3 mul(@NotNull Vector3 f) {
        Intrinsics.checkNotNullParameter(f, "f");
        this.x *= f.x;
        this.y *= f.y;
        this.z *= f.z;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x *= ExtensionsKt.getD(d);
        this.y *= ExtensionsKt.getD(d1);
        this.z *= ExtensionsKt.getD(d2);
        return this;
    }

    public static /* synthetic */ Vector3 mul$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        return vector3.mul(number, number2, number3);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d, @NotNull Number d1) {
        return Vector3.mul$default(this, d, d1, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 mul(@NotNull Number d) {
        return Vector3.mul$default(this, d, null, null, 6, null);
    }

    @NotNull
    public final Vector3 extend(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        double d2 = this.length() + ExtensionsKt.getD(d);
        double d3 = 0.0;
        boolean bl = false;
        return this.set(Vector3.mul$default(this.copy().normalize(), Math.max(d2, d3), null, null, 6, null));
    }

    @NotNull
    public final Vector3 shrink(@NotNull Number d) {
        Intrinsics.checkNotNullParameter(d, "d");
        double d2 = this.length() - ExtensionsKt.getD(d);
        double d3 = 0.0;
        boolean bl = false;
        return this.set(Vector3.mul$default(this.copy().normalize(), Math.min(d2, d3), null, null, 6, null));
    }

    public final double length() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @NotNull
    public final Vector3 normalize() {
        double d = this.length();
        if (d != 0.0) {
            Vector3.mul$default(this, 1.0 / d, null, null, 6, null);
        }
        return this;
    }

    @NotNull
    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector3(" + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ", " + new BigDecimal(this.z, cont) + ")";
    }

    @NotNull
    public final Vector3 perpendicular() {
        return this.z == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    @NotNull
    public final Vector3 xCrossProduct() {
        double d = this.z;
        double d1 = -this.y;
        this.x = 0.0;
        this.y = d;
        this.z = d1;
        return this;
    }

    @NotNull
    public final Vector3 yCrossProduct() {
        double d = -this.z;
        double d1 = this.x;
        this.x = d;
        this.y = 0.0;
        this.z = d1;
        return this;
    }

    @NotNull
    public final Vector3 zCrossProduct() {
        double d = this.y;
        double d1 = -this.x;
        this.x = d;
        this.y = d1;
        this.z = 0.0;
        return this;
    }

    public final double angle(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d = this.copy().normalize().dotProduct(vec.copy().normalize());
        boolean bl = false;
        return Math.acos(d);
    }

    public final boolean isInside(@NotNull AxisAlignedBB aabb) {
        Intrinsics.checkNotNullParameter(aabb, "aabb");
        return this.x >= aabb.field_72340_a && this.y >= aabb.field_72337_e && this.z >= aabb.field_72339_c && this.x < aabb.field_72336_d && this.y < aabb.field_72337_e && this.z < aabb.field_72334_f;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector3f vector3f() {
        return new Vector3f(ExtensionsKt.getF(this.x), ExtensionsKt.getF(this.y), ExtensionsKt.getF(this.z));
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector4f vector4f() {
        return new Vector4f(ExtensionsKt.getF(this.x), ExtensionsKt.getF(this.y), ExtensionsKt.getF(this.z), 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final Vector3 glVertex(@NotNull Number xOff, @NotNull Number yOff, @NotNull Number zOff) {
        Intrinsics.checkNotNullParameter(xOff, "xOff");
        Intrinsics.checkNotNullParameter(yOff, "yOff");
        Intrinsics.checkNotNullParameter(zOff, "zOff");
        GL11.glVertex3d((double)(this.x + ExtensionsKt.getD(xOff)), (double)(this.y + ExtensionsKt.getD(yOff)), (double)(this.z + ExtensionsKt.getD(zOff)));
        return this;
    }

    public static /* synthetic */ Vector3 glVertex$default(Vector3 vector3, Number number, Number number2, Number number3, int n, Object object) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = 0;
        }
        if ((n & 4) != 0) {
            number3 = 0;
        }
        return vector3.glVertex(number, number2, number3);
    }

    @NotNull
    public final Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final double scalarProject(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double l = b.length();
        return l == 0.0 ? 0.0 : this.dotProduct(b) / l;
    }

    @NotNull
    public final Vector3 project(@NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double l = b.lengthSquared();
        if (l == 0.0) {
            this.set(0, 0, 0);
            return this;
        }
        double m = this.dotProduct(b) / l;
        Vector3.mul$default(this.set(b), m, null, null, 6, null);
        return this;
    }

    @NotNull
    public final Vector3 rotate(@NotNull Number angle, @NotNull Vector3 axis) {
        Intrinsics.checkNotNullParameter(angle, "angle");
        Intrinsics.checkNotNullParameter(axis, "axis");
        Quaternion.Companion.aroundAxis(axis.copy().normalize(), Math.toRadians(ExtensionsKt.getD(angle))).rotate(this);
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Vector3)) {
            return false;
        }
        return this.x == ((Vector3)other).x && this.y == ((Vector3)other).y && this.z == ((Vector3)other).z;
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        result = 31 * result + Double.hashCode(this.z);
        return result;
    }

    public Vector3(@NotNull Number d, @NotNull Number d1, @NotNull Number d2) {
        Intrinsics.checkNotNullParameter(d, "d");
        Intrinsics.checkNotNullParameter(d1, "d1");
        Intrinsics.checkNotNullParameter(d2, "d2");
        this.x = ExtensionsKt.getD(d);
        this.y = ExtensionsKt.getD(d1);
        this.z = ExtensionsKt.getD(d2);
    }

    public /* synthetic */ Vector3(Number number, Number number2, Number number3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            number = 0;
        }
        if ((n & 2) != 0) {
            number2 = number;
        }
        if ((n & 4) != 0) {
            number3 = number;
        }
        this(number, number2, number3);
    }

    public Vector3(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.set(vec);
    }

    public Vector3(@NotNull Vec3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.set(vec);
    }

    static {
        Companion = new Companion(null);
        fallback = new Vector3(-1, -1, -1);
        zero = new Vector3(null, null, null, 7, null);
        one = new Vector3(1, 1, 1);
        center = new Vector3(0.5, 0.5, 0.5);
        oX = new Vector3(1, 0, 0);
        oY = new Vector3(0, 1, 0);
        oZ = new Vector3(0, 0, 1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017J\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0017J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0017J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020!J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020!J&\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(J6\u0010,\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010-\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(2\u0006\u0010.\u001a\u00020(J\u0016\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004J\u0016\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0017J\u0016\u00104\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lalexsocol/asjlib/math/Vector3$Companion;", "", "()V", "center", "Lalexsocol/asjlib/math/Vector3;", "getCenter", "()Lalexsocol/asjlib/math/Vector3;", "fallback", "getFallback", "oX", "getOX", "oY", "getOY", "oZ", "getOZ", "one", "getOne", "serialVersionUID", "", "zero", "getZero", "posYp", "", "Lnet/minecraft/entity/Entity;", "getPosYp", "(Lnet/minecraft/entity/Entity;)D", "entityDistance", "e1", "e2", "entityDistancePlane", "entityTileDistance", "e", "te", "Lnet/minecraft/tileentity/TileEntity;", "fromEntity", "fromEntityCenter", "fromTileEntity", "fromTileEntityCenter", "pointDistancePlane", "x1", "", "y1", "x2", "y2", "pointDistanceSpace", "z1", "z2", "vecDistance", "v1", "v2", "vecEntityDistance", "v", "vecTileDistance", "1.7.10-ASJCore"})
    public static final class Companion {
        @NotNull
        public final Vector3 getFallback() {
            return fallback;
        }

        @NotNull
        public final Vector3 getZero() {
            return zero;
        }

        @NotNull
        public final Vector3 getOne() {
            return one;
        }

        @NotNull
        public final Vector3 getCenter() {
            return center;
        }

        @NotNull
        public final Vector3 getOX() {
            return oX;
        }

        @NotNull
        public final Vector3 getOY() {
            return oY;
        }

        @NotNull
        public final Vector3 getOZ() {
            return oZ;
        }

        @NotNull
        public final Vector3 fromEntity(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(e.field_70165_t, this.getPosYp(e), e.field_70161_v);
        }

        @NotNull
        public final Vector3 fromEntityCenter(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(e.field_70165_t, this.getPosYp(e) - (double)e.field_70129_M + (double)(e.field_70131_O / (float)2), e.field_70161_v);
        }

        @NotNull
        public final Vector3 fromTileEntity(@NotNull TileEntity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3(ExtensionsKt.getD(e.field_145851_c), ExtensionsKt.getD(e.field_145848_d), ExtensionsKt.getD(e.field_145849_e));
        }

        @NotNull
        public final Vector3 fromTileEntityCenter(@NotNull TileEntity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Vector3((double)e.field_145851_c + 0.5, (double)e.field_145848_d + 0.5, (double)e.field_145849_e + 0.5);
        }

        public final double vecDistance(@NotNull Vector3 v1, @NotNull Vector3 v2) {
            Intrinsics.checkNotNullParameter(v1, "v1");
            Intrinsics.checkNotNullParameter(v2, "v2");
            double d = v1.getX() - v2.getX();
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = v1.getY() - v2.getY();
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = v1.getZ() - v2.getZ();
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        public final double vecEntityDistance(@NotNull Vector3 v, @NotNull Entity e) {
            Intrinsics.checkNotNullParameter(v, "v");
            Intrinsics.checkNotNullParameter(e, "e");
            double d = v.getX() - e.field_70165_t;
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = v.getY() - this.getPosYp(e);
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = v.getZ() - e.field_70161_v;
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        public final double vecTileDistance(@NotNull Vector3 v, @NotNull TileEntity te) {
            Intrinsics.checkNotNullParameter(v, "v");
            Intrinsics.checkNotNullParameter(te, "te");
            double d = v.getX() - (double)te.field_145851_c + 0.5;
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = v.getY() - (double)te.field_145848_d + 0.5;
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = v.getZ() - (double)te.field_145849_e + 0.5;
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        public final double entityTileDistance(@NotNull Entity e, @NotNull TileEntity te) {
            Intrinsics.checkNotNullParameter(e, "e");
            Intrinsics.checkNotNullParameter(te, "te");
            double d = e.field_70165_t - (double)te.field_145851_c + 0.5;
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = this.getPosYp(e) - (double)te.field_145848_d + 0.5;
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = e.field_70161_v - (double)te.field_145849_e + 0.5;
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        public final double entityDistance(@NotNull Entity e1, @NotNull Entity e2) {
            Intrinsics.checkNotNullParameter(e1, "e1");
            Intrinsics.checkNotNullParameter(e2, "e2");
            double d = e1.field_70165_t - e2.field_70165_t;
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = this.getPosYp(e1) - this.getPosYp(e2);
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = e1.field_70161_v - e2.field_70161_v;
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        public final double entityDistancePlane(@NotNull Entity e1, @NotNull Entity e2) {
            Intrinsics.checkNotNullParameter(e1, "e1");
            Intrinsics.checkNotNullParameter(e2, "e2");
            double d = e1.field_70165_t - e2.field_70165_t;
            double d2 = e1.field_70161_v - e2.field_70161_v;
            boolean bl = false;
            return Math.hypot(d, d2);
        }

        public final double pointDistancePlane(@NotNull Number x1, @NotNull Number y1, @NotNull Number x2, @NotNull Number y2) {
            Intrinsics.checkNotNullParameter(x1, "x1");
            Intrinsics.checkNotNullParameter(y1, "y1");
            Intrinsics.checkNotNullParameter(x2, "x2");
            Intrinsics.checkNotNullParameter(y2, "y2");
            double d = ExtensionsKt.getD(x1) - ExtensionsKt.getD(x2);
            double d2 = ExtensionsKt.getD(y1) - ExtensionsKt.getD(y2);
            boolean bl = false;
            return Math.hypot(d, d2);
        }

        public final double pointDistanceSpace(@NotNull Number x1, @NotNull Number y1, @NotNull Number z1, @NotNull Number x2, @NotNull Number y2, @NotNull Number z2) {
            Intrinsics.checkNotNullParameter(x1, "x1");
            Intrinsics.checkNotNullParameter(y1, "y1");
            Intrinsics.checkNotNullParameter(z1, "z1");
            Intrinsics.checkNotNullParameter(x2, "x2");
            Intrinsics.checkNotNullParameter(y2, "y2");
            Intrinsics.checkNotNullParameter(z2, "z2");
            double d = ExtensionsKt.getD(x1) - ExtensionsKt.getD(x2);
            int n = 2;
            boolean bl = false;
            double d2 = Math.pow(d, n);
            d = ExtensionsKt.getD(y1) - ExtensionsKt.getD(y2);
            n = 2;
            bl = false;
            double d3 = d2 + Math.pow(d, n);
            d = ExtensionsKt.getD(z1) - ExtensionsKt.getD(z2);
            n = 2;
            bl = false;
            d = d3 + Math.pow(d, n);
            n = 0;
            return Math.sqrt(d);
        }

        private final double getPosYp(Entity $this$posYp) {
            return $this$posYp.field_70163_u - (ASJUtilities.isClient() && ExtensionsClientKt.getMc().field_71439_g == $this$posYp ? 1.62 : 0.0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

