/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.ExtensionsKt;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010\u0010\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lalexsocol/asjlib/render/ASJShaderHelper;", "", "()V", "FRAG", "", "VERT", "crashOnError", "", "getCrashOnError", "()Z", "setCrashOnError", "(Z)V", "createProgram", "vertLocation", "", "fragLocation", "createProgramInner", "createShader", "filename", "shaderType", "getProgramLogInfo", "obj", "getShaderLogInfo", "readFileAsString", "releaseShader", "", "useShader", "shaderID", "callback", "Lkotlin/Function1;", "ShaderCallback", "1.7.10-ASJCore"})
public final class ASJShaderHelper {
    private static boolean crashOnError;
    private static final int FRAG = 35632;
    private static final int VERT = 35633;
    @NotNull
    public static final ASJShaderHelper INSTANCE;

    public final boolean getCrashOnError() {
        return crashOnError;
    }

    public final void setCrashOnError(boolean bl) {
        crashOnError = bl;
    }

    @JvmOverloads
    public final void useShader(int shaderID, @Nullable Function1<? super Integer, Unit> callback) {
        block3: {
            if (!OpenGlHelper.field_148824_g) {
                return;
            }
            GL20.glUseProgram((int)shaderID);
            if (shaderID == 0) break block3;
            if (Minecraft.func_71410_x().field_71441_e != null) {
                int n = GL20.glGetUniformLocation((int)shaderID, (CharSequence)"time");
                WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
                Intrinsics.checkNotNullExpressionValue(worldClient, "Minecraft.getMinecraft().theWorld");
                GL20.glUniform1i((int)n, (int)ExtensionsKt.getI(worldClient.func_82737_E() / (long)20));
                int n2 = GL20.glGetUniformLocation((int)shaderID, (CharSequence)"ftime");
                WorldClient worldClient2 = Minecraft.func_71410_x().field_71441_e;
                Intrinsics.checkNotNullExpressionValue(worldClient2, "Minecraft.getMinecraft().theWorld");
                GL20.glUniform1f((int)n2, (float)((float)worldClient2.func_82737_E() / 20.0f));
            }
            Function1<? super Integer, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke((Integer)shaderID);
            }
        }
    }

    public static /* synthetic */ void useShader$default(ASJShaderHelper aSJShaderHelper, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = null;
        }
        aSJShaderHelper.useShader(n, function1);
    }

    @JvmOverloads
    public final void useShader(int shaderID) {
        ASJShaderHelper.useShader$default(this, shaderID, null, 2, null);
    }

    public final void releaseShader() {
        ASJShaderHelper.useShader$default(this, 0, null, 2, null);
    }

    public final int createProgram(@Nullable String vertLocation, @Nullable String fragLocation) {
        int n;
        try {
            n = this.createProgramInner(vertLocation, fragLocation);
        }
        catch (Throwable e) {
            if (crashOnError) {
                throw e;
            }
            n = 0;
        }
        return n;
    }

    private final int createProgramInner(String vertLocation, String fragLocation) {
        String info;
        boolean bl;
        CharSequence charSequence;
        if (!OpenGlHelper.field_148824_g) {
            return 0;
        }
        int vertID = 0;
        int fragID = 0;
        int programID = GL20.glCreateProgram();
        if (programID == 0) {
            return 0;
        }
        if (vertLocation != null) {
            charSequence = vertLocation;
            bl = false;
            if (charSequence.length() > 0) {
                vertID = this.createShader(vertLocation, 35633);
                GL20.glAttachShader((int)programID, (int)vertID);
            }
        }
        if (fragLocation != null) {
            charSequence = fragLocation;
            bl = false;
            if (charSequence.length() > 0) {
                fragID = this.createShader(fragLocation, 35632);
                GL20.glAttachShader((int)programID, (int)fragID);
            }
        }
        GL20.glLinkProgram((int)programID);
        if (GL20.glGetProgrami((int)programID, (int)35714) == 0) {
            info = this.getProgramLogInfo(programID);
            GL20.glDeleteProgram((int)programID);
            throw (Throwable)new RuntimeException("Error Linking program [" + vertLocation + " x " + fragLocation + "]: " + info);
        }
        GL20.glValidateProgram((int)programID);
        if (GL20.glGetProgrami((int)programID, (int)35715) == 0) {
            info = this.getProgramLogInfo(programID);
            GL20.glDeleteProgram((int)programID);
            throw (Throwable)new RuntimeException("Error Validating program [" + vertLocation + " x " + fragLocation + "]: " + info);
        }
        return programID;
    }

    private final int createShader(String filename, int shaderType) {
        int shaderID = 0;
        try {
            shaderID = GL20.glCreateShader((int)shaderType);
            if (shaderID == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shaderID, (CharSequence)this.readFileAsString(filename));
            GL20.glCompileShader((int)shaderID);
            if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
                throw (Throwable)new RuntimeException("Error Compiling shader [" + filename + "]: " + this.getShaderLogInfo(shaderID));
            }
            return shaderID;
        }
        catch (Exception e) {
            GL20.glDeleteShader((int)shaderID);
            e.printStackTrace();
            return -1;
        }
    }

    private final String getShaderLogInfo(int obj) {
        String string = GL20.glGetShaderInfoLog((int)obj, (int)GL20.glGetShaderi((int)obj, (int)35716));
        Intrinsics.checkNotNullExpressionValue(string, "glGetShaderInfoLog(obj, \u2026obj, GL_INFO_LOG_LENGTH))");
        return string;
    }

    private final String getProgramLogInfo(int obj) {
        String string = GL20.glGetProgramInfoLog((int)obj, (int)GL20.glGetProgrami((int)obj, (int)35716));
        Intrinsics.checkNotNullExpressionValue(string, "glGetProgramInfoLog(obj,\u2026obj, GL_INFO_LOG_LENGTH))");
        return string;
    }

    private final String readFileAsString(String filename) throws Exception {
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkNotNullExpressionValue(minecraft, "Minecraft.getMinecraft()");
        IResourceManager iResourceManager = minecraft.func_110442_L();
        ModContainer modContainer = Loader.instance().activeModContainer();
        Intrinsics.checkNotNullExpressionValue(modContainer, "Loader.instance().activeModContainer()");
        IResource iResource = iResourceManager.func_110536_a(new ResourceLocation(modContainer.getModId(), filename));
        Intrinsics.checkNotNullExpressionValue(iResource, "Minecraft.getMinecraft()\u2026ainer().modId, filename))");
        BufferedReader in = new BufferedReader(new InputStreamReader(iResource.func_110527_b(), "UTF-8"));
        StringBuilder source = new StringBuilder();
        while (in.ready()) {
            source.append(in.readLine()).append("\r\n");
        }
        String string = source.toString();
        Intrinsics.checkNotNullExpressionValue(string, "source.toString()");
        return string;
    }

    private ASJShaderHelper() {
    }

    static {
        ASJShaderHelper aSJShaderHelper;
        INSTANCE = aSJShaderHelper = new ASJShaderHelper();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lalexsocol/asjlib/render/ASJShaderHelper$ShaderCallback;", "", "()V", "call", "", "shaderID", "", "1.7.10-ASJCore"})
    public static abstract class ShaderCallback {
        public abstract void call(int var1);
    }
}

