/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.render;

import alexsocol.asjlib.render.ASJShaderHelper;
import alexsocol.asjlib.render.ShadedObject;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lalexsocol/asjlib/render/RenderPostShaders;", "", "()V", "allowShaders", "", "getAllowShaders", "()Z", "setAllowShaders", "(Z)V", "nextAvailableRenderObjectMaterialID", "", "getNextAvailableRenderObjectMaterialID", "()I", "renderObjectMaterialID", "shaders", "Ljava/util/ArrayList;", "Lalexsocol/asjlib/render/ShadedObject;", "getShaders", "()Ljava/util/ArrayList;", "dispatchObjects", "", "registerShadedObject", "renobj", "RendererPostShaders", "1.7.10-ASJCore"})
public final class RenderPostShaders {
    private static boolean allowShaders;
    @NotNull
    private static final ArrayList<ShadedObject> shaders;
    private static int renderObjectMaterialID;
    @NotNull
    public static final RenderPostShaders INSTANCE;

    public final boolean getAllowShaders() {
        return allowShaders;
    }

    public final void setAllowShaders(boolean bl) {
        allowShaders = bl;
    }

    @NotNull
    public final ArrayList<ShadedObject> getShaders() {
        return shaders;
    }

    public final int getNextAvailableRenderObjectMaterialID() {
        int n = renderObjectMaterialID;
        renderObjectMaterialID = n + 1;
        return n;
    }

    public final void registerShadedObject(@NotNull ShadedObject renobj) {
        Intrinsics.checkNotNullParameter(renobj, "renobj");
        shaders.add(renobj);
    }

    public final void dispatchObjects() {
        if (shaders.isEmpty()) {
            return;
        }
        CollectionsKt.sort((List)shaders);
        boolean post = false;
        int prevShader = 0;
        int prevMaterial = -1;
        ShadedObject shadedObject = shaders.get(0);
        Intrinsics.checkNotNullExpressionValue(shadedObject, "shaders[0]");
        ShadedObject prevObj = shadedObject;
        if (prevObj.getTexture() != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(prevObj.getTexture());
        }
        for (ShadedObject obj : shaders) {
            if (obj.getTranslations().isEmpty()) continue;
            if (post && obj.getMaterialID() != prevObj.getMaterialID()) {
                prevObj.postRender();
            }
            if (obj.getShaderID() != prevShader) {
                if (allowShaders) {
                    ASJShaderHelper.useShader$default(ASJShaderHelper.INSTANCE, obj.getShaderID(), null, 2, null);
                }
                prevShader = obj.getShaderID();
            }
            if (obj.getMaterialID() != prevMaterial) {
                obj.preRender();
            }
            if (obj.getTexture() != null && obj.getTexture() != prevObj.getTexture()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(obj.getTexture());
            }
            obj.doRender();
            obj.getTranslations().clear();
            Intrinsics.checkNotNullExpressionValue(obj, "obj");
            post = true;
        }
        if (post) {
            prevObj.postRender();
        }
        if (allowShaders) {
            ASJShaderHelper.INSTANCE.releaseShader();
        }
    }

    private RenderPostShaders() {
    }

    static {
        RenderPostShaders renderPostShaders;
        INSTANCE = renderPostShaders = new RenderPostShaders();
        allowShaders = true;
        shaders = new ArrayList();
        MinecraftForge.EVENT_BUS.register((Object)new RendererPostShaders());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lalexsocol/asjlib/render/RenderPostShaders$RendererPostShaders;", "", "()V", "onWorldLastRender", "", "e", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "1.7.10-ASJCore"})
    public static final class RendererPostShaders {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public final void onWorldLastRender(@NotNull RenderWorldLastEvent e) {
            Intrinsics.checkNotNullParameter(e, "e");
            INSTANCE.dispatchObjects();
        }
    }
}

