/*
 * Decompiled with CFR 0.152.
 */
package alexsocol.asjlib.security;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.security.ISecurityManager;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002\"-\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"securityManagers", "Ljava/util/HashMap;", "", "Lalexsocol/asjlib/security/ISecurityManager;", "Lkotlin/collections/HashMap;", "getSecurityManagers", "()Ljava/util/HashMap;", "registerSecurityManager", "", "man", "name", "1.7.10-ASJCore"})
public final class InteractionSecurityKt {
    @NotNull
    private static final HashMap<String, ISecurityManager> securityManagers = new HashMap();

    @NotNull
    public static final HashMap<String, ISecurityManager> getSecurityManagers() {
        return securityManagers;
    }

    public static final void registerSecurityManager(@NotNull ISecurityManager man, @NotNull String name) {
        Intrinsics.checkNotNullParameter(man, "man");
        Intrinsics.checkNotNullParameter(name, "name");
        if (StringsKt.isBlank(name)) {
            throw (Throwable)new IllegalArgumentException("Name should not be blank");
        }
        if (securityManagers.containsKey(name)) {
            throw (Throwable)new IllegalArgumentException("Security Manager \"" + name + "\" is already registered");
        }
        ASJUtilities.log("Registering security manager with name \"" + name + '\"');
        ((Map)securityManagers).put(name, man);
    }
}

