/*
 * Decompiled with CFR 0.152.
 */
package ru.vamig.worldengine.standardcustomgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import ru.vamig.worldengine.standardcustomgen.help.WE_BigTreeGen;
import ru.vamig.worldengine.standardcustomgen.help.WE_TreeGen;

public class WE_WorldTreeGen
implements IWorldGenerator {
    public final List<WE_TreeGen> smallTrees = new ArrayList<WE_TreeGen>();
    public final List<WE_BigTreeGen> bigTrees = new ArrayList<WE_BigTreeGen>();
    public final List<Integer> dispersions = new ArrayList<Integer>();
    public final List<Integer> treesPerChunkCounts = new ArrayList<Integer>();
    public final List<Integer> chanceForBigTree = new ArrayList<Integer>();

    public void add(Block wood, int woodMeta, Block leaves, int leavesMeta, Block sapling, Block vines, Block cocoa, int dispersion, int perChunk, int chanceForBig, int minHeight, boolean doVinesLog, boolean doVinesLeaves, byte ocp1, byte ocp2, byte ocp3, byte ocp4, byte ocp5, byte ocp6, int ts, int hl, int ldl, double ha, double bs, double sw, double ld) {
        this.smallTrees.add(new WE_TreeGen(false));
        this.bigTrees.add(new WE_BigTreeGen(false));
        this.dispersions.add(dispersion);
        this.treesPerChunkCounts.add(perChunk);
        this.chanceForBigTree.add(chanceForBig);
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bWood = wood;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).metaWood = woodMeta;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bLeaves = leaves;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).metaLeaves = leavesMeta;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bSapling = sapling;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bVine = vines;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bCocoa = cocoa;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).bWood = wood;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).metaWood = woodMeta;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).bLeaves = leaves;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).metaLeaves = leavesMeta;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).bSapling = sapling;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).minTreeHeight = minHeight;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).vinesGrowLog = doVinesLog;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).vinesGrowLeaves = doVinesLeaves;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).otherCoordPairs = new byte[]{ocp1, ocp2, ocp3, ocp4, ocp5, ocp6};
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).trunkSize = ts;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).heightLimitLimit = hl;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).leafDistanceLimit = ldl;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).heightAttenuation = ha;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).branchSlope = bs;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).scaleWidth = sw;
        this.bigTrees.get((int)(this.bigTrees.size() - 1)).leafDensity = ld;
    }

    public void add(Block bWood, int mWood, Block bLeaves, int mLeaves, Block bSapling, Block bVine, Block bCocoa, int v1, int v2, int minHeight, boolean vines) {
        this.smallTrees.add(new WE_TreeGen(false));
        this.bigTrees.add(null);
        this.dispersions.add(v1);
        this.treesPerChunkCounts.add(v2);
        this.chanceForBigTree.add(0);
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bWood = bWood;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).metaWood = mWood;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bLeaves = bLeaves;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).metaLeaves = mLeaves;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bSapling = bSapling;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bVine = bVine;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).bCocoa = bCocoa;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).minTreeHeight = minHeight;
        this.smallTrees.get((int)(this.smallTrees.size() - 1)).vinesGrowLeaves = vines;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < this.smallTrees.size(); ++i) {
            if (random.nextInt(this.dispersions.get(i)) != 0) continue;
            for (int i2 = 0; i2 < this.treesPerChunkCounts.get(i); ++i2) {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                int y = world.func_72976_f(x, z);
                if (this.chanceForBigTree.get(i) <= 0) {
                    this.smallTrees.get(i).func_76484_a(world, random, x, y, z);
                    continue;
                }
                if (random.nextInt(this.chanceForBigTree.get(i)) == 0) {
                    this.bigTrees.get(i).func_76484_a(world, random, x, y, z);
                    continue;
                }
                this.smallTrees.get(i).func_76484_a(world, random, x, y, z);
            }
        }
    }
}

