/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import alfheim.api.lib.LibRenderIDs;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.base.BlockContainerMod;
import alfheim.common.block.tile.TileAnomalyHarvester;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016JP\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016JP\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0016JB\u0010\u001b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\fH\u0016\u00a8\u0006\u001f"}, d2={"Lalfheim/common/block/BlockAnomalyHarvester;", "Lalfheim/common/block/base/BlockContainerMod;", "Lvazkii/botania/api/wand/IWandable;", "()V", "createNewTileEntity", "Lalfheim/common/block/tile/TileAnomalyHarvester;", "world", "Lnet/minecraft/world/World;", "meta", "", "getRenderType", "isOpaqueCube", "", "onBlockActivated", "x", "y", "z", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "side", "hitX", "", "hitY", "hitZ", "onBlockClicked", "", "onBlockPlaced", "onUsedByWand", "stack", "Lnet/minecraft/item/ItemStack;", "renderAsNormalBlock", "Alfheim"})
public final class BlockAnomalyHarvester
extends BlockContainerMod
implements IWandable {
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return LibRenderIDs.INSTANCE.getIdHarvester();
    }

    @NotNull
    public TileAnomalyHarvester createNewTileEntity(@NotNull World world, int meta) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new TileAnomalyHarvester();
    }

    public int func_149660_a(@NotNull World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullExpressionValue((Object)ForgeDirection.VALID_DIRECTIONS, (String)"ForgeDirection.VALID_DIRECTIONS");
        return ((ForgeDirection)ExtensionsKt.safeGet((Object[])ForgeDirection.VALID_DIRECTIONS, (int)side)).ordinal();
    }

    public void func_149699_a(@NotNull World world, int x, int y, int z, @Nullable EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        EntityPlayer entityPlayer = player;
        if ((entityPlayer != null && (entityPlayer = entityPlayer.func_70694_bm()) != null ? entityPlayer.func_77973_b() : null) != ModItems.twigWand) {
            super.func_149699_a(world, x, y, z, player);
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        world.func_72921_c(x, y, z, ++meta % 6, 3);
    }

    public boolean func_149727_a(@NotNull World world, int x, int y, int z, @NotNull EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.func_71045_bC();
        if ((itemStack != null ? itemStack.func_77973_b() : null) == ModItems.twigWand) {
            ItemStack itemStack2 = player.func_71045_bC();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"player.currentEquippedItem");
            return itemStack2.func_77973_b().func_77648_a(player.func_71045_bC(), player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileAnomalyHarvester)) {
            tileEntity = null;
        }
        TileAnomalyHarvester tileAnomalyHarvester = (TileAnomalyHarvester)tileEntity;
        if (tileAnomalyHarvester == null) {
            return false;
        }
        TileAnomalyHarvester tile = tileAnomalyHarvester;
        ItemStack itemStack3 = player.func_71045_bC();
        if ((itemStack3 != null ? itemStack3.func_77973_b() : null) == ExtensionsKt.toItem((Block)AlfheimBlocks.INSTANCE.getAnomaly())) {
            String main = ItemNBTHelper.getString((ItemStack)player.func_71045_bC(), (String)"subTileMain", (String)"");
            if (!AlfheimAPI.INSTANCE.getAnomalyBehaviors().containsKey(main)) {
                return false;
            }
            String string = main;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"main");
            tile.addSubTile(string);
            return true;
        }
        if (player.func_71045_bC() != null) {
            return false;
        }
        double d = 0.0;
        double d2 = tile.getPower() + (double)(player.func_70093_af() ? -1 : 1);
        boolean bl = false;
        tile.setPower(Math.max(d, d2));
        if (!world.field_72995_K) {
            ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.power", (Object[])new Object[]{tile.getPower()});
        }
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)tile);
        return true;
    }

    public boolean onUsedByWand(@Nullable EntityPlayer player, @NotNull ItemStack stack, @NotNull World world, int x, int y, int z, int side) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (player == null) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileAnomalyHarvester)) {
            tileEntity = null;
        }
        TileAnomalyHarvester tileAnomalyHarvester = (TileAnomalyHarvester)tileEntity;
        if (tileAnomalyHarvester == null) {
            return false;
        }
        TileAnomalyHarvester tile = tileAnomalyHarvester;
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            double d = 1.0;
            double d2 = tile.getRadius().getX() + (double)fd.offsetX;
            boolean bl = false;
            Number number = Math.max(d, d2);
            d = 1.0;
            d2 = tile.getRadius().getY() + (double)fd.offsetY;
            bl = false;
            Number number2 = Math.max(d, d2);
            d = 1.0;
            d2 = tile.getRadius().getZ() + (double)fd.offsetZ;
            bl = false;
            Vector3 vector3 = tile.getRadius().set(number, number2, (Number)Math.max(d, d2));
            boolean bl2 = false;
            boolean bl3 = false;
            Vector3 it = vector3;
            boolean bl4 = false;
            if (!world.field_72995_K) {
                ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.area", (Object[])new Object[]{it.getX(), it.getY(), it.getZ()});
            }
        } else {
            Vector3 vector3 = tile.getOffset().add((Number)((double)fd.offsetX * 0.5), (Number)((double)fd.offsetY * 0.5), (Number)((double)fd.offsetZ * 0.5));
            boolean bl = false;
            boolean bl5 = false;
            Vector3 it = vector3;
            boolean bl6 = false;
            if (!world.field_72995_K) {
                ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.offset", (Object[])new Object[]{it.getX(), it.getY(), it.getZ()});
            }
        }
        ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)tile);
        return true;
    }

    public BlockAnomalyHarvester() {
        Material material = Material.field_151573_f;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"Material.iron");
        super(material);
        this.func_149663_c("AnomalyHarvester");
        this.func_149713_g(0);
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(Block.field_149777_j);
    }
}

