/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alexsocol.asjlib.math.Vector3;
import alfheim.api.AlfheimAPI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.Botania;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020!J\b\u0010+\u001a\u00020!H\u0016J\u0010\u0010,\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lalfheim/common/block/tile/TileAnomalyHarvester;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "()V", "offset", "Lalexsocol/asjlib/math/Vector3;", "getOffset", "()Lalexsocol/asjlib/math/Vector3;", "setOffset", "(Lalexsocol/asjlib/math/Vector3;)V", "power", "", "getPower", "()D", "setPower", "(D)V", "radius", "getRadius", "setRadius", "subTiles", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "tick", "", "getTick", "()J", "setTick", "(J)V", "tunnels", "", "getTunnels", "()Ljava/util/Set;", "addSubTile", "", "sub", "canUpdate", "", "getAoE", "Lnet/minecraft/util/AxisAlignedBB;", "readCustomNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "renderBoundBox", "updateEntity", "writeCustomNBT", "Alfheim"})
public final class TileAnomalyHarvester
extends ASJTile {
    @NotNull
    private Vector3 radius = new Vector3((Number)1.0, null, null, 6, null);
    @NotNull
    private Vector3 offset = new Vector3(null, null, null, 7, null);
    private double power = 1.0;
    private long tick = -1L;
    private HashSet<String> subTiles = new HashSet();
    @NotNull
    private final Set<String> tunnels = SetsKt.setOf((Object[])new String[]{"Antigrav", "Gravity"});

    @NotNull
    public final Vector3 getRadius() {
        return this.radius;
    }

    public final void setRadius(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.radius = vector3;
    }

    @NotNull
    public final Vector3 getOffset() {
        return this.offset;
    }

    public final void setOffset(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.offset = vector3;
    }

    public final double getPower() {
        return this.power;
    }

    public final void setPower(double d) {
        this.power = d;
    }

    public final long getTick() {
        return this.tick;
    }

    public final void setTick(long l) {
        this.tick = l;
    }

    public final void addSubTile(@NotNull String sub) {
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        if (this.subTiles.contains(sub)) {
            return;
        }
        this.subTiles.add(sub);
    }

    public boolean canUpdate() {
        World world = this.field_145850_b;
        return world == null || world.func_82737_E() != this.tick;
    }

    @NotNull
    public final Set<String> getTunnels() {
        return this.tunnels;
    }

    public void func_145845_h() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"worldObj");
        if (world.func_82737_E() == this.tick) {
            return;
        }
        World world2 = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world2, (String)"worldObj");
        this.tick = world2.func_82737_E();
        World world3 = this.field_145850_b;
        Intrinsics.checkNotNullExpressionValue((Object)world3, (String)"worldObj");
        if (ExtensionsKt.isBlockDirectlyGettingPowered((World)world3, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e) || this.power <= 0.0) {
            return;
        }
        boolean tunnel = this.subTiles.containsAll((Collection)this.tunnels);
        if (tunnel) {
            Function1<TileAnomalyHarvester, Unit> function1 = AlfheimAPI.INSTANCE.getAnomalyBehaviors().get("Tunnel");
            Intrinsics.checkNotNull(function1);
            function1.invoke((Object)this);
        }
        for (String st : this.subTiles) {
            if (tunnel && this.tunnels.contains(st)) continue;
            Function1<TileAnomalyHarvester, Unit> function1 = AlfheimAPI.INSTANCE.getAnomalyBehaviors().get(st);
            if (function1 == null) continue;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
        }
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.renderBoundBox();
    }

    @NotNull
    public final AxisAlignedBB getAoE() {
        AxisAlignedBB axisAlignedBB = ExtensionsKt.getBoundingBox((Number)this.field_145851_c, (Number)this.field_145848_d, (Number)this.field_145849_e).func_72314_b(this.radius.getX() / (double)2, this.radius.getY() / (double)2, this.radius.getZ() / (double)2).func_72325_c(this.offset.getX() + 0.5, this.offset.getY() + 0.5, this.offset.getZ() + 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)axisAlignedBB, (String)"getBoundingBox(xCoord, y\u2026.y + 0.5, offset.z + 0.5)");
        return axisAlignedBB;
    }

    public final void renderBoundBox() {
        AxisAlignedBB aabb = this.getAoE();
        double i = 0.0;
        for (i = aabb.field_72340_a; i <= aabb.field_72336_d; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i, aabb.field_72338_b, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72340_a; i <= aabb.field_72336_d; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i, aabb.field_72337_e, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72340_a; i <= aabb.field_72336_d; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i, aabb.field_72337_e, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72340_a; i <= aabb.field_72336_d; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, i, aabb.field_72338_b, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72338_b; i <= aabb.field_72337_e; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, i, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72338_b; i <= aabb.field_72337_e; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, i, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72338_b; i <= aabb.field_72337_e; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, i, aabb.field_72339_c, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72338_b; i <= aabb.field_72337_e; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, i, aabb.field_72334_f, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72339_c; i <= aabb.field_72334_f; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, aabb.field_72338_b, i, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72339_c; i <= aabb.field_72334_f; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, aabb.field_72337_e, i, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72339_c; i <= aabb.field_72334_f; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72336_d, aabb.field_72338_b, i, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
        for (i = aabb.field_72339_c; i <= aabb.field_72334_f; i += 0.25) {
            Botania.proxy.sparkleFX(this.field_145850_b, aabb.field_72340_a, aabb.field_72337_e, i, 1.0f, 0.0f, 0.0f, 0.5f, 1, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a("subtiles", this.subTiles.size());
        Iterable $this$forEachIndexed$iv = this.subTiles;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl2 = false;
            nbt.func_74778_a("subtile" + i, (String)s);
        }
        nbt.func_74780_a("rX", this.radius.getX());
        nbt.func_74780_a("rY", this.radius.getY());
        nbt.func_74780_a("rZ", this.radius.getZ());
        nbt.func_74780_a("oX", this.offset.getX());
        nbt.func_74780_a("oY", this.offset.getY());
        nbt.func_74780_a("oZ", this.offset.getZ());
        nbt.func_74780_a("power", this.power);
    }

    /*
     * WARNING - void declaration
     */
    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        int size = nbt.func_74762_e("subtiles");
        this.subTiles.clear();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            this.subTiles.add(nbt.func_74779_i("subtile" + (int)i));
            ++i;
        }
        this.radius.set((Number)nbt.func_74769_h("rX"), (Number)nbt.func_74769_h("rY"), (Number)nbt.func_74769_h("rZ"));
        this.offset.set((Number)nbt.func_74769_h("oX"), (Number)nbt.func_74769_h("oY"), (Number)nbt.func_74769_h("oZ"));
        this.power = nbt.func_74769_h("power");
    }
}

