/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.block.tile;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.extendables.block.ASJTile;
import alexsocol.asjlib.math.Vector3;
import java.awt.Color;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.proxy.CommonProxy;
import vazkii.botania.common.integration.coloredlights.ColoredLightHelper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\"H\u0016J.\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0007J\u0010\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lalfheim/common/block/tile/TileCracklingStar;", "Lalexsocol/asjlib/extendables/block/ASJTile;", "()V", "TAG_COLOR", "", "TAG_SIZE", "color", "", "getColor", "()I", "setColor", "(I)V", "pos", "Lalexsocol/asjlib/math/Vector3;", "getPos", "()Lalexsocol/asjlib/math/Vector3;", "setPos", "(Lalexsocol/asjlib/math/Vector3;)V", "rand", "Ljava/util/Random;", "getRand", "()Ljava/util/Random;", "size", "", "getSize", "()F", "setSize", "(F)V", "colorFromInt", "colorFromIntAndPos", "getLightColor", "rainbow", "saturation", "readCustomNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "updateEntity", "wispLine", "start", "line", "stepsPerBlock", "", "time", "writeCustomNBT", "Alfheim"})
public final class TileCracklingStar
extends ASJTile {
    @NotNull
    private Vector3 pos = new Vector3((Number)0.0, (Number)-1.0, (Number)0.0);
    @NotNull
    private final Random rand = new Random();
    private final String TAG_COLOR;
    private final String TAG_SIZE;
    private int color = -1;
    private float size = 0.05f;

    @NotNull
    public final Vector3 getPos() {
        return this.pos;
    }

    public final void setPos(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
        this.pos = vector3;
    }

    @NotNull
    public final Random getRand() {
        return this.rand;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final float getSize() {
        return this.size;
    }

    public final void setSize(float f) {
        this.size = f;
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a(this.TAG_COLOR, this.color);
        nbt.func_74776_a(this.TAG_SIZE, this.size);
        nbt.func_74780_a("toX", this.pos.getX());
        nbt.func_74780_a("toY", this.pos.getY());
        nbt.func_74780_a("toZ", this.pos.getZ());
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.color = nbt.func_74762_e(this.TAG_COLOR);
        this.size = nbt.func_74760_g(this.TAG_SIZE);
        this.pos = new Vector3((Number)nbt.func_74769_h("toX"), (Number)nbt.func_74769_h("toY"), (Number)nbt.func_74769_h("toZ"));
    }

    public final int getLightColor() {
        float r = ExtensionsKt.getF((Number)(this.color >> 16 & 0xFF)) / 255.0f;
        float g = ExtensionsKt.getF((Number)(this.color >> 8 & 0xFF)) / 255.0f;
        float b = ExtensionsKt.getF((Number)(this.color & 0xFF)) / 255.0f;
        return ColoredLightHelper.makeRGBLightValue((float)r, (float)g, (float)b, (float)1.0f);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            Vector3 cur = Vector3.Companion.fromTileEntity((TileEntity)this);
            if (this.pos.getY() != -1.0 && Intrinsics.areEqual((Object)this.pos, (Object)cur) ^ true) {
                Vector3 vec = new Vector3(this.pos).sub(Vector3.Companion.fromTileEntity((TileEntity)this));
                this.wispLine(Vector3.Companion.fromTileEntity((TileEntity)this).add((Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05)), vec, this.colorFromInt(this.color), Math.random() * 6.0, 10);
                this.wispLine(new Vector3(this.pos).add((Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05), (Number)(0.5 + (Math.random() - 0.5) * 0.05)), vec.negate(), this.colorFromInt(this.color), Math.random() * 6.0, 10);
            } else {
                Color c = new Color(this.colorFromIntAndPos(this.color, cur));
                Botania.proxy.wispFX(this.field_145850_b, cur.getX() + 0.5, cur.getY() + 0.5, cur.getZ() + 0.5, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 0.25f);
            }
        } else {
            TileCracklingStar other;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(ExtensionsKt.mfloor((double)this.pos.getX()), ExtensionsKt.mfloor((double)this.pos.getY()), ExtensionsKt.mfloor((double)this.pos.getZ()));
            if (!(tileEntity instanceof TileCracklingStar)) {
                tileEntity = null;
            }
            if ((other = (TileCracklingStar)tileEntity) == null) {
                this.pos.set((Number)0, (Number)-1, (Number)0);
                ASJUtilities.INSTANCE.dispatchTEToNearbyPlayers((TileEntity)this);
            }
        }
    }

    public final int colorFromInt(int color) {
        return color == -1 ? this.rainbow(1.0f) : color;
    }

    public final int colorFromIntAndPos(int color, @NotNull Vector3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return color == -1 ? this.rainbow(pos, 1.0f) : color;
    }

    public final int rainbow(float saturation) {
        CommonProxy commonProxy = Botania.proxy;
        Intrinsics.checkNotNullExpressionValue((Object)commonProxy, (String)"Botania.proxy");
        return Color.HSBtoRGB(ExtensionsKt.getF((Number)(commonProxy.getWorldElapsedTicks() * 2L % 360L)) / 360.0f, saturation, 1.0f);
    }

    public final int rainbow(@NotNull Vector3 pos, float saturation) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        CommonProxy commonProxy = Botania.proxy;
        Intrinsics.checkNotNullExpressionValue((Object)commonProxy, (String)"Botania.proxy");
        float ticks = ExtensionsKt.getF((Number)(commonProxy.getWorldElapsedTicks() * 2L % 360L)) / 360.0f;
        float seed = (float)((ExtensionsKt.mfloor((double)pos.getX()) ^ ExtensionsKt.mfloor((double)pos.getY()) ^ ExtensionsKt.mfloor((double)pos.getZ())) * 255 ^ pos.hashCode()) % 360.0f / 360.0f;
        return Color.HSBtoRGB(seed + ticks, saturation, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public final void wispLine(@NotNull Vector3 start, @NotNull Vector3 line, int color, double stepsPerBlock, int time) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        double len = line.length();
        Vector3 ray = Vector3.mul$default((Vector3)line.copy(), (Number)(1.0 / len), null, null, (int)6, null);
        int steps = ExtensionsKt.getI((Number)(len * stepsPerBlock));
        int n = 0;
        int n2 = steps;
        while (n < n2) {
            void i;
            Vector3 extended = Vector3.mul$default((Vector3)ray.copy(), (Number)((double)i / stepsPerBlock), null, null, (int)6, null);
            double x = start.getX() + extended.getX();
            double y = start.getY() + extended.getY();
            double z = start.getZ() + extended.getZ();
            Color c = new Color(color);
            float r = ExtensionsKt.getF((Number)c.getRed()) / 255.0f;
            float g = ExtensionsKt.getF((Number)c.getGreen()) / 255.0f;
            float b = ExtensionsKt.getF((Number)c.getBlue()) / 255.0f;
            Botania.proxy.wispFX(this.field_145850_b, x, y, z, r, g, b, (float)time * 0.0125f);
            ++i;
        }
    }

    public TileCracklingStar() {
        this.TAG_COLOR = "color";
        this.TAG_SIZE = "size";
    }
}

