/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.math.Vector3;
import alexsocol.asjlib.security.InteractionSecurity;
import alexsocol.patcher.event.EntityUpdateEvent;
import alfheim.AlfheimCore;
import alfheim.api.AlfheimAPI;
import alfheim.api.ModInfo;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.event.SpellCastEvent;
import alfheim.api.event.TimeStopCheckEvent;
import alfheim.api.spell.ITimeStopSpecific;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.network.Message1d;
import alfheim.common.network.Message2d;
import alfheim.common.network.Message3d;
import alfheim.common.network.MessageEffect;
import alfheim.common.network.MessageHotSpellC;
import alfheim.common.network.MessageParty;
import alfheim.common.network.MessageSkinInfo;
import alfheim.common.network.MessageTimeStop;
import alfheim.common.spell.tech.SpellTimeStop;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0014R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lalfheim/common/core/handler/CardinalSystem;", "", "()V", "playerSegments", "Ljava/util/HashMap;", "", "Lalfheim/common/core/handler/CardinalSystem$PlayerSegment;", "getPlayerSegments", "()Ljava/util/HashMap;", "setPlayerSegments", "(Ljava/util/HashMap;)V", "ensureExistance", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "forPlayer", "load", "", "save", "transfer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "ElvenSkinSystem", "HotSpellsSystem", "KnowledgeSystem", "ManaSystem", "PartySystem", "PlayerSegment", "SpellCastingSystem", "TargetingSystem", "TimeStopSystem", "Alfheim"})
public final class CardinalSystem {
    @NotNull
    private static HashMap<String, PlayerSegment> playerSegments;
    @NotNull
    public static final CardinalSystem INSTANCE;

    @NotNull
    public final HashMap<String, PlayerSegment> getPlayerSegments() {
        return playerSegments;
    }

    public final void setPlayerSegments(@NotNull HashMap<String, PlayerSegment> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        playerSegments = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull String save) {
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        File file = new File(save + "/data/Cardinal.sys");
        if (!file.exists()) {
            ASJUtilities.log((String)"Cardinal System data file not found. Generating default values...");
            playerSegments = new HashMap();
            TimeStopSystem.INSTANCE.setTsAreas(new HashMap<Integer, LinkedList<TimeStopSystem.TimeStopArea>>());
            return;
        }
        try {
            Closeable closeable = new ObjectInputStream(new FileInputStream(file));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectInputStream oin = (ObjectInputStream)closeable;
                boolean bl3 = false;
                Object object = oin.readObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<kotlin.String, alfheim.common.core.handler.CardinalSystem.PlayerSegment>");
                }
                playerSegments = (HashMap)object;
                Object object2 = oin.readObject();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.HashMap<kotlin.Int, java.util.LinkedList<alfheim.common.core.handler.CardinalSystem.TimeStopSystem.TimeStopArea>>");
                }
                TimeStopSystem.INSTANCE.setTsAreas((HashMap)object2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to read whole Cardinal System data. Generating default values...");
            e.printStackTrace();
            playerSegments = new HashMap();
            TimeStopSystem.INSTANCE.setTsAreas(new HashMap<Integer, LinkedList<TimeStopSystem.TimeStopArea>>());
        }
    }

    public final void transfer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        KnowledgeSystem.INSTANCE.transfer(player);
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message1d(Message1d.m1d.ESMABIL, this.forPlayer((EntityPlayer)player).getEsmAbility() ? 1.0 : 0.0), player);
            ElvenSkinSystem.INSTANCE.transfer(player);
            if (AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                SpellCastingSystem.INSTANCE.transfer(player);
                HotSpellsSystem.INSTANCE.transfer(player);
                PartySystem.INSTANCE.transfer(player);
                TimeStopSystem.INSTANCE.transfer(player, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull String save) {
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        try {
            Closeable closeable = new ObjectOutputStream(new FileOutputStream(save + "/data/Cardinal.sys"));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = (ObjectOutputStream)closeable;
                boolean bl3 = false;
                oos.writeObject(playerSegments);
                oos.writeObject(TimeStopSystem.INSTANCE.getTsAreas());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to save whole Cardinal System data. Discarding. Sorry :(");
            e.printStackTrace();
        }
    }

    public final boolean ensureExistance(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!playerSegments.containsKey(player.func_70005_c_())) {
            Map map = playerSegments;
            String string = player.func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.commandSenderName");
            map.put(string, new PlayerSegment(player));
        }
        return true;
    }

    @NotNull
    public final PlayerSegment forPlayer(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (ASJUtilities.isClient()) {
            throw (Throwable)new RuntimeException("You shouldn't access this from client");
        }
        this.ensureExistance(player);
        PlayerSegment playerSegment = playerSegments.get(player.func_70005_c_());
        Intrinsics.checkNotNull((Object)playerSegment);
        return playerSegment;
    }

    private CardinalSystem() {
    }

    static {
        CardinalSystem cardinalSystem;
        INSTANCE = cardinalSystem = new CardinalSystem();
        playerSegments = new HashMap();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem;", "", "()V", "know", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "kn", "Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem$Knowledge;", "learn", "", "transfer", "Knowledge", "Alfheim"})
    public static final class KnowledgeSystem {
        @NotNull
        public static final KnowledgeSystem INSTANCE;

        public final void learn(@NotNull EntityPlayerMP player, @NotNull Knowledge kn) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)kn), (String)"kn");
            PlayerSegment seg = INSTANCE.forPlayer((EntityPlayer)player);
            if (!this.know(player, kn)) {
                seg.getKnowledge().add(String.valueOf((Object)kn));
                AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message1d(Message1d.m1d.KNOWLEDGE, ExtensionsKt.getD((Number)kn.ordinal())), player);
            }
            INSTANCE.save(AlfheimCore.Companion.getSave());
        }

        public final boolean know(@NotNull EntityPlayerMP player, @NotNull Knowledge kn) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)kn), (String)"kn");
            return INSTANCE.forPlayer((EntityPlayer)player).getKnowledge().contains(String.valueOf((Object)kn));
        }

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            for (Knowledge kn : Knowledge.values()) {
                if (!this.know(player, kn)) continue;
                AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message1d(Message1d.m1d.KNOWLEDGE, ExtensionsKt.getD((Number)kn.ordinal())), player);
            }
        }

        private KnowledgeSystem() {
        }

        static {
            KnowledgeSystem knowledgeSystem;
            INSTANCE = knowledgeSystem = new KnowledgeSystem();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lalfheim/common/core/handler/CardinalSystem$KnowledgeSystem$Knowledge;", "", "(Ljava/lang/String;I)V", "GLOWSTONE", "PYLONS", "Alfheim"})
        public static final class Knowledge
        extends Enum<Knowledge> {
            public static final /* enum */ Knowledge GLOWSTONE;
            public static final /* enum */ Knowledge PYLONS;
            private static final /* synthetic */ Knowledge[] $VALUES;

            static {
                Knowledge[] knowledgeArray = new Knowledge[2];
                Knowledge[] knowledgeArray2 = knowledgeArray;
                knowledgeArray[0] = GLOWSTONE = new Knowledge();
                knowledgeArray[1] = PYLONS = new Knowledge();
                $VALUES = knowledgeArray;
            }

            public static Knowledge[] values() {
                return (Knowledge[])$VALUES.clone();
            }

            public static Knowledge valueOf(String string) {
                return Enum.valueOf(Knowledge.class, string);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\n\u00a8\u0006\u0016"}, d2={"Lalfheim/common/core/handler/CardinalSystem$SpellCastingSystem;", "", "()V", "getCoolDown", "", "caster", "Lnet/minecraft/entity/player/EntityPlayer;", "spell", "Lalfheim/api/spell/SpellBase;", "performCast", "Lnet/minecraft/entity/player/EntityPlayerMP;", "raceID", "spellID", "reset", "", "setCoolDown", "cd", "tick", "transfer", "player", "QuadDamageHandler", "SpellCastingHandler", "Alfheim"})
    public static final class SpellCastingSystem {
        @NotNull
        public static final SpellCastingSystem INSTANCE;

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            for (EnumRace affinity : EnumRace.values()) {
                for (SpellBase spell : AlfheimAPI.INSTANCE.getSpellsFor(affinity)) {
                    SimpleNetworkWrapper simpleNetworkWrapper = AlfheimCore.Companion.getNetwork();
                    int n = (affinity.ordinal() & 0xF) << 28;
                    SpellBase spellBase = spell;
                    Intrinsics.checkNotNullExpressionValue((Object)spellBase, (String)"spell");
                    simpleNetworkWrapper.sendTo((IMessage)new Message2d(Message2d.m2d.COOLDOWN, ExtensionsKt.getD((Number)(n | AlfheimAPI.INSTANCE.getSpellID(spellBase) & 0xFFFFFFF)), ExtensionsKt.getD((Number)this.getCoolDown((EntityPlayer)player, spell))), player);
                }
            }
        }

        public final int setCoolDown(@NotNull EntityPlayer caster, @NotNull SpellBase spell, int cd) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            ((Map)INSTANCE.forPlayer(caster).getCoolDown()).put(spell.getName(), cd);
            if (cd > 6000) {
                INSTANCE.save(AlfheimCore.Companion.getSave());
            }
            return cd;
        }

        public final int getCoolDown(@NotNull EntityPlayer caster, @NotNull SpellBase spell) {
            int n;
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            try {
                Integer n2 = INSTANCE.forPlayer(caster).getCoolDown().get(spell.getName());
                if (n2 == null) {
                    n2 = 0;
                }
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"forPlayer(caster).coolDown[spell.name] ?: 0");
                n = n2;
            }
            catch (Throwable e) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Something went wrong getting cooldown for %s. Returning 0.";
                Object[] objectArray = new Object[]{spell};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                ASJUtilities.error((String)string2);
                e.printStackTrace();
                n = 0;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void tick() {
            try {
                Map $this$forEach$iv = INSTANCE.getPlayerSegments();
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $dstr$name$segment = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$name$segment;
                    boolean bl3 = false;
                    String string = (String)entry.getKey();
                    entry = $dstr$name$segment;
                    bl3 = false;
                    PlayerSegment segment = (PlayerSegment)entry.getValue();
                    for (String spell : segment.getCoolDown().keySet()) {
                        Integer n = segment.getCoolDown().get(spell);
                        if (n == null) {
                            n = 0;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"segment.coolDown[spell] ?: 0");
                        int time = n;
                        if (time > 5) {
                            void name;
                            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
                            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"MinecraftServer.getServer()");
                            EntityPlayerMP entityPlayerMP = minecraftServer.func_71203_ab().func_152612_a((String)name);
                            if (entityPlayerMP != null && (entityPlayerMP = entityPlayerMP.field_71075_bZ) != null) {
                                if (entityPlayerMP.field_75098_d) {
                                    time = 5;
                                }
                            }
                        }
                        if (time <= 0) continue;
                        Map map2 = segment.getCoolDown();
                        String string2 = spell;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"spell");
                        map2.put(string2, time - 1);
                    }
                    MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
                    Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"MinecraftServer.getServer()");
                    EntityPlayerMP player = minecraftServer.func_71203_ab().func_152612_a(segment.getUserName());
                    if (player != null) {
                        if (segment.getInit() > 0) {
                            PlayerSegment playerSegment = segment;
                            playerSegment.setInit(playerSegment.getInit() + -1);
                            playerSegment.getInit();
                            continue;
                        }
                        if (segment.getIds() == 0 || segment.getCastableSpell() == null) continue;
                        try {
                            AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message2d(Message2d.m2d.COOLDOWN, ExtensionsKt.getD((Number)segment.getIds()), ExtensionsKt.getD((Number)INSTANCE.performCast(player, segment.getIds() >> 28 & 0xF, segment.getIds() & 0xFFFFFFF))), player);
                            continue;
                        }
                        finally {
                            segment.setIds(0);
                            segment.setInit(0);
                            segment.setCastableSpell(null);
                            continue;
                        }
                    }
                    segment.setIds(0);
                    segment.setInit(0);
                    segment.setCastableSpell(null);
                }
            }
            catch (Throwable e) {
                ASJUtilities.error((String)("Something went wrong ticking spells. Skipping this tick. Caused by: " + e.getMessage()));
                e.printStackTrace();
            }
        }

        public final int performCast(@NotNull EntityPlayerMP caster, int raceID, int spellID) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            if (!AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                return -SpellBase.SpellCastResult.NOTALLOW.ordinal();
            }
            if (caster.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDLeftFlame())) {
                return -SpellBase.SpellCastResult.NOTALLOW.ordinal();
            }
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellByIDs(raceID, spellID);
            if (spellBase == null) {
                return -SpellBase.SpellCastResult.DESYNC.ordinal();
            }
            SpellBase spell = spellBase;
            if (this.getCoolDown((EntityPlayer)caster, spell) > 0) {
                return -SpellBase.SpellCastResult.NOTREADY.ordinal();
            }
            SpellBase.SpellCastResult result = spell.performCast((EntityLivingBase)caster);
            if (result == SpellBase.SpellCastResult.OK) {
                SpellCastEvent.Post e = new SpellCastEvent.Post(spell, (EntityLivingBase)caster, spell.getCooldown());
                MinecraftForge.EVENT_BUS.post((Event)e);
                return this.setCoolDown((EntityPlayer)caster, spell, e.getCd());
            }
            return -result.ordinal();
        }

        public final void reset() {
            for (PlayerSegment segment : INSTANCE.getPlayerSegments().values()) {
                for (String spell : segment.getCoolDown().keySet()) {
                    Map map = segment.getCoolDown();
                    String string = spell;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"spell");
                    map.put(string, 0);
                }
            }
        }

        private SpellCastingSystem() {
        }

        static {
            SpellCastingSystem spellCastingSystem;
            INSTANCE = spellCastingSystem = new SpellCastingSystem();
            MinecraftForge.EVENT_BUS.register((Object)new SpellCastingHandler());
            MinecraftForge.EVENT_BUS.register((Object)new QuadDamageHandler());
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lalfheim/common/core/handler/CardinalSystem$SpellCastingSystem$SpellCastingHandler;", "", "()V", "onSpellCasted", "", "e", "Lalfheim/api/event/SpellCastEvent$Post;", "onSpellCasting", "Lalfheim/api/event/SpellCastEvent$Pre;", "Alfheim"})
        public static final class SpellCastingHandler {
            @SubscribeEvent
            public final void onSpellCasting(@NotNull SpellCastEvent.Pre e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (!e.getCaster().func_70089_S() || e.getCaster().field_70128_L) {
                    e.setCanceled(true);
                    return;
                }
                if (e.getCaster().func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDLeftFlame())) {
                    e.setCanceled(true);
                    return;
                }
                if (TimeStopSystem.INSTANCE.affected((Entity)e.getCaster())) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onSpellCasted(@NotNull SpellCastEvent.Post e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (ModInfo.INSTANCE.getDEV() || e.getCaster() instanceof EntityPlayer && ((EntityPlayer)e.getCaster()).field_71075_bZ.field_75098_d) {
                    e.setCd(5);
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lalfheim/common/core/handler/CardinalSystem$SpellCastingSystem$QuadDamageHandler;", "", "()V", "addQuadDamageEffect", "", "e", "Lnet/minecraftforge/event/entity/EntityStruckByLightningEvent;", "handleQuadDamageSequence", "Lalfheim/api/event/SpellCastEvent$Post;", "Alfheim"})
        public static final class QuadDamageHandler {
            @SubscribeEvent
            public final void handleQuadDamageSequence(@NotNull SpellCastEvent.Post e) {
                Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                if (!(e.getCaster() instanceof EntityPlayer)) {
                    return;
                }
                EntityLivingBase player = e.getCaster();
                PlayerSegment seg = CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player);
                switch (seg.getQuadStage()) {
                    case 0: {
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"stoneskin")) {
                            PlayerSegment playerSegment = seg;
                            playerSegment.setQuadStage(playerSegment.getQuadStage() + 1);
                            playerSegment.getQuadStage();
                            break;
                        }
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"uphealth") && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin())) {
                            PlayerSegment playerSegment = seg;
                            playerSegment.setQuadStage(playerSegment.getQuadStage() + 2);
                            break;
                        }
                        seg.setQuadStage(0);
                        break;
                    }
                    case 1: {
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"uphealth") && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin())) {
                            PlayerSegment playerSegment = seg;
                            playerSegment.setQuadStage(playerSegment.getQuadStage() + 1);
                            playerSegment.getQuadStage();
                            break;
                        }
                        seg.setQuadStage(0);
                        break;
                    }
                    case 2: {
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"icelens") && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin()) && player.func_70644_a(Potion.field_76434_w)) {
                            PotionEffect potionEffect = ExtensionsKt.getActivePotionEffect((EntityLivingBase)player, (int)Potion.field_76434_w.field_76415_H);
                            Intrinsics.checkNotNull((Object)potionEffect);
                            if (potionEffect.field_76461_c == 1) {
                                PlayerSegment playerSegment = seg;
                                playerSegment.setQuadStage(playerSegment.getQuadStage() + 1);
                                playerSegment.getQuadStage();
                                break;
                            }
                        }
                        seg.setQuadStage(0);
                        break;
                    }
                    case 3: {
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"battlehorn") && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin()) && player.func_70644_a(Potion.field_76434_w)) {
                            PotionEffect potionEffect = ExtensionsKt.getActivePotionEffect((EntityLivingBase)player, (int)Potion.field_76434_w.field_76415_H);
                            Intrinsics.checkNotNull((Object)potionEffect);
                            if (potionEffect.field_76461_c == 1 && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDIceLens())) {
                                PlayerSegment playerSegment = seg;
                                playerSegment.setQuadStage(playerSegment.getQuadStage() + 1);
                                playerSegment.getQuadStage();
                                break;
                            }
                        }
                        seg.setQuadStage(0);
                        break;
                    }
                    case 4: {
                        if (Intrinsics.areEqual((Object)e.getSpell().getName(), (Object)"thor") && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin()) && player.func_70644_a(Potion.field_76434_w)) {
                            PotionEffect potionEffect = ExtensionsKt.getActivePotionEffect((EntityLivingBase)player, (int)Potion.field_76434_w.field_76415_H);
                            Intrinsics.checkNotNull((Object)potionEffect);
                            if (potionEffect.field_76461_c == 1 && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDIceLens())) {
                                PlayerSegment playerSegment = seg;
                                playerSegment.setQuadStage(playerSegment.getQuadStage() + 1);
                                playerSegment.getQuadStage();
                                break;
                            }
                        }
                        seg.setQuadStage(0);
                        break;
                    }
                    default: {
                        seg.setQuadStage(0);
                    }
                }
            }

            @SubscribeEvent
            public final void addQuadDamageEffect(@NotNull EntityStruckByLightningEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                    if (!(e.entity instanceof EntityPlayer)) {
                        return;
                    }
                    Entity entity = e.entity;
                    if (entity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    }
                    EntityPlayer player = (EntityPlayer)entity;
                    PlayerSegment seg = CardinalSystem.INSTANCE.forPlayer(player);
                    if (seg.getQuadStage() >= 5 && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin()) && player.func_70644_a(Potion.field_76434_w)) {
                        PotionEffect potionEffect = ExtensionsKt.getActivePotionEffect((EntityLivingBase)((EntityLivingBase)player), (int)Potion.field_76434_w.field_76415_H);
                        Intrinsics.checkNotNull((Object)potionEffect);
                        if (potionEffect.field_76461_c == 1 && player.func_82165_m(AlfheimConfigHandler.INSTANCE.getPotionIDIceLens())) {
                            seg.setQuadStage(0);
                            player.func_82170_o(AlfheimConfigHandler.INSTANCE.getPotionIDStoneSkin());
                            player.func_82170_o(Potion.field_76434_w.field_76415_H);
                            player.func_82170_o(AlfheimConfigHandler.INSTANCE.getPotionIDIceLens());
                            player.func_82170_o(Potion.field_76420_g.field_76415_H);
                            player.func_70690_d(new PotionEffect(AlfheimConfigHandler.INSTANCE.getPotionIDPossession(), 600, 0, false));
                            SimpleNetworkWrapper simpleNetworkWrapper = AlfheimCore.Companion.getNetwork();
                            Entity entity2 = e.entity;
                            Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"e.entity");
                            simpleNetworkWrapper.sendToAll((IMessage)new MessageEffect(entity2.func_145782_y(), AlfheimConfigHandler.INSTANCE.getPotionIDPossession(), 600, 0));
                            e.setCanceled(true);
                        }
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ManaSystem;", "", "()V", "getMana", "", "mr", "Lnet/minecraft/entity/EntityLivingBase;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "handleManaChange", "", "ManaSyncHandler", "Alfheim"})
    public static final class ManaSystem {
        @NotNull
        public static final ManaSystem INSTANCE;

        public final void handleManaChange(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PartySystem.INSTANCE.getParty(player).sendMana(player, this.getMana(player));
        }

        /*
         * WARNING - void declaration
         */
        public final int getMana(@NotNull EntityPlayer player) {
            int invSize;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int totalMana = 0;
            InventoryPlayer mainInv = player.field_71071_by;
            IInventory baublesInv = BotaniaAPI.internalHandler.getBaublesInventory(player);
            InventoryPlayer inventoryPlayer = mainInv;
            Intrinsics.checkNotNullExpressionValue((Object)inventoryPlayer, (String)"mainInv");
            int size = invSize = inventoryPlayer.func_70302_i_();
            if (baublesInv != null) {
                size += baublesInv.func_70302_i_();
            }
            int n = 0;
            int n2 = size;
            while (n < n2) {
                IInventory inv;
                void i;
                boolean useBaubles = i >= invSize;
                IInventory iInventory = inv = useBaubles ? baublesInv : (IInventory)mainInv;
                Intrinsics.checkNotNullExpressionValue((Object)iInventory, (String)"inv");
                ItemStack stack = ExtensionsKt.get((IInventory)iInventory, (int)(i - (useBaubles ? invSize : 0)));
                if (stack != null) {
                    Item item = stack.func_77973_b();
                    if (item instanceof ICreativeManaProvider && ((ICreativeManaProvider)item).isCreative(stack)) {
                        return Integer.MAX_VALUE;
                    }
                    if (item instanceof IManaItem && !((IManaItem)item).isNoExport(stack)) {
                        if (Integer.MAX_VALUE - ((IManaItem)item).getMana(stack) <= totalMana) {
                            return Integer.MAX_VALUE;
                        }
                        totalMana += ((IManaItem)item).getMana(stack);
                    }
                }
                ++i;
            }
            return totalMana;
        }

        public final int getMana(@NotNull EntityLivingBase mr) {
            int n;
            Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
            EntityLivingBase entityLivingBase = mr;
            if (!(entityLivingBase instanceof EntityPlayer)) {
                entityLivingBase = null;
            }
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            if (entityPlayer != null) {
                EntityPlayer entityPlayer2 = entityPlayer;
                boolean bl = false;
                boolean bl2 = false;
                EntityPlayer it = entityPlayer2;
                boolean bl3 = false;
                n = INSTANCE.getMana(it);
            } else {
                n = 0;
            }
            return n;
        }

        private ManaSystem() {
        }

        static {
            ManaSystem manaSystem;
            INSTANCE = manaSystem = new ManaSystem();
            MinecraftForge.EVENT_BUS.register((Object)new ManaSyncHandler());
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ManaSystem$ManaSyncHandler;", "", "()V", "onLivingUpdate", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "Alfheim"})
        public static final class ManaSyncHandler {
            @SubscribeEvent
            public final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && e.entityLiving instanceof EntityPlayer) {
                    EntityLivingBase entityLivingBase = e.entityLiving;
                    if (entityLivingBase == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    }
                    EntityPlayer player = (EntityPlayer)entityLivingBase;
                    World world = player.field_70170_p;
                    Intrinsics.checkNotNullExpressionValue((Object)world, (String)"player.worldObj");
                    if (world.func_82737_E() % (long)20 == 0L) {
                        INSTANCE.handleManaChange(player);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TargetingSystem;", "", "()V", "getTarget", "Lalfheim/common/core/handler/CardinalSystem$TargetingSystem$Target;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "setTarget", "", "target", "Lnet/minecraft/entity/EntityLivingBase;", "isParty", "", "partyIndex", "", "Target", "Alfheim"})
    public static final class TargetingSystem {
        @NotNull
        public static final TargetingSystem INSTANCE;

        public final void setTarget(@NotNull EntityPlayer player, @Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerSegment c = INSTANCE.forPlayer(player);
            c.setTarget(target);
            if (partyIndex != -2) {
                c.setParty(isParty);
                c.setPartyIndex(partyIndex);
            }
        }

        public static /* synthetic */ void setTarget$default(TargetingSystem targetingSystem, EntityPlayer entityPlayer, EntityLivingBase entityLivingBase, boolean bl, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = -1;
            }
            targetingSystem.setTarget(entityPlayer, entityLivingBase, bl, n);
        }

        @NotNull
        public final Target getTarget(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerSegment c = INSTANCE.forPlayer(player);
            return new Target(c.getTarget(), c.isParty(), c.getPartyIndex());
        }

        private TargetingSystem() {
        }

        static {
            TargetingSystem targetingSystem;
            INSTANCE = targetingSystem = new TargetingSystem();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TargetingSystem$Target;", "", "target", "Lnet/minecraft/entity/EntityLivingBase;", "isParty", "", "partyIndex", "", "(Lnet/minecraft/entity/EntityLivingBase;ZI)V", "()Z", "getPartyIndex", "()I", "getTarget", "()Lnet/minecraft/entity/EntityLivingBase;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "Alfheim"})
        public static final class Target {
            @Nullable
            private final EntityLivingBase target;
            private final boolean isParty;
            private final int partyIndex;

            @Nullable
            public final EntityLivingBase getTarget() {
                return this.target;
            }

            public final boolean isParty() {
                return this.isParty;
            }

            public final int getPartyIndex() {
                return this.partyIndex;
            }

            public Target(@Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
                this.target = target;
                this.isParty = isParty;
                this.partyIndex = partyIndex;
            }

            @Nullable
            public final EntityLivingBase component1() {
                return this.target;
            }

            public final boolean component2() {
                return this.isParty;
            }

            public final int component3() {
                return this.partyIndex;
            }

            @NotNull
            public final Target copy(@Nullable EntityLivingBase target, boolean isParty, int partyIndex) {
                return new Target(target, isParty, partyIndex);
            }

            public static /* synthetic */ Target copy$default(Target target, EntityLivingBase entityLivingBase, boolean bl, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    entityLivingBase = target.target;
                }
                if ((n2 & 2) != 0) {
                    bl = target.isParty;
                }
                if ((n2 & 4) != 0) {
                    n = target.partyIndex;
                }
                return target.copy(entityLivingBase, bl, n);
            }

            @NotNull
            public String toString() {
                return "Target(target=" + this.target + ", isParty=" + this.isParty + ", partyIndex=" + this.partyIndex + ")";
            }

            public int hashCode() {
                EntityLivingBase entityLivingBase = this.target;
                int n = (entityLivingBase != null ? entityLivingBase.hashCode() : 0) * 31;
                int n2 = this.isParty ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return (n + n2) * 31 + Integer.hashCode(this.partyIndex);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Target)) break block3;
                        Target target = (Target)object;
                        if (!Intrinsics.areEqual((Object)this.target, (Object)target.target) || this.isParty != target.isParty || this.partyIndex != target.partyIndex) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002 !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001a\u0010\u0019\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u001f\u00a8\u0006\""}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem;", "", "()V", "friendlyFire", "", "entityLiving", "Lnet/minecraft/entity/EntityLivingBase;", "source", "Lnet/minecraft/util/DamageSource;", "getMobParty", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "living", "getParty", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getUUIDParty", "id", "Ljava/util/UUID;", "mobsSameParty", "e1", "e2", "notifySpawn", "", "e", "Lnet/minecraft/entity/Entity;", "sameParty", "p1", "p2", "setParty", "party", "transfer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Party", "PartyThingsListener", "Alfheim"})
    public static final class PartySystem {
        @NotNull
        public static final PartySystem INSTANCE;

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AlfheimCore.Companion.getNetwork().sendTo((IMessage)new MessageParty(INSTANCE.forPlayer((EntityPlayer)player).getParty()), player);
        }

        public final void setParty(@NotNull EntityPlayer player, @NotNull Party party) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)party, (String)"party");
            INSTANCE.forPlayer(player).setParty(party);
            party.sendChanges();
            INSTANCE.save(AlfheimCore.Companion.getSave());
        }

        @NotNull
        public final Party getParty(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getParty();
        }

        @Nullable
        public final Party getMobParty(@Nullable EntityLivingBase living) {
            Object v1;
            block1: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"playerSegments.values");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlayerSegment it = (PlayerSegment)element$iv;
                    boolean bl = false;
                    if (!it.getParty().isMember(living)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            PlayerSegment playerSegment = v1;
            return playerSegment != null ? playerSegment.getParty() : null;
        }

        @Nullable
        public final Party getUUIDParty(@Nullable UUID id) {
            Object v1;
            block1: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"playerSegments.values");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PlayerSegment it = (PlayerSegment)element$iv;
                    boolean bl = false;
                    if (!it.getParty().isMember(id)) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            PlayerSegment playerSegment = v1;
            return playerSegment != null ? playerSegment.getParty() : null;
        }

        public final boolean sameParty(@NotNull EntityPlayer p1, @Nullable EntityLivingBase p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return this.getParty(p1).isMember(p2);
        }

        public final boolean sameParty(@Nullable UUID id, @Nullable EntityLivingBase e) {
            boolean bl;
            block3: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"playerSegments.values");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerSegment it = (PlayerSegment)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParty().isMember(id) && it.getParty().isMember(e))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean mobsSameParty(@Nullable EntityLivingBase e1, @Nullable EntityLivingBase e2) {
            boolean bl;
            block3: {
                Collection<PlayerSegment> collection = INSTANCE.getPlayerSegments().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"playerSegments.values");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PlayerSegment it = (PlayerSegment)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParty().isMember(e1) && it.getParty().isMember(e2))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean friendlyFire(@NotNull EntityLivingBase entityLiving, @NotNull DamageSource source) {
            Intrinsics.checkNotNullParameter((Object)entityLiving, (String)"entityLiving");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!AlfheimConfigHandler.INSTANCE.getEnableMMO()) return false;
            String string = source.field_76373_n;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.damageType");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"_FF", (boolean)false, (int)2, null)) {
                return false;
            }
            if (ASJUtilities.isClient()) {
                return false;
            }
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
                Entity entity = source.func_76346_g();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                }
                if (this.getParty((EntityPlayer)entity).isMember(entityLiving)) {
                    return true;
                }
            }
            if (entityLiving instanceof EntityPlayer && source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
                Entity entity = source.func_76346_g();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
                }
                if (this.getParty((EntityPlayer)entityLiving).isMember((EntityLivingBase)entity)) {
                    return true;
                }
            }
            if (source.func_76346_g() == null) return false;
            if (!(source.func_76346_g() instanceof EntityLivingBase)) return false;
            Entity entity = source.func_76346_g();
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
            }
            if (!this.mobsSameParty(entityLiving, (EntityLivingBase)entity)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public static final void notifySpawn(@NotNull Entity e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e instanceof EntityLivingBase) {
                for (PlayerSegment segment : INSTANCE.getPlayerSegments().values()) {
                    if (!segment.getParty().isMember((EntityLivingBase)e)) continue;
                    int n = 0;
                    int n2 = segment.getParty().getCount();
                    while (n < n2) {
                        EntityLivingBase mr;
                        void i;
                        if (segment.getParty().isPlayer((int)i) && (mr = segment.getParty().get((int)i)) instanceof EntityPlayerMP) {
                            AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message2d(Message2d.m2d.UUID, ExtensionsKt.getD((Number)e.func_145782_y()), ExtensionsKt.getD((Number)segment.getParty().indexOf((EntityLivingBase)e))), (EntityPlayerMP)mr);
                        }
                        ++i;
                    }
                }
            }
        }

        private PartySystem() {
        }

        static {
            PartySystem partySystem;
            INSTANCE = partySystem = new PartySystem();
            MinecraftForge.EVENT_BUS.register((Object)new PartyThingsListener());
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0003EFGB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0086\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010#\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010#\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010%\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010(\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010)\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010*\u001a\u00020\u0015H\u0002J\u0012\u0010+\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010+\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0015J\u0016\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001eJ\u0016\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u0005J\u0016\u00107\u001a\u00020-2\u0006\u00102\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u001eJ\u0016\u00109\u001a\u00020-2\u0006\u00102\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0015J\u0016\u0010;\u001a\u00020-2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0015J\u0016\u0010<\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001eJ\u0016\u0010=\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005J\u0016\u0010>\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u001eJ\u0016\u0010?\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005J\u0016\u0010@\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020DR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006H"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "Ljava/io/Serializable;", "", "()V", "i", "", "(I)V", "pl", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "count", "getCount", "()I", "setCount", "members", "", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "[Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "getPl", "()Lnet/minecraft/entity/player/EntityPlayer;", "add", "", "mr", "Lnet/minecraft/entity/EntityLivingBase;", "clone", "", "get", "name", "", "getHealth", "", "getMana", "getMaxHealth", "getName", "getType", "indexOf", "isDead", "isMember", "uuid", "Ljava/util/UUID;", "isPlayer", "remove", "removePL", "removeSafe", "sendChanges", "", "sendDead", "id", "d", "sendHealth", "index", "health", "sendMana", "player", "mana", "sendMaxHealth", "maxHealth", "sendType", "type", "setDead", "setHealth", "setMana", "setMaxHealth", "setType", "setUUID", "enID", "write", "buf", "Lio/netty/buffer/ByteBuf;", "Companion", "Member", "PartyStatus", "Alfheim"})
        public static final class Party
        implements Serializable,
        Cloneable {
            private Member[] members;
            private int count;
            private static final long serialVersionUID = 84616843168484257L;
            private static transient boolean serverIO;
            @NotNull
            public static final Companion Companion;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            @Nullable
            public final EntityPlayer getPl() {
                return (EntityPlayer)this.get(0);
            }

            @Nullable
            public final EntityLivingBase get(int i) {
                Member member = this.members[i];
                if (member != null) {
                    if (member.isPlayer()) {
                        EntityLivingBase entityLivingBase;
                        if (ASJUtilities.isServer()) {
                            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
                            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"MinecraftServer.getServer()");
                            Member member2 = this.members[i];
                            entityLivingBase = (EntityLivingBase)minecraftServer.func_71203_ab().func_152612_a(member2 != null ? member2.getName() : null);
                        } else {
                            Member member3 = this.members[i];
                            entityLivingBase = (EntityLivingBase)ExtensionsClientKt.getMc().field_71441_e.func_72924_a(member3 != null ? member3.getName() : null);
                        }
                        return entityLivingBase;
                    }
                }
                if (ASJUtilities.isServer()) {
                    for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                        for (Object entity : world.field_72996_f) {
                            if (!(entity instanceof EntityLivingBase)) continue;
                            Member member4 = this.members[i];
                            if (!Intrinsics.areEqual((Object)((EntityLivingBase)entity).func_110124_au(), (Object)(member4 != null ? member4.getUuid() : null))) continue;
                            return (EntityLivingBase)entity;
                        }
                    }
                } else {
                    Serializable serializable = this.members[i];
                    Entity e = ExtensionsClientKt.getMc().field_71441_e.func_73045_a(serializable != null && (serializable = ((Member)serializable).getUuid()) != null ? ExtensionsKt.getI((Number)((UUID)serializable).getMostSignificantBits()) : 0);
                    return e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
                }
                return null;
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final EntityLivingBase get(@NotNull String name) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = ((Number)element$iv).intValue();
                        $i$a$-firstOrNull-CardinalSystem$PartySystem$Party$get$1 = false;
                        if (this.members[it] == null) ** GOTO lbl-1000
                        v0 = this.members[it];
                        Intrinsics.checkNotNull((Object)v0);
                        if (Intrinsics.areEqual((Object)v0.getName(), (Object)name)) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                v3 = v2;
                if (v3 != null) {
                    var2_2 = v3;
                    var3_3 = false;
                    var4_5 = false;
                    it = ((Number)var2_2).intValue();
                    $i$a$-let-CardinalSystem$PartySystem$Party$get$2 = false;
                    v4 = this.get(it);
                } else {
                    v4 = null;
                }
                return v4;
            }

            public final float getHealth(int i) {
                Member member = this.members[i];
                return member != null ? member.getHealth() : 0.0f;
            }

            public final float getMaxHealth(int i) {
                Member member = this.members[i];
                return member != null ? member.getMaxHealth() : 0.0f;
            }

            public final int getMana(int i) {
                Member member = this.members[i];
                return member != null ? member.getMana() : 0;
            }

            @NotNull
            public final String getName(int i) {
                Object object = this.members[i];
                if (object == null || (object = ((Member)object).getName()) == null) {
                    object = "";
                }
                return object;
            }

            public final int getType(int i) {
                Member member = this.members[i];
                return member != null ? member.getType() : 0;
            }

            public final boolean isPlayer(int i) {
                Member member = this.members[i];
                return member != null ? member.isPlayer() : false;
            }

            public final boolean isDead(int i) {
                Member member = this.members[i];
                return member != null ? member.isDead() : false;
            }

            public final void setHealth(int i, float health) {
                Member member = this.members[i];
                if (member == null) {
                    return;
                }
                Member mr = member;
                float was = mr.getHealth();
                if (was != health) {
                    mr.setHealth(health);
                    if (ASJUtilities.isServer()) {
                        this.sendHealth(i, health);
                    }
                }
            }

            public final void setMaxHealth(int i, float maxHealth) {
                Member member = this.members[i];
                if (member == null) {
                    return;
                }
                Member mr = member;
                float was = mr.getMaxHealth();
                if (was != maxHealth) {
                    mr.setMaxHealth(maxHealth);
                    if (ASJUtilities.isServer()) {
                        this.sendMaxHealth(i, maxHealth);
                    }
                }
            }

            public final void setMana(int i, int mana) {
                block0: {
                    Member member = this.members[i];
                    if (member == null) break block0;
                    member.setMana(mana);
                }
            }

            public final void setType(int i, int type) {
                Member member = this.members[i];
                if (member != null) {
                    member.setType(type);
                }
                if (ASJUtilities.isServer()) {
                    this.sendType(i, type);
                }
            }

            public final int indexOf(@Nullable EntityLivingBase mr) {
                Object v3;
                block4: {
                    if (mr == null) {
                        return -1;
                    }
                    Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[it];
                            bl = Intrinsics.areEqual((Object)mr.func_110124_au(), (Object)(member != null ? member.getUuid() : null));
                        } else {
                            Serializable serializable = this.members[it];
                            bl = serializable != null && (serializable = ((Member)serializable).getUuid()) != null && (long)mr.func_145782_y() == ((UUID)serializable).getMostSignificantBits();
                        }
                        if (!bl) continue;
                        v3 = element$iv;
                        break block4;
                    }
                    v3 = null;
                }
                Integer n = v3;
                return n != null ? n : -1;
            }

            public final int indexOf(@Nullable String name) {
                Object v1;
                block3: {
                    block5: {
                        block4: {
                            if (name == null) break block4;
                            CharSequence charSequence = name;
                            boolean bl = false;
                            if (!(charSequence.length() == 0)) break block5;
                        }
                        return -1;
                    }
                    Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.count);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl = false;
                        Member member = this.members[it];
                        if (!Intrinsics.areEqual((Object)name, (Object)(member != null ? member.getName() : null))) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                Integer n = v1;
                return n != null ? n : -1;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean isMember(@Nullable EntityLivingBase mr) {
                if (mr != null) {
                    int n = 0;
                    int n2 = this.count;
                    while (n < n2) {
                        void i;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[i];
                            if (Intrinsics.areEqual((Object)mr.func_110124_au(), (Object)(member != null ? member.getUuid() : null))) {
                                return true;
                            }
                        } else {
                            Serializable serializable = this.members[i];
                            if (serializable != null && (serializable = ((Member)serializable).getUuid()) != null) {
                                if ((long)mr.func_145782_y() == ((UUID)serializable).getMostSignificantBits()) {
                                    return true;
                                }
                            }
                        }
                        ++i;
                    }
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean isMember(@Nullable UUID uuid) {
                if (uuid != null) {
                    int n = 0;
                    int n2 = this.count;
                    while (n < n2) {
                        void i;
                        if (ASJUtilities.isServer()) {
                            Member member = this.members[i];
                            if (Intrinsics.areEqual((Object)uuid, (Object)(member != null ? member.getUuid() : null))) {
                                return true;
                            }
                        } else {
                            Serializable serializable = this.members[i];
                            if (serializable != null && (serializable = ((Member)serializable).getUuid()) != null) {
                                if (uuid.getMostSignificantBits() == ((UUID)serializable).getMostSignificantBits()) {
                                    return true;
                                }
                            }
                        }
                        ++i;
                    }
                }
                return false;
            }

            public final void setDead(int i, boolean d) {
                block1: {
                    if (!ASJUtilities.isClient()) break block1;
                    Member member = this.members[i];
                    if (member != null) {
                        member.setDead(d);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void setDead(@NotNull EntityLivingBase mr, boolean d) {
                Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
                int i = this.indexOf(mr);
                if (i != -1) {
                    if (mr instanceof EntityPlayer) {
                        Member member = this.members[i];
                        if (member != null) {
                            member.setDead(d);
                        }
                        this.sendDead(i, d);
                    } else if (d) {
                        this.remove(mr);
                        int n = 0;
                        int n2 = this.count;
                        while (n < n2) {
                            void j;
                            Member member = this.members[j];
                            if (member != null) {
                                if (member.isPlayer()) {
                                    EntityLivingBase e = this.get((int)j);
                                    if (e instanceof EntityPlayer) {
                                        String string;
                                        EntityPlayer entityPlayer = (EntityPlayer)e;
                                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                        Intrinsics.checkNotNullExpressionValue((Object)StatCollector.func_74838_a((String)"alfheimmisc.party.memberdied"), (String)"StatCollector.translateT\u2026immisc.party.memberdied\")");
                                        Object[] objectArray = new Object[]{mr.func_70005_c_()};
                                        boolean bl = false;
                                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(string2));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                }
            }

            public final void setUUID(int i, int enID) {
                block1: {
                    if (this.members[i] == null) break block1;
                    Member member = this.members[i];
                    if (member != null) {
                        member.setUuid(new UUID(enID, enID));
                    }
                }
            }

            public final boolean add(@Nullable EntityLivingBase mr) {
                if (mr == null) {
                    return false;
                }
                if (this.indexOf(mr) != -1) {
                    return false;
                }
                if (this.count >= this.members.length) {
                    return false;
                }
                int n = this.count;
                this.count = n + 1;
                String string = mr.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mr.commandSenderName");
                UUID uUID = mr.func_110124_au();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"mr.uniqueID");
                this.members[n] = new Member(string, uUID, ManaSystem.INSTANCE.getMana(mr), mr instanceof EntityPlayer, !mr.func_70089_S(), mr.func_110143_aJ(), mr.func_110138_aP(), Member.MemberType.Companion.typeOf(mr).ordinal());
                this.sendChanges();
                CardinalSystem.INSTANCE.save(AlfheimCore.Companion.getSave());
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final boolean remove(@Nullable EntityLivingBase mr) {
                boolean bl;
                if (mr == null) {
                    return false;
                }
                if (mr instanceof EntityPlayer) {
                    Member member = this.members[0];
                    if (Intrinsics.areEqual((Object)(member != null ? member.getName() : null), (Object)((EntityPlayer)mr).func_70005_c_())) {
                        bl = this.removePL();
                        return bl;
                    }
                }
                bl = this.removeSafe(mr);
                return bl;
            }

            public final boolean remove(@Nullable String name) {
                block3: {
                    block2: {
                        if (name == null) break block2;
                        CharSequence charSequence = name;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block3;
                    }
                    return false;
                }
                Member member = this.members[0];
                return Intrinsics.areEqual((Object)(member != null ? member.getName() : null), (Object)name) ? this.removePL() : this.removeSafe(name);
            }

            private final boolean removePL() {
                if (this.getPl() == null) {
                    return false;
                }
                EntityPlayer entityPlayer = this.getPl();
                Intrinsics.checkNotNull((Object)entityPlayer);
                EntityPlayer entityPlayer2 = this.getPl();
                Intrinsics.checkNotNull((Object)entityPlayer2);
                INSTANCE.setParty(entityPlayer, new Party(entityPlayer2));
                for (int i = 1; i < this.count; ++i) {
                    Member member = this.members[i];
                    if (member == null) continue;
                    if (!member.isPlayer()) continue;
                    this.members[0] = this.members[i];
                    Party party = this;
                    party.count += -1;
                    int cfr_ignored_0 = party.count;
                    while (i < this.count) {
                        this.members[i] = this.members[i + 1];
                        ++i;
                    }
                    this.sendChanges();
                }
                CardinalSystem.INSTANCE.save(AlfheimCore.Companion.getSave());
                return true;
            }

            private final boolean removeSafe(String name) {
                int id;
                block6: {
                    block5: {
                        if (name == null) break block5;
                        CharSequence charSequence = name;
                        boolean bl = false;
                        if (!(charSequence.length() == 0)) break block6;
                    }
                    return false;
                }
                EntityLivingBase mr = this.get(name);
                if (mr == null && id != -1 && !this.isPlayer(id)) {
                    Party party = this;
                    party.count += -1;
                    int cfr_ignored_0 = party.count;
                    for (id = this.indexOf(name); id < this.count; ++id) {
                        this.members[id] = this.members[id + 1];
                    }
                    this.members[this.count] = null;
                    this.sendChanges();
                    CardinalSystem.INSTANCE.save(AlfheimCore.Companion.getSave());
                    return true;
                }
                return this.removeSafe(mr);
            }

            private final boolean removeSafe(EntityLivingBase mr) {
                if (mr == null) {
                    return false;
                }
                int id = this.indexOf(mr);
                if (id == -1) {
                    return false;
                }
                Party party = this;
                party.count += -1;
                int cfr_ignored_0 = party.count;
                if (mr instanceof EntityPlayer) {
                    INSTANCE.setParty((EntityPlayer)mr, new Party((EntityPlayer)mr));
                }
                while (id < this.count) {
                    this.members[id] = this.members[id + 1];
                    ++id;
                }
                this.members[this.count] = null;
                this.sendChanges();
                CardinalSystem.INSTANCE.save(AlfheimCore.Companion.getSave());
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public final void sendChanges() {
                if (ASJUtilities.isServer()) {
                    int n = 0;
                    int n2 = this.count;
                    while (n < n2) {
                        void i;
                        EntityLivingBase e = this.get((int)i);
                        if (e != null) {
                            Member member = this.members[i];
                            if (member != null) {
                                if (member.isPlayer()) {
                                    if (e instanceof EntityPlayerMP) {
                                        INSTANCE.transfer((EntityPlayerMP)e);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void sendDead(int id, boolean d) {
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    void i;
                    EntityLivingBase e = this.get((int)i);
                    if (e != null) {
                        Member member = this.members[i];
                        if (member != null) {
                            if (member.isPlayer()) {
                                if (e instanceof EntityPlayerMP) {
                                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message3d(Message3d.m3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.DEAD.ordinal()), ExtensionsKt.getD((Number)id), ExtensionsKt.getD((Number)(d ? -10 : -100))), (EntityPlayerMP)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void sendHealth(int index, float health) {
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    void i;
                    EntityLivingBase e = this.get((int)i);
                    if (e != null) {
                        Member member = this.members[i];
                        if (member != null) {
                            if (member.isPlayer()) {
                                if (e instanceof EntityPlayerMP) {
                                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message3d(Message3d.m3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.HEALTH.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)Float.valueOf(health))), (EntityPlayerMP)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void sendMaxHealth(int index, float maxHealth) {
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    void i;
                    EntityLivingBase e = this.get((int)i);
                    if (e != null) {
                        Member member = this.members[i];
                        if (member != null) {
                            if (member.isPlayer()) {
                                if (e instanceof EntityPlayerMP) {
                                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message3d(Message3d.m3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.MAXHEALTH.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)Float.valueOf(maxHealth))), (EntityPlayerMP)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void sendMana(@NotNull EntityPlayer player, int mana) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                int index = this.indexOf((EntityLivingBase)player);
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    void i;
                    EntityLivingBase e = this.get((int)i);
                    if (e != null) {
                        Member member = this.members[i];
                        if (member != null) {
                            if (member.isPlayer()) {
                                if (e instanceof EntityPlayerMP) {
                                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message3d(Message3d.m3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.MANA.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)mana)), (EntityPlayerMP)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void sendType(int index, int type) {
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    void i;
                    EntityLivingBase e = this.get((int)i);
                    if (e != null) {
                        Member member = this.members[i];
                        if (member != null) {
                            if (member.isPlayer()) {
                                if (e instanceof EntityPlayerMP) {
                                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message3d(Message3d.m3d.PARTY_STATUS, ExtensionsKt.getD((Number)PartyStatus.TYPE.ordinal()), ExtensionsKt.getD((Number)index), ExtensionsKt.getD((Number)type)), (EntityPlayerMP)e);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void write(@NotNull ByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                buf.writeInt(this.members.length);
                buf.writeInt(this.count);
                EntityLivingBase mr = null;
                int n = 0;
                int n2 = this.count;
                while (n < n2) {
                    Object object;
                    void i;
                    mr = this.get((int)i);
                    if (serverIO) {
                        Object object2 = mr;
                        buf.writeLong(object2 != null && (object2 = object2.func_110124_au()) != null ? ((UUID)object2).getMostSignificantBits() : 0L);
                        Object object3 = mr;
                        buf.writeLong(object3 != null && (object3 = object3.func_110124_au()) != null ? ((UUID)object3).getLeastSignificantBits() : 0L);
                    } else {
                        EntityLivingBase entityLivingBase = mr;
                        buf.writeInt(entityLivingBase != null ? entityLivingBase.func_145782_y() : 0);
                    }
                    if ((object = this.members[i]) == null || (object = ((Member)object).getName()) == null) {
                        object = "";
                    }
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)object);
                    Member member = this.members[i];
                    buf.writeInt(member != null ? member.getMana() : 0);
                    Member member2 = this.members[i];
                    buf.writeBoolean(member2 != null ? member2.isPlayer() : false);
                    Member member3 = this.members[i];
                    buf.writeBoolean(member3 != null ? member3.isDead() : false);
                    Member member4 = this.members[i];
                    buf.writeFloat(member4 != null ? member4.getHealth() : 0.0f);
                    Member member5 = this.members[i];
                    buf.writeFloat(member5 != null ? member5.getMaxHealth() : 0.0f);
                    Member member6 = this.members[i];
                    buf.writeInt(member6 != null ? member6.getType() : Member.MemberType.MOB.ordinal());
                    ++i;
                }
            }

            @NotNull
            public Object clone() {
                Party result = new Party();
                result.members = (Member[])this.members.clone();
                result.count = this.count;
                return result;
            }

            public Party() {
                this.members = new Member[AlfheimConfigHandler.INSTANCE.getMaxPartyMembers()];
            }

            private Party(int i) {
                this.members = new Member[i];
            }

            public Party(@NotNull EntityPlayer pl) {
                Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
                this();
                int n = this.count;
                this.count = n + 1;
                String string = pl.func_70005_c_();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pl.commandSenderName");
                UUID uUID = pl.func_110124_au();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"pl.uniqueID");
                this.members[n] = new Member(string, uUID, ManaSystem.INSTANCE.getMana(pl), true, !pl.func_70089_S(), pl.func_110143_aJ(), pl.func_110138_aP(), Member.MemberType.Companion.typeOf((EntityLivingBase)pl).ordinal());
            }

            static {
                Companion = new Companion(null);
            }

            public /* synthetic */ Party(int i, DefaultConstructorMarker $constructor_marker) {
                this(i);
            }

            public static final /* synthetic */ void access$setMembers$p(Party $this, Member[] memberArray) {
                $this.members = memberArray;
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$PartyStatus;", "", "(Ljava/lang/String;I)V", "DEAD", "HEALTH", "MAXHEALTH", "MANA", "TYPE", "Alfheim"})
            public static final class PartyStatus
            extends Enum<PartyStatus> {
                public static final /* enum */ PartyStatus DEAD;
                public static final /* enum */ PartyStatus HEALTH;
                public static final /* enum */ PartyStatus MAXHEALTH;
                public static final /* enum */ PartyStatus MANA;
                public static final /* enum */ PartyStatus TYPE;
                private static final /* synthetic */ PartyStatus[] $VALUES;

                static {
                    PartyStatus[] partyStatusArray = new PartyStatus[5];
                    PartyStatus[] partyStatusArray2 = partyStatusArray;
                    partyStatusArray[0] = DEAD = new PartyStatus();
                    partyStatusArray[1] = HEALTH = new PartyStatus();
                    partyStatusArray[2] = MAXHEALTH = new PartyStatus();
                    partyStatusArray[3] = MANA = new PartyStatus();
                    partyStatusArray[4] = TYPE = new PartyStatus();
                    $VALUES = partyStatusArray;
                }

                public static PartyStatus[] values() {
                    return (PartyStatus[])$VALUES.clone();
                }

                public static PartyStatus valueOf(String string) {
                    return Enum.valueOf(PartyStatus.class, string);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u001c\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002'(BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\b\u0010&\u001a\u00020\u0000H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member;", "Ljava/io/Serializable;", "", "name", "", "uuid", "Ljava/util/UUID;", "mana", "", "isPlayer", "", "isDead", "health", "", "maxHealth", "type", "(Ljava/lang/String;Ljava/util/UUID;IZZFFI)V", "getHealth", "()F", "setHealth", "(F)V", "()Z", "setDead", "(Z)V", "getMana", "()I", "setMana", "(I)V", "getMaxHealth", "setMaxHealth", "getName", "()Ljava/lang/String;", "getType", "setType", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "clone", "Companion", "MemberType", "Alfheim"})
            private static final class Member
            implements Serializable,
            Cloneable {
                @NotNull
                private final String name;
                @NotNull
                private UUID uuid;
                private int mana;
                private final boolean isPlayer;
                private boolean isDead;
                private float health;
                private float maxHealth;
                private int type;
                private static final long serialVersionUID = 8416468367146381L;
                @NotNull
                public static final Companion Companion = new Companion(null);

                @NotNull
                public Member clone() {
                    return new Member(this.name, this.uuid, this.mana, this.isPlayer, this.isDead, this.health, this.maxHealth, this.type);
                }

                @NotNull
                public final String getName() {
                    return this.name;
                }

                @NotNull
                public final UUID getUuid() {
                    return this.uuid;
                }

                public final void setUuid(@NotNull UUID uUID) {
                    Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
                    this.uuid = uUID;
                }

                public final int getMana() {
                    return this.mana;
                }

                public final void setMana(int n) {
                    this.mana = n;
                }

                public final boolean isPlayer() {
                    return this.isPlayer;
                }

                public final boolean isDead() {
                    return this.isDead;
                }

                public final void setDead(boolean bl) {
                    this.isDead = bl;
                }

                public final float getHealth() {
                    return this.health;
                }

                public final void setHealth(float f) {
                    this.health = f;
                }

                public final float getMaxHealth() {
                    return this.maxHealth;
                }

                public final void setMaxHealth(float f) {
                    this.maxHealth = f;
                }

                public final int getType() {
                    return this.type;
                }

                public final void setType(int n) {
                    this.type = n;
                }

                public Member(@NotNull String name, @NotNull UUID uuid, int mana, boolean isPlayer, boolean isDead, float health, float maxHealth, int type) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                    this.name = name;
                    this.uuid = uuid;
                    this.mana = mana;
                    this.isPlayer = isPlayer;
                    this.isDead = isDead;
                    this.health = health;
                    this.maxHealth = maxHealth;
                    this.type = type;
                }

                @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType;", "", "(Ljava/lang/String;I)V", "HUMAN", "SALAMANDER", "SYLPH", "CAITSITH", "POOKA", "GNOME", "LEPRECHAUN", "SPRIGGAN", "UNDINE", "IMP", "ALV", "MOB", "NPC", "BOSS", "Companion", "Alfheim"})
                public static final class MemberType
                extends Enum<MemberType> {
                    public static final /* enum */ MemberType HUMAN;
                    public static final /* enum */ MemberType SALAMANDER;
                    public static final /* enum */ MemberType SYLPH;
                    public static final /* enum */ MemberType CAITSITH;
                    public static final /* enum */ MemberType POOKA;
                    public static final /* enum */ MemberType GNOME;
                    public static final /* enum */ MemberType LEPRECHAUN;
                    public static final /* enum */ MemberType SPRIGGAN;
                    public static final /* enum */ MemberType UNDINE;
                    public static final /* enum */ MemberType IMP;
                    public static final /* enum */ MemberType ALV;
                    public static final /* enum */ MemberType MOB;
                    public static final /* enum */ MemberType NPC;
                    public static final /* enum */ MemberType BOSS;
                    private static final /* synthetic */ MemberType[] $VALUES;
                    @NotNull
                    public static final Companion Companion;

                    static {
                        MemberType[] memberTypeArray = new MemberType[14];
                        MemberType[] memberTypeArray2 = memberTypeArray;
                        memberTypeArray[0] = HUMAN = new MemberType();
                        memberTypeArray[1] = SALAMANDER = new MemberType();
                        memberTypeArray[2] = SYLPH = new MemberType();
                        memberTypeArray[3] = CAITSITH = new MemberType();
                        memberTypeArray[4] = POOKA = new MemberType();
                        memberTypeArray[5] = GNOME = new MemberType();
                        memberTypeArray[6] = LEPRECHAUN = new MemberType();
                        memberTypeArray[7] = SPRIGGAN = new MemberType();
                        memberTypeArray[8] = UNDINE = new MemberType();
                        memberTypeArray[9] = IMP = new MemberType();
                        memberTypeArray[10] = ALV = new MemberType();
                        memberTypeArray[11] = MOB = new MemberType();
                        memberTypeArray[12] = NPC = new MemberType();
                        memberTypeArray[13] = BOSS = new MemberType();
                        $VALUES = memberTypeArray;
                        Companion = new Companion(null);
                    }

                    public static MemberType[] values() {
                        return (MemberType[])$VALUES.clone();
                    }

                    public static MemberType valueOf(String string) {
                        return Enum.valueOf(MemberType.class, string);
                    }

                    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType$Companion;", "", "()V", "typeOf", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$MemberType;", "e", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
                    public static final class Companion {
                        @NotNull
                        public final MemberType typeOf(@NotNull EntityLivingBase e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            EntityLivingBase entityLivingBase = e;
                            return entityLivingBase instanceof EntityPlayer ? MemberType.values()[EnumRaceKt.getRaceID((EntityPlayer)e)] : (entityLivingBase instanceof IBossDisplayData ? BOSS : (entityLivingBase instanceof INpc ? NPC : MOB));
                        }

                        private Companion() {
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }

                @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Member$Companion;", "", "()V", "serialVersionUID", "", "Alfheim"})
                public static final class Companion {
                    private Companion() {
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party$Companion;", "", "()V", "serialVersionUID", "", "serverIO", "", "getServerIO", "()Z", "setServerIO", "(Z)V", "read", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "buf", "Lio/netty/buffer/ByteBuf;", "Alfheim"})
            public static final class Companion {
                public final boolean getServerIO() {
                    return serverIO;
                }

                public final void setServerIO(boolean bl) {
                    serverIO = bl;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Party read(@NotNull ByteBuf buf) {
                    Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                    int size = buf.readInt();
                    int count = buf.readInt();
                    Party pt = new Party(size, null);
                    pt.setCount(count);
                    long most = 0L;
                    long least = 0L;
                    int n = 0;
                    int n2 = count;
                    while (n < n2) {
                        void i;
                        if (this.getServerIO()) {
                            most = buf.readLong();
                            least = buf.readLong();
                        } else {
                            most = least = (long)buf.readInt();
                        }
                        Member[] memberArray = pt.members;
                        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ByteBufUtils.readUTF8String(buf)");
                        memberArray[i] = new Member(string, new UUID(most, least), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readFloat(), buf.readFloat(), buf.readInt());
                        ++i;
                    }
                    return pt;
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PartySystem$PartyThingsListener;", "", "()V", "onClonePlayer", "", "e", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onPlayerRespawn", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "Alfheim"})
        public static final class PartyThingsListener {
            @SubscribeEvent
            public final void onClonePlayer(@NotNull PlayerEvent.Clone e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && e.wasDeath) {
                    EntityPlayer entityPlayer = e.entityPlayer;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
                    Party party = INSTANCE.getParty(entityPlayer);
                    EntityPlayer entityPlayer2 = e.entityPlayer;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"e.entityPlayer");
                    party.setDead((EntityLivingBase)entityPlayer2, false);
                }
            }

            @SubscribeEvent
            public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
                    EntityPlayer entityPlayer = e.player;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.player");
                    Party party = INSTANCE.getParty(entityPlayer);
                    EntityPlayer entityPlayer2 = e.player;
                    Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"e.player");
                    party.setDead((EntityLivingBase)entityPlayer2, false);
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lalfheim/common/core/handler/CardinalSystem$HotSpellsSystem;", "", "()V", "getHotSpellID", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "slot", "setHotSpellID", "", "id", "transfer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Alfheim"})
    public static final class HotSpellsSystem {
        @NotNull
        public static final HotSpellsSystem INSTANCE;

        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AlfheimCore.Companion.getNetwork().sendTo((IMessage)new MessageHotSpellC(INSTANCE.forPlayer((EntityPlayer)player).getHotSpells()), player);
        }

        public final int getHotSpellID(@NotNull EntityPlayer player, int slot) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getHotSpells()[slot];
        }

        public final void setHotSpellID(@NotNull EntityPlayer player, int slot, int id) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            CardinalSystem.INSTANCE.forPlayer((EntityPlayer)player).getHotSpells()[slot] = id;
            INSTANCE.save(AlfheimCore.Companion.getSave());
        }

        private HotSpellsSystem() {
        }

        static {
            HotSpellsSystem hotSpellsSystem;
            INSTANCE = hotSpellsSystem = new HotSpellsSystem();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005R,\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem;", "", "()V", "tsAreas", "Ljava/util/HashMap;", "", "Ljava/util/LinkedList;", "Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea;", "getTsAreas", "()Ljava/util/HashMap;", "setTsAreas", "(Ljava/util/HashMap;)V", "affected", "", "e", "Lnet/minecraft/entity/Entity;", "stop", "", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "tick", "transfer", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "fromDim", "TimeStopArea", "TimeStopThingsListener", "Alfheim"})
    public static final class TimeStopSystem {
        @NotNull
        private static HashMap<Integer, LinkedList<TimeStopArea>> tsAreas;
        @NotNull
        public static final TimeStopSystem INSTANCE;

        @NotNull
        public final HashMap<Integer, LinkedList<TimeStopArea>> getTsAreas() {
            return tsAreas;
        }

        public final void setTsAreas(@NotNull HashMap<Integer, LinkedList<TimeStopArea>> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            tsAreas = hashMap;
        }

        public final void transfer(@NotNull EntityPlayerMP player, int fromDim) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (tsAreas.get(fromDim) != null) {
                LinkedList<TimeStopArea> linkedList = tsAreas.get(fromDim);
                Intrinsics.checkNotNull(linkedList);
                for (TimeStopArea tsa : linkedList) {
                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message1d(Message1d.m1d.TIME_STOP_REMOVE, ExtensionsKt.getD((Number)tsa.getId())), player);
                }
            }
            if (tsAreas.get(player.field_71093_bK) != null) {
                LinkedList<TimeStopArea> linkedList = tsAreas.get(player.field_71093_bK);
                Intrinsics.checkNotNull(linkedList);
                for (TimeStopArea tsa : linkedList) {
                    AlfheimCore.Companion.getNetwork().sendTo((IMessage)new MessageTimeStop(PartySystem.INSTANCE.getUUIDParty(tsa.getUuid()), tsa.getPos().getX(), tsa.getPos().getY(), tsa.getPos().getZ(), tsa.getId()), player);
                }
            }
        }

        public final void stop(@NotNull EntityLivingBase caster) {
            Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
            caster.field_70170_p.func_82739_e(1013, ExtensionsKt.getI((Number)caster.field_70165_t), ExtensionsKt.getI((Number)caster.field_70163_u), ExtensionsKt.getI((Number)caster.field_70161_v), 0);
            if (tsAreas.get(caster.field_71093_bK) == null) {
                ((Map)tsAreas).put(caster.field_71093_bK, new LinkedList());
            }
            LinkedList<TimeStopArea> linkedList = tsAreas.get(caster.field_71093_bK);
            Intrinsics.checkNotNull(linkedList);
            linkedList.addLast(new TimeStopArea(caster));
            AlfheimCore.Companion.getNetwork().sendToDimension((IMessage)new MessageTimeStop(PartySystem.INSTANCE.getMobParty(caster), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, TimeStopArea.Companion.getNextID()), caster.field_71093_bK);
        }

        public final void tick() {
            TimeStopArea tsa = null;
            for (Integer dim : tsAreas.keySet()) {
                Iterator i;
                LinkedList<TimeStopArea> tsas;
                Intrinsics.checkNotNull(tsAreas.get(dim));
                Intrinsics.checkNotNullExpressionValue(tsas, (String)"tsAreas[dim]!!");
                Intrinsics.checkNotNullExpressionValue(tsas.iterator(), (String)"tsas.iterator()");
                while (i.hasNext()) {
                    Object e = i.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"i.next()");
                    TimeStopArea timeStopArea = tsa = (TimeStopArea)e;
                    timeStopArea.setLife(timeStopArea.getLife() + -1);
                    if (timeStopArea.getLife() > 0) continue;
                    i.remove();
                    SimpleNetworkWrapper simpleNetworkWrapper = AlfheimCore.Companion.getNetwork();
                    IMessage iMessage = (IMessage)new Message1d(Message1d.m1d.TIME_STOP_REMOVE, ExtensionsKt.getD((Number)tsa.getId()));
                    Integer n = dim;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"dim");
                    simpleNetworkWrapper.sendToDimension(iMessage, n.intValue());
                }
            }
        }

        public final boolean affected(@Nullable Entity e) {
            if (e == null) {
                return false;
            }
            TimeStopCheckEvent.TimeStopEntityCheckEvent ev = new TimeStopCheckEvent.TimeStopEntityCheckEvent(e);
            if (MinecraftForge.EVENT_BUS.post((Event)ev)) {
                return ev.getResult();
            }
            if (e instanceof IBossDisplayData) {
                return false;
            }
            if (e instanceof ITimeStopSpecific && ((ITimeStopSpecific)e).isImmune()) {
                return false;
            }
            if (tsAreas.get(e.field_71093_bK) == null) {
                return false;
            }
            LinkedList<TimeStopArea> linkedList = tsAreas.get(e.field_71093_bK);
            Intrinsics.checkNotNull(linkedList);
            for (TimeStopArea tsa : linkedList) {
                block16: {
                    block15: {
                        Object v4;
                        block14: {
                            if (!(Vector3.Companion.vecEntityDistance(tsa.getPos(), e) < SpellTimeStop.INSTANCE.getRadius())) continue;
                            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
                            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"MinecraftServer.getServer()");
                            List list = minecraftServer.func_71203_ab().field_72404_b;
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MinecraftServer.getServe\u2026nManager.playerEntityList");
                            Iterable $this$firstOrNull$iv = list;
                            boolean $i$f$firstOrNull = false;
                            Iterator iterator = $this$firstOrNull$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv;
                                Object it = element$iv = iterator.next();
                                boolean bl = false;
                                Object t = it;
                                if (t == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                                }
                                EntityPlayerMP cfr_ignored_0 = (EntityPlayerMP)t;
                                if (!Intrinsics.areEqual((Object)((EntityPlayerMP)it).func_110124_au(), (Object)tsa.getUuid())) continue;
                                v4 = element$iv;
                                break block14;
                            }
                            v4 = null;
                        }
                        if (v4 == null) break block15;
                        Object var5_5 = v4;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = var5_5;
                        boolean bl3 = false;
                        Object v5 = it;
                        if (v5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                        }
                        boolean bl4 = !InteractionSecurity.INSTANCE.canDoSomethingWithEntity((EntityLivingBase)((EntityPlayerMP)v5), e);
                        if (!bl4) break block16;
                    }
                    return false;
                }
                if (e instanceof ITimeStopSpecific && ((ITimeStopSpecific)e).affectedBy(tsa.getUuid())) {
                    return true;
                }
                if (e instanceof EntityLivingBase) {
                    if (PartySystem.INSTANCE.sameParty(tsa.getUuid(), (EntityLivingBase)e)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        private TimeStopSystem() {
        }

        static {
            TimeStopSystem timeStopSystem;
            INSTANCE = timeStopSystem = new TimeStopSystem();
            tsAreas = new HashMap();
            MinecraftForge.EVENT_BUS.register((Object)TimeStopThingsListener.INSTANCE);
            FMLCommonHandler.instance().bus().register((Object)TimeStopThingsListener.INSTANCE);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea;", "Ljava/io/Serializable;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "(Lnet/minecraft/entity/EntityLivingBase;)V", "id", "", "getId", "()I", "life", "getLife", "setLife", "(I)V", "pos", "Lalexsocol/asjlib/math/Vector3;", "getPos", "()Lalexsocol/asjlib/math/Vector3;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Companion", "Alfheim"})
        public static final class TimeStopArea
        implements Serializable {
            @NotNull
            private final Vector3 pos;
            @NotNull
            private final UUID uuid;
            private final transient int id;
            private int life;
            private static final long serialVersionUID = 4146871637815241L;
            private static transient int nextID;
            @NotNull
            public static final Companion Companion;

            @NotNull
            public final Vector3 getPos() {
                return this.pos;
            }

            @NotNull
            public final UUID getUuid() {
                return this.uuid;
            }

            public final int getId() {
                return this.id;
            }

            public final int getLife() {
                return this.life;
            }

            public final void setLife(int n) {
                this.life = n;
            }

            public TimeStopArea(@NotNull EntityLivingBase caster) {
                Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
                this.pos = Vector3.Companion.fromEntity((Entity)caster);
                UUID uUID = caster.func_110124_au();
                Intrinsics.checkNotNull((Object)uUID);
                this.uuid = uUID;
                this.life = SpellTimeStop.INSTANCE.getDuration();
                this.id = ++nextID;
            }

            static {
                Companion = new Companion(null);
                nextID = -1;
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopArea$Companion;", "", "()V", "nextID", "", "getNextID", "()I", "setNextID", "(I)V", "serialVersionUID", "", "Alfheim"})
            public static final class Companion {
                public final int getNextID() {
                    return nextID;
                }

                public final void setNextID(int n) {
                    nextID = n;
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$TimeStopSystem$TimeStopThingsListener;", "", "()V", "onChatEvent", "", "e", "Lnet/minecraftforge/event/ServerChatEvent;", "onCommandEvent", "Lnet/minecraftforge/event/CommandEvent;", "onEntityUpdate", "Lalexsocol/patcher/event/EntityUpdateEvent;", "onLivingUpdate", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "onPlayerChangedDimension", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "Alfheim"})
        public static final class TimeStopThingsListener {
            @NotNull
            public static final TimeStopThingsListener INSTANCE;

            @SubscribeEvent
            public final void onPlayerChangedDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && e.player instanceof EntityPlayerMP) {
                    EntityPlayer entityPlayer = e.player;
                    if (entityPlayer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
                    }
                    INSTANCE.transfer((EntityPlayerMP)entityPlayer, e.fromDim);
                }
            }

            @SubscribeEvent
            public final void onEntityUpdate(@NotNull EntityUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.getEntity().func_70089_S()) {
                    return;
                }
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected(e.getEntity())) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onLivingUpdate(@NotNull LivingEvent.LivingUpdateEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected(e.entity)) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onChatEvent(@NotNull ServerChatEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && INSTANCE.affected((Entity)e.player)) {
                    e.setCanceled(true);
                }
            }

            @SubscribeEvent
            public final void onCommandEvent(@NotNull CommandEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AlfheimConfigHandler.INSTANCE.getEnableMMO() && ASJUtilities.isServer() && e.sender instanceof EntityPlayer) {
                    ICommandSender iCommandSender = e.sender;
                    if (iCommandSender == null) {
                        throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                    }
                    if (INSTANCE.affected((Entity)((EntityPlayer)iCommandSender))) {
                        e.setCanceled(true);
                    }
                }
            }

            private TimeStopThingsListener() {
            }

            static {
                TimeStopThingsListener timeStopThingsListener;
                INSTANCE = timeStopThingsListener = new TimeStopThingsListener();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lalfheim/common/core/handler/CardinalSystem$ElvenSkinSystem;", "", "()V", "getGender", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hasCustomSkin", "setCustomSkin", "", "skinOn", "setGender", "isFemale", "transfer", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Alfheim"})
    public static final class ElvenSkinSystem {
        @NotNull
        public static final ElvenSkinSystem INSTANCE;

        public final boolean getGender(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getGender();
        }

        public final void setGender(@NotNull EntityPlayer player, boolean isFemale) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            INSTANCE.forPlayer(player).setGender(isFemale);
        }

        public final boolean hasCustomSkin(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return INSTANCE.forPlayer(player).getCustomSkin();
        }

        public final void setCustomSkin(@NotNull EntityPlayer player, boolean skinOn) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            INSTANCE.forPlayer(player).setCustomSkin(skinOn);
        }

        /*
         * WARNING - void declaration
         */
        public final void transfer(@NotNull EntityPlayerMP player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Map $this$forEach$iv = INSTANCE.getPlayerSegments();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void name;
                Map.Entry element$iv;
                Map.Entry $dstr$name$seg = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$name$seg;
                boolean bl3 = false;
                String string = (String)entry.getKey();
                entry = $dstr$name$seg;
                bl3 = false;
                PlayerSegment seg = (PlayerSegment)entry.getValue();
                AlfheimCore.Companion.getNetwork().sendTo((IMessage)new MessageSkinInfo((String)name, seg.getGender(), seg.getCustomSkin()), player);
            }
        }

        private ElvenSkinSystem() {
        }

        static {
            ElvenSkinSystem elvenSkinSystem;
            INSTANCE = elvenSkinSystem = new ElvenSkinSystem();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 V2\u00020\u0001:\u0001VB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010T\u001a\u00020UR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0016\"\u0004\b.\u0010\u0018R \u0010/\u001a\b\u0012\u0004\u0012\u00020\r00X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b.\u0010?R\u001a\u0010@\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010'\"\u0004\bB\u0010)R\u001a\u0010C\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010'\"\u0004\bE\u0010)R\u001a\u0010F\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010'\"\u0004\bH\u0010)R\u001c\u0010I\u001a\u0004\u0018\u00010JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010O\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010S\u00a8\u0006W"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PlayerSegment;", "Ljava/io/Serializable;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "castableSpell", "Lalfheim/api/spell/SpellBase;", "getCastableSpell", "()Lalfheim/api/spell/SpellBase;", "setCastableSpell", "(Lalfheim/api/spell/SpellBase;)V", "coolDown", "Ljava/util/HashMap;", "", "", "getCoolDown", "()Ljava/util/HashMap;", "setCoolDown", "(Ljava/util/HashMap;)V", "customSkin", "", "getCustomSkin", "()Z", "setCustomSkin", "(Z)V", "esmAbility", "getEsmAbility", "setEsmAbility", "gender", "getGender", "setGender", "hotSpells", "", "getHotSpells", "()[I", "setHotSpells", "([I)V", "ids", "getIds", "()I", "setIds", "(I)V", "init", "getInit", "setInit", "isParty", "setParty", "knowledge", "", "getKnowledge", "()Ljava/util/Set;", "setKnowledge", "(Ljava/util/Set;)V", "lastPos", "Lalexsocol/asjlib/math/Vector3;", "getLastPos", "()Lalexsocol/asjlib/math/Vector3;", "setLastPos", "(Lalexsocol/asjlib/math/Vector3;)V", "party", "Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "getParty", "()Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;", "(Lalfheim/common/core/handler/CardinalSystem$PartySystem$Party;)V", "partyIndex", "getPartyIndex", "setPartyIndex", "quadStage", "getQuadStage", "setQuadStage", "standingStill", "getStandingStill", "setStandingStill", "target", "Lnet/minecraft/entity/EntityLivingBase;", "getTarget", "()Lnet/minecraft/entity/EntityLivingBase;", "setTarget", "(Lnet/minecraft/entity/EntityLivingBase;)V", "userName", "getUserName", "()Ljava/lang/String;", "setUserName", "(Ljava/lang/String;)V", "toggleESMAbility", "", "Companion", "Alfheim"})
    public static final class PlayerSegment
    implements Serializable {
        @NotNull
        private PartySystem.Party party;
        @Nullable
        private transient EntityLivingBase target;
        private transient boolean isParty;
        private transient int partyIndex;
        @NotNull
        private HashMap<String, Integer> coolDown;
        @NotNull
        private int[] hotSpells;
        @Nullable
        private transient SpellBase castableSpell;
        private transient int ids;
        private transient int init;
        @NotNull
        private Set<String> knowledge;
        @NotNull
        private String userName;
        private boolean esmAbility;
        private boolean gender;
        private boolean customSkin;
        private transient int quadStage;
        private transient int standingStill;
        @NotNull
        private transient Vector3 lastPos;
        private static final long serialVersionUID = 6871678638741684L;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final PartySystem.Party getParty() {
            return this.party;
        }

        public final void setParty(@NotNull PartySystem.Party party) {
            Intrinsics.checkNotNullParameter((Object)party, (String)"<set-?>");
            this.party = party;
        }

        @Nullable
        public final EntityLivingBase getTarget() {
            return this.target;
        }

        public final void setTarget(@Nullable EntityLivingBase entityLivingBase) {
            this.target = entityLivingBase;
        }

        public final boolean isParty() {
            return this.isParty;
        }

        public final void setParty(boolean bl) {
            this.isParty = bl;
        }

        public final int getPartyIndex() {
            return this.partyIndex;
        }

        public final void setPartyIndex(int n) {
            this.partyIndex = n;
        }

        @NotNull
        public final HashMap<String, Integer> getCoolDown() {
            return this.coolDown;
        }

        public final void setCoolDown(@NotNull HashMap<String, Integer> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            this.coolDown = hashMap;
        }

        @NotNull
        public final int[] getHotSpells() {
            return this.hotSpells;
        }

        public final void setHotSpells(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.hotSpells = nArray;
        }

        @Nullable
        public final SpellBase getCastableSpell() {
            return this.castableSpell;
        }

        public final void setCastableSpell(@Nullable SpellBase spellBase) {
            this.castableSpell = spellBase;
        }

        public final int getIds() {
            return this.ids;
        }

        public final void setIds(int n) {
            this.ids = n;
        }

        public final int getInit() {
            return this.init;
        }

        public final void setInit(int n) {
            this.init = n;
        }

        @NotNull
        public final Set<String> getKnowledge() {
            return this.knowledge;
        }

        public final void setKnowledge(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.knowledge = set;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.userName = string;
        }

        public final boolean getEsmAbility() {
            return this.esmAbility;
        }

        public final void setEsmAbility(boolean bl) {
            this.esmAbility = bl;
        }

        public final boolean getGender() {
            return this.gender;
        }

        public final void setGender(boolean bl) {
            this.gender = bl;
        }

        public final boolean getCustomSkin() {
            return this.customSkin;
        }

        public final void setCustomSkin(boolean bl) {
            this.customSkin = bl;
        }

        public final void toggleESMAbility() {
            this.esmAbility = !this.esmAbility;
        }

        public final int getQuadStage() {
            return this.quadStage;
        }

        public final void setQuadStage(int n) {
            this.quadStage = n;
        }

        public final int getStandingStill() {
            return this.standingStill;
        }

        public final void setStandingStill(int n) {
            this.standingStill = n;
        }

        @NotNull
        public final Vector3 getLastPos() {
            return this.lastPos;
        }

        public final void setLastPos(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter((Object)vector3, (String)"<set-?>");
            this.lastPos = vector3;
        }

        public PlayerSegment(@NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.party = new PartySystem.Party(player);
            this.partyIndex = -1;
            this.coolDown = new HashMap();
            this.hotSpells = new int[12];
            this.knowledge = new HashSet();
            String string = player.func_70005_c_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"player.commandSenderName");
            this.userName = string;
            this.esmAbility = true;
            this.lastPos = Vector3.Companion.fromEntity((Entity)player);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lalfheim/common/core/handler/CardinalSystem$PlayerSegment$Companion;", "", "()V", "serialVersionUID", "", "Alfheim"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

