/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alfheim.AlfheimCore;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.ESMHandler;
import alfheim.common.core.helper.ElvenFlightHelper;
import alfheim.common.core.helper.ElvenFlightHelperKt;
import alfheim.common.network.Message2d;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lalfheim/common/core/handler/ElvenFlightHandler;", "", "()V", "onClonePlayer", "", "e", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onEntityConstructing", "Lnet/minecraftforge/event/entity/EntityEvent$EntityConstructing;", "onPlayerChangeDimension", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerRespawn", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerRespawnEvent;", "onPlayerSleeped", "Lnet/minecraftforge/event/entity/player/PlayerWakeUpEvent;", "onPlayerUpdate", "Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;", "Alfheim"})
public final class ElvenFlightHandler {
    @NotNull
    public static final ElvenFlightHandler INSTANCE;

    @SubscribeEvent
    public final void onEntityConstructing(@NotNull EntityEvent.EntityConstructing e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() && e.entity instanceof EntityPlayer) {
            Entity entity = e.entity;
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            ElvenFlightHelper.INSTANCE.ensureExistence((EntityPlayer)entity);
        }
    }

    @SubscribeEvent
    public final void onClonePlayer(@NotNull PlayerEvent.Clone e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            double d;
            EntityPlayer entityPlayer = e.entityPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
            if (e.wasDeath) {
                d = 0.0;
            } else {
                EntityPlayer entityPlayer2 = e.original;
                Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"e.original");
                d = ElvenFlightHelperKt.getFlight(entityPlayer2);
            }
            ElvenFlightHelperKt.setFlight(entityPlayer, d);
        }
    }

    @SubscribeEvent
    public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            if (ArraysKt.contains((int[])AlfheimConfigHandler.INSTANCE.getWingsBlackList(), (int)e.player.field_70170_p.field_73011_w.field_76574_g)) {
                return;
            }
            PlayerCapabilities playerCapabilities = e.player.field_71075_bZ;
            EntityPlayer entityPlayer = e.player;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.player");
            playerCapabilities.field_75101_c = EnumRaceKt.getRace(entityPlayer) != EnumRace.HUMAN;
        }
    }

    @SubscribeEvent
    public final void onPlayerChangeDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() && e.player instanceof EntityPlayerMP) {
            SimpleNetworkWrapper simpleNetworkWrapper = AlfheimCore.Companion.getNetwork();
            EntityPlayer entityPlayer = e.player;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.player");
            EntityPlayer entityPlayer2 = e.player;
            if (entityPlayer2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            simpleNetworkWrapper.sendTo((IMessage)new Message2d(Message2d.m2d.ATTRIBUTE, 1.0, ElvenFlightHelperKt.getFlight(entityPlayer)), (EntityPlayerMP)entityPlayer2);
        }
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public final void onPlayerUpdate(@NotNull TickEvent.PlayerTickEvent e) {
        block6: {
            block7: {
                block8: {
                    block9: {
                        block11: {
                            block10: {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                if (e.phase == TickEvent.Phase.START) {
                                    return;
                                }
                                player = e.player;
                                if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) break block6;
                                v0 = player;
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"player");
                                if (EnumRaceKt.getRace(v0) == EnumRace.HUMAN || ESMHandler.INSTANCE.isAbilityDisabled(player)) break block6;
                                v1 = ModItems.flightTiara;
                                if (v1 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type vazkii.botania.common.item.equipment.bauble.ItemFlightTiara");
                                }
                                if (((ItemFlightTiara)v1).shouldPlayerHaveFlight(player)) break block7;
                                if (!(ElvenFlightHelperKt.getFlight(player) >= (double)false) || !(ElvenFlightHelperKt.getFlight(player) <= ElvenFlightHelper.INSTANCE.getMax())) break block8;
                                if (!player.field_71075_bZ.field_75100_b) break block9;
                                if (player.func_70051_ag()) {
                                    player.func_70060_a(0.0f, 1.0f, 0.00625f);
                                }
                                if (!player.func_70051_ag()) break block10;
                                v2 = 3;
                                break block11;
                            }
                            var3_3 = player.field_70159_w;
                            var5_4 = false;
                            if (Math.abs(var3_3) > (double)1.0E-4f || player.field_70181_x > (double)1.0E-4f) ** GOTO lbl-1000
                            var3_3 = player.field_70179_y;
                            var5_4 = false;
                            if (Math.abs(var3_3) > (double)1.0E-4f) lbl-1000:
                            // 2 sources

                            {
                                v2 = 2;
                            } else {
                                v2 = 1;
                            }
                        }
                        ElvenFlightHelper.INSTANCE.sub(player, v2);
                        break block8;
                    }
                    ElvenFlightHelper.INSTANCE.regen(player, player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && player.field_70122_E != false && player.func_70093_af() != false ? 2 : 1);
                }
                if (ElvenFlightHelperKt.getFlight(player) <= (double)false) {
                    player.field_71075_bZ.field_75100_b = false;
                }
                break block6;
            }
            ElvenFlightHelper.INSTANCE.regen(player, player.field_70701_bs == 0.0f && player.field_70702_br == 0.0f && player.field_70122_E != false && player.func_70093_af() != false ? 2 : 1);
        }
    }

    @SubscribeEvent
    public final void onPlayerSleeped(@NotNull PlayerWakeUpEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            EntityPlayer entityPlayer = e.entityPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
            ElvenFlightHelperKt.setFlight(entityPlayer, ElvenFlightHelper.INSTANCE.getMax());
        }
    }

    private ElvenFlightHandler() {
    }

    static {
        ElvenFlightHandler elvenFlightHandler;
        INSTANCE = elvenFlightHandler = new ElvenFlightHandler();
        MinecraftForge.EVENT_BUS.register((Object)elvenFlightHandler);
        FMLCommonHandler.instance().bus().register((Object)elvenFlightHandler);
    }
}

