/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alfheim.AlfheimCore;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.event.PlayerChangedRaceEvent;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.network.Message2d;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lalfheim/common/core/handler/ElvenRaceHandler;", "", "()V", "onClonePlayer", "", "e", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "onEntityConstructing", "Lnet/minecraftforge/event/entity/EntityEvent$EntityConstructing;", "onPlayerChangeDimension", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerChangedDimensionEvent;", "onPlayerChangedRace", "Lalfheim/api/event/PlayerChangedRaceEvent;", "Alfheim"})
public final class ElvenRaceHandler {
    @NotNull
    public static final ElvenRaceHandler INSTANCE;

    @SubscribeEvent
    public final void onEntityConstructing(@NotNull EntityEvent.EntityConstructing e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() && e.entity instanceof EntityPlayer) {
            Entity entity = e.entity;
            if (entity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EnumRace.Companion.ensureExistance((EntityPlayer)entity);
        }
    }

    @SubscribeEvent
    public final void onClonePlayer(@NotNull PlayerEvent.Clone e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory()) {
            EntityPlayer entityPlayer = e.entityPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
            EntityPlayer entityPlayer2 = e.original;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer2, (String)"e.original");
            EnumRaceKt.setRaceID(entityPlayer, EnumRaceKt.getRaceID(entityPlayer2));
        }
    }

    @SubscribeEvent
    public final void onPlayerChangeDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() && e.player instanceof EntityPlayerMP) {
            SimpleNetworkWrapper simpleNetworkWrapper = AlfheimCore.Companion.getNetwork();
            EntityPlayer entityPlayer = e.player;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.player");
            EntityPlayer entityPlayer2 = e.player;
            if (entityPlayer2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
            }
            simpleNetworkWrapper.sendTo((IMessage)new Message2d(Message2d.m2d.ATTRIBUTE, 0.0, ExtensionsKt.getD((Number)EnumRaceKt.getRaceID(entityPlayer))), (EntityPlayerMP)entityPlayer2);
        }
    }

    @SubscribeEvent
    public final void onPlayerChangedRace(@NotNull PlayerChangedRaceEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        if (ASJUtilities.isServer() && AlfheimConfigHandler.INSTANCE.getEnableMMO()) {
            EntityPlayer entityPlayer = e.entityPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
            CardinalSystem.PartySystem.Party pt = CardinalSystem.INSTANCE.forPlayer(entityPlayer).getParty();
            pt.setType(pt.indexOf((EntityLivingBase)e.entityPlayer), e.getRaceTo().ordinal());
        }
    }

    private ElvenRaceHandler() {
    }

    static {
        ElvenRaceHandler elvenRaceHandler;
        INSTANCE = elvenRaceHandler = new ElvenRaceHandler();
        MinecraftForge.EVENT_BUS.register((Object)elvenRaceHandler);
        FMLCommonHandler.instance().bus().register((Object)elvenRaceHandler);
    }
}

