/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.core.handler.ragnarok;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.ItemNBTHelper;
import alexsocol.asjlib.math.Vector3;
import alfheim.AlfheimCore;
import alfheim.common.achievement.AlfheimAchievements;
import alfheim.common.block.BlockSnowGrass;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.entity.boss.EntityFenrir;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.equipment.bauble.ItemPriestEmblem;
import alfheim.common.item.equipment.bauble.faith.ItemRagnarokEmblem;
import alfheim.common.network.Message1d;
import alfheim.common.network.Message3d;
import alfheim.common.world.dim.alfheim.biome.BiomeAlfheim;
import alfmod.common.entity.EntityMuspellsun;
import alfmod.common.entity.boss.EntityDedMoroz;
import alfmod.common.item.AlfheimModularItems;
import baubles.apiext.BaublesApiExt;
import baubles.apiext.IBaublesInventoryProvider;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u00108\u001a\u00020\u001cJ\u0006\u00109\u001a\u00020\u001cJ\u0006\u0010:\u001a\u00020\u001cJ\u0006\u0010;\u001a\u00020\u001cJ+\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010@\u001a\u00020\u0004\u00a2\u0006\u0002\u0010AJ\u0010\u0010B\u001a\u00020C2\u0006\u0010=\u001a\u00020DH\u0007J\u0010\u0010E\u001a\u00020C2\u0006\u0010=\u001a\u00020FH\u0007J\u0010\u0010G\u001a\u00020C2\u0006\u0010=\u001a\u00020HH\u0007J\u0010\u0010I\u001a\u00020C2\u0006\u0010=\u001a\u00020JH\u0007J\u000e\u0010K\u001a\u00020C2\u0006\u0010L\u001a\u00020MJ\u0010\u0010N\u001a\u00020C2\u0006\u0010=\u001a\u00020OH\u0007J\u0010\u0010P\u001a\u00020C2\u0006\u0010=\u001a\u00020QH\u0007J\u0010\u0010R\u001a\u00020C2\u0006\u0010=\u001a\u00020HH\u0007J\u000e\u0010L\u001a\u00020C2\u0006\u0010L\u001a\u00020MJ\u0010\u0010S\u001a\u00020C2\u0006\u0010=\u001a\u00020FH\u0007J\u0010\u0010T\u001a\u00020C2\u0006\u0010=\u001a\u00020UH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0\u0007\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001fR$\u0010*\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001d\"\u0004\b,\u0010\u001fR\u001a\u0010-\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001d\"\u0004\b4\u0010\u001fR\u001a\u00105\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010/\"\u0004\b7\u00101\u00a8\u0006V"}, d2={"Lalfheim/common/core/handler/ragnarok/RagnarokHandler;", "", "()V", "MAX_SUMMER_TICKS", "", "MAX_WINTER_TICKS", "fenrirSet", "", "Lnet/minecraft/item/Item;", "getFenrirSet", "()[Lnet/minecraft/item/Item;", "[Lnet/minecraft/item/Item;", "fogFade", "", "getFogFade", "()F", "setFogFade", "(F)V", "handsSet", "", "Lalexsocol/asjlib/math/Vector3;", "getHandsSet", "()Ljava/util/Set;", "setHandsSet", "(Ljava/util/Set;)V", "iceSet", "getIceSet", "isSeasonDeadly", "", "()Z", "setSeasonDeadly", "(Z)V", "leatherSet", "Lnet/minecraft/item/ItemArmor;", "kotlin.jvm.PlatformType", "getLeatherSet", "()[Lnet/minecraft/item/ItemArmor;", "[Lnet/minecraft/item/ItemArmor;", "ragnarok", "getRagnarok", "setRagnarok", "value", "summer", "getSummer", "setSummer", "summerTicks", "getSummerTicks", "()I", "setSummerTicks", "(I)V", "winter", "getWinter", "setWinter", "winterTicks", "getWinterTicks", "setWinterTicks", "canEndRagnarok", "canStartRagnarok", "canStartSummer", "canStartWinter", "checkSet", "e", "Lnet/minecraft/entity/EntityLivingBase;", "set", "dmg", "(Lnet/minecraft/entity/EntityLivingBase;[Lnet/minecraft/item/Item;I)Z", "controlWeather", "", "Lcpw/mods/fml/common/gameevent/TickEvent$WorldTickEvent;", "deathFromDeadlySeason", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "doNotBetrayTheEnd", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "informAboutRagnarok", "Lcpw/mods/fml/common/gameevent/PlayerEvent$PlayerLoggedInEvent;", "load", "save", "", "lockEmblemForever", "Lnet/minecraftforge/event/entity/player/PlayerDropsEvent;", "makeTheHorizonRed", "Lnet/minecraftforge/client/event/EntityViewRenderEvent$FogColors;", "onPlayerDied", "spawnSeasonalMobs", "tick", "Lcpw/mods/fml/common/gameevent/TickEvent$ServerTickEvent;", "Alfheim"})
public final class RagnarokHandler {
    private static boolean isSeasonDeadly;
    private static boolean winter;
    private static int winterTicks;
    public static final int MAX_WINTER_TICKS = 1752000;
    private static boolean summer;
    private static int summerTicks;
    public static final int MAX_SUMMER_TICKS = 584000;
    private static boolean ragnarok;
    private static float fogFade;
    @NotNull
    private static Set<Vector3> handsSet;
    @NotNull
    private static final Item[] fenrirSet;
    @NotNull
    private static final ItemArmor[] leatherSet;
    @NotNull
    private static final Item[] iceSet;
    @NotNull
    public static final RagnarokHandler INSTANCE;

    public final boolean isSeasonDeadly() {
        return isSeasonDeadly;
    }

    public final void setSeasonDeadly(boolean bl) {
        isSeasonDeadly = bl;
    }

    public final boolean getWinter() {
        return winter;
    }

    public final void setWinter(boolean value) {
        AlfheimCore.Companion.setWinter(value);
        Iterable $this$forEach$iv = BiomeAlfheim.Companion.getAlfheimBiomes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BiomeAlfheim it = (BiomeAlfheim)((Object)element$iv);
            boolean bl = false;
            it.field_76750_F = value ? 0.0f : 0.5f;
        }
        winter = value;
    }

    public final int getWinterTicks() {
        return winterTicks;
    }

    public final void setWinterTicks(int n) {
        winterTicks = n;
    }

    public final boolean getSummer() {
        return summer;
    }

    public final void setSummer(boolean value) {
        BlockSnowGrass.Companion.setMeltDelay(value ? 1 : 20);
        summer = value;
    }

    public final int getSummerTicks() {
        return summerTicks;
    }

    public final void setSummerTicks(int n) {
        summerTicks = n;
    }

    public final boolean getRagnarok() {
        return ragnarok;
    }

    public final void setRagnarok(boolean bl) {
        ragnarok = bl;
    }

    public final float getFogFade() {
        return fogFade;
    }

    public final void setFogFade(float f) {
        fogFade = f;
    }

    @NotNull
    public final Set<Vector3> getHandsSet() {
        return handsSet;
    }

    public final void setHandsSet(@NotNull Set<Vector3> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        handsSet = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull String save) {
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        File file = new File(save + "/data/Ragnarok.sys");
        if (!file.exists()) {
            ASJUtilities.log((String)"Ragnarok data file not found. Using default values...");
            return;
        }
        try {
            Closeable closeable = new ObjectInputStream(new FileInputStream(file));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectInputStream oin = (ObjectInputStream)closeable;
                boolean bl3 = false;
                Object object = oin.readObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                isSeasonDeadly = (Boolean)object;
                Object object2 = oin.readObject();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                INSTANCE.setWinter((Boolean)object2);
                Object object3 = oin.readObject();
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                winterTicks = (Integer)object3;
                Object object4 = oin.readObject();
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                INSTANCE.setSummer((Boolean)object4);
                Object object5 = oin.readObject();
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                summerTicks = (Integer)object5;
                Object object6 = oin.readObject();
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                ragnarok = (Boolean)object6;
                Object object7 = oin.readObject();
                if (object7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.HashSet<alexsocol.asjlib.math.Vector3> /* = java.util.HashSet<alexsocol.asjlib.math.Vector3> */");
                }
                handsSet = (HashSet)object7;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to read whole Ragnarok data. Using default values...");
            e.printStackTrace();
            isSeasonDeadly = false;
            this.setWinter(false);
            winterTicks = 0;
            this.setSummer(false);
            summerTicks = 0;
            ragnarok = false;
            handsSet = new HashSet();
        }
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ServerTickEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        if (winter) {
            ++winterTicks;
        }
        if (summer) {
            ++summerTicks;
        }
        if (this.canStartRagnarok()) {
            this.setSummer(false);
            summerTicks = 0;
            ragnarok = true;
            AlfheimCore.Companion.getNetwork().sendToAll((IMessage)new Message1d(Message1d.m1d.RAGNAROK, 0.999));
            ASJUtilities.sayToAllOnline((String)"alfheimmisc.ragnarok.startedRagnarok");
            MinecraftServer minecraftServer = MinecraftServer.func_71276_C();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"MinecraftServer.getServer()");
            List list = minecraftServer.func_71203_ab().field_72404_b;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MinecraftServer.getServe\u2026nManager.playerEntityList");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                ItemStack emblem;
                Object element$iv;
                Object player = element$iv = iterator.next();
                boolean bl = false;
                Object t = player;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                }
                EntityPlayer cfr_ignored_0 = (EntityPlayer)t;
                if (((EntityPlayer)player).field_71093_bK != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim() || !ExtensionsKt.hasAchievement((EntityPlayer)((EntityPlayer)player), (Achievement)AlfheimAchievements.INSTANCE.getRagnarok())) continue;
                if (ItemRagnarokEmblem.Companion.getEmblem$default(ItemRagnarokEmblem.Companion, (EntityPlayer)player, 0, 2, null) == null) {
                    continue;
                }
                ItemNBTHelper.INSTANCE.setBoolean(emblem, "ragnarok.bound", true);
                ((EntityPlayer)player).func_71029_a((StatBase)AlfheimAchievements.INSTANCE.getTheEND());
                ASJUtilities.say((ICommandSender)((ICommandSender)player), (String)"alfheimmisc.ragnarok.startedRagnarok.special", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull String save) {
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        try {
            Closeable closeable = new ObjectOutputStream(new FileOutputStream(save + "/data/Ragnarok.sys"));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = (ObjectOutputStream)closeable;
                boolean bl3 = false;
                oos.writeObject(isSeasonDeadly);
                oos.writeObject(winter);
                oos.writeObject(winterTicks);
                oos.writeObject(summer);
                oos.writeObject(summerTicks);
                oos.writeObject(ragnarok);
                oos.writeObject(handsSet);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            ASJUtilities.error((String)"Unable to save whole Ragnarok data. Discarding. Sorry :(");
            e.printStackTrace();
        }
    }

    public final boolean canStartWinter() {
        return !winter && !summer && !ragnarok;
    }

    public final boolean canStartSummer() {
        return winter && !summer && !ragnarok && winterTicks >= 1752000 * (isSeasonDeadly ? 10 : 1);
    }

    public final boolean canStartRagnarok() {
        return !winter && summer && !ragnarok && summerTicks >= 584000 * (isSeasonDeadly ? 5 : 1);
    }

    public final boolean canEndRagnarok() {
        return !winter && !summer && ragnarok;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onPlayerDied(@NotNull LivingDeathEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ragnarok) {
            return;
        }
        DamageSource damageSource = e.source;
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"e.source");
        Entity entity = damageSource.func_76346_g();
        if (!(entity instanceof EntityPlayer)) {
            entity = null;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer ragnar = entityPlayer;
        EntityLivingBase entityLivingBase = e.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            entityLivingBase = null;
        }
        EntityPlayer entityPlayer2 = (EntityPlayer)entityLivingBase;
        if (entityPlayer2 == null) {
            return;
        }
        EntityPlayer priest = entityPlayer2;
        ItemStack itemStack = ItemRagnarokEmblem.Companion.getEmblem$default(ItemRagnarokEmblem.Companion, ragnar, 0, 2, null);
        if (itemStack == null) {
            return;
        }
        ItemStack emblemDark = itemStack;
        ItemStack itemStack2 = ItemPriestEmblem.Companion.getEmblem(-1, priest);
        if (itemStack2 == null) {
            return;
        }
        ItemStack emblemLight = itemStack2;
        ItemStack itemStack3 = ragnar.func_70694_bm();
        if ((itemStack3 != null ? itemStack3.func_77973_b() : null) != AlfheimItems.INSTANCE.getSoulSword()) {
            return;
        }
        Item item = emblemLight.func_77973_b();
        if (Intrinsics.areEqual((Object)item, (Object)AlfheimItems.INSTANCE.getPriestEmblem())) {
            byte[] arr = ItemNBTHelper.INSTANCE.getByteArray(emblemDark, "consumedPowers", new byte[6]);
            if (arr[ExtensionsKt.getMeta((ItemStack)emblemLight)] > 0) {
                return;
            }
            arr[ExtensionsKt.getMeta((ItemStack)emblemLight)] = 1;
            ItemNBTHelper.INSTANCE.setByteArray(emblemDark, "consumedPowers", arr);
        } else if (Intrinsics.areEqual((Object)item, (Object)AlfheimItems.INSTANCE.getAesirEmblem())) {
            int id;
            byte[] arr;
            block16: {
                int n;
                byte[] $this$indexOfFirst$iv = arr = ItemNBTHelper.INSTANCE.getByteArray(emblemDark, "consumedPowers", new byte[6]);
                boolean $i$f$indexOfFirst = false;
                int n2 = 0;
                int n3 = $this$indexOfFirst$iv.length;
                while (n2 < n3) {
                    void index$iv;
                    byte it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (it < 1) {
                        n = index$iv;
                        break block16;
                    }
                    ++index$iv;
                }
                n = id = -1;
            }
            if (id == -1) {
                return;
            }
            arr[id] = 1;
            ItemNBTHelper.INSTANCE.setByteArray(emblemDark, "consumedPowers", arr);
        } else {
            return;
        }
        ExtensionsKt.playSoundAtEntity((Entity)((Entity)ragnar), (String)"mob.enderdragon.growl", (float)10.0f, (float)0.1f);
        ASJUtilities.say((ICommandSender)((ICommandSender)ragnar), (String)"alfheimmisc.ragnarok.consumed", (Object[])new Object[0]);
        IBaublesInventoryProvider iBaublesInventoryProvider = BaublesApiExt.getDefaultProviderFor((EntityPlayer)priest);
        Intrinsics.checkNotNullExpressionValue((Object)iBaublesInventoryProvider, (String)"BaublesApiExt.getDefaultProviderFor(priest)");
        iBaublesInventoryProvider.getBaublesInventory().func_70299_a(0, null);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void spawnSeasonalMobs(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityLivingBase entityLivingBase = e.entityLiving;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            entityLivingBase = null;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer player = entityPlayer;
        World world = player.field_70170_p;
        if (world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        World world2 = world;
        Intrinsics.checkNotNullExpressionValue((Object)world2, (String)"world");
        if (!world2.func_82736_K().func_82766_b("doMobSpawning")) {
            return;
        }
        Random rand = world.field_73012_v;
        if (rand.nextInt(6000) != 0) {
            return;
        }
        if (winter) {
            int n = ExtensionsKt.mfloor((double)player.field_70165_t);
            Random random = rand;
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
            int x = n + ASJUtilities.randInBounds((int)-64, (int)64, (Random)random);
            int z = ExtensionsKt.mfloor((double)player.field_70161_v) + ASJUtilities.randInBounds((int)-64, (int)64, (Random)rand);
            int y = world.func_72825_h(x, z);
            world.func_72838_d((Entity)new EntityDedMoroz(world, ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z)));
            return;
        }
        if (summer) {
            int n = ExtensionsKt.mfloor((double)player.field_70165_t);
            Random random = rand;
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"rand");
            int x = n + ASJUtilities.randInBounds((int)-64, (int)64, (Random)random);
            int z = ExtensionsKt.mfloor((double)player.field_70161_v) + ASJUtilities.randInBounds((int)-64, (int)64, (Random)rand);
            int y = world.func_72825_h(x, z);
            block0 : switch (rand.nextInt(5)) {
                case 1: 
                case 2: {
                    int n2 = 0;
                    int n3 = rand.nextInt(3);
                    if (n2 > n3) break;
                    while (true) {
                        void i;
                        void $this$apply;
                        EntityBlaze entityBlaze = new EntityBlaze(world);
                        boolean bl = false;
                        boolean bl2 = false;
                        EntityBlaze entityBlaze2 = entityBlaze;
                        World world3 = world;
                        boolean bl3 = false;
                        $this$apply.func_70107_b(ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z));
                        Unit unit = Unit.INSTANCE;
                        world3.func_72838_d((Entity)entityBlaze);
                        if (i == n3) break block0;
                        ++i;
                    }
                }
                case 3: 
                case 4: {
                    int i = 0;
                    int n4 = rand.nextInt(3);
                    if (i > n4) break;
                    while (true) {
                        EntityMagmaCube entityMagmaCube = new EntityMagmaCube(world);
                        boolean bl = false;
                        boolean bl4 = false;
                        EntityMagmaCube $this$apply = entityMagmaCube;
                        World world4 = world;
                        boolean bl5 = false;
                        $this$apply.func_70107_b(ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z));
                        Unit unit = Unit.INSTANCE;
                        world4.func_72838_d((Entity)entityMagmaCube);
                        if (i == n4) break block0;
                        ++i;
                    }
                }
                default: {
                    void $this$apply;
                    EntityMuspellsun entityMuspellsun = new EntityMuspellsun(world);
                    boolean bl = false;
                    boolean bl6 = false;
                    EntityMuspellsun entityMuspellsun2 = entityMuspellsun;
                    World world5 = world;
                    boolean bl7 = false;
                    $this$apply.setPosition(ExtensionsKt.getD((Number)x), ExtensionsKt.getD((Number)y), ExtensionsKt.getD((Number)z));
                    Unit unit = Unit.INSTANCE;
                    world5.func_72838_d((Entity)entityMuspellsun);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void doNotBetrayTheEnd(@NotNull LivingDeathEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityLivingBase victim = e.entityLiving;
        if (!(victim instanceof EntityFenrir || victim instanceof EntityDedMoroz || victim instanceof EntityMuspellsun)) {
            return;
        }
        DamageSource damageSource = e.source;
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"e.source");
        Entity entity = damageSource.func_76346_g();
        if (!(entity instanceof EntityPlayer)) {
            entity = null;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer killer = entityPlayer;
        if (killer.func_70644_a(Potion.field_76441_p)) {
            return;
        }
        if (ItemRagnarokEmblem.Companion.getEmblem$default(ItemRagnarokEmblem.Companion, killer, 0, 2, null) == null) {
            return;
        }
        World world = killer.field_70170_p;
        EntityLivingBase entityLivingBase = victim;
        if (entityLivingBase instanceof EntityFenrir) {
            int n = 0;
            Random random = killer.func_70681_au();
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"killer.rng");
            int n2 = ASJUtilities.randInBounds((int)12, (int)18, (Random)random);
            if (n <= n2) {
                while (true) {
                    void i;
                    void $this$apply;
                    EntityWolf entityWolf = new EntityWolf(world);
                    boolean bl = false;
                    boolean bl2 = false;
                    EntityWolf entityWolf2 = entityWolf;
                    World world2 = world;
                    boolean bl3 = false;
                    ExtensionsKt.setPosition$default((Entity)((Entity)$this$apply), (Entity)((Entity)killer), (double)0.0, (double)0.0, (double)0.0, (int)14, null);
                    $this$apply.func_70624_b((EntityLivingBase)killer);
                    $this$apply.func_70604_c((EntityLivingBase)killer);
                    IAttributeInstance iAttributeInstance = $this$apply.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    Intrinsics.checkNotNullExpressionValue((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026sterAttributes.maxHealth)");
                    Random random2 = killer.func_70681_au();
                    Intrinsics.checkNotNullExpressionValue((Object)random2, (String)"killer.rng");
                    iAttributeInstance.func_111128_a(ExtensionsKt.getD((Number)ASJUtilities.randInBounds((int)26, (int)38, (Random)random2)));
                    Unit unit = Unit.INSTANCE;
                    world2.func_72838_d((Entity)entityWolf);
                    if (i != n2) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else if (entityLivingBase instanceof EntityDedMoroz) {
            if (!(winter || summer || ragnarok)) {
                return;
            }
            int i = 0;
            Random random = killer.func_70681_au();
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"killer.rng");
            int n = ASJUtilities.randInBounds((int)3, (int)5, (Random)random);
            if (i <= n) {
                while (true) {
                    World world3 = world;
                    Intrinsics.checkNotNullExpressionValue((Object)world3, (String)"world");
                    EntityDedMoroz entityDedMoroz = new EntityDedMoroz(world3);
                    boolean bl = false;
                    boolean bl4 = false;
                    EntityDedMoroz $this$apply = entityDedMoroz;
                    World world4 = world;
                    boolean bl5 = false;
                    ExtensionsKt.setPosition$default((Entity)((Entity)$this$apply), (Entity)((Entity)killer), (double)0.0, (double)0.0, (double)0.0, (int)14, null);
                    $this$apply.setAttackTarget((EntityLivingBase)killer);
                    $this$apply.setRevengeTarget((EntityLivingBase)killer);
                    IAttributeInstance iAttributeInstance = $this$apply.getEntityAttribute(SharedMonsterAttributes.field_111267_a);
                    Intrinsics.checkNotNullExpressionValue((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026sterAttributes.maxHealth)");
                    Random random3 = killer.func_70681_au();
                    Intrinsics.checkNotNullExpressionValue((Object)random3, (String)"killer.rng");
                    iAttributeInstance.func_111128_a(ExtensionsKt.getD((Number)ASJUtilities.randInBounds((int)420, (int)480, (Random)random3)));
                    Unit unit = Unit.INSTANCE;
                    world4.func_72838_d((Entity)entityDedMoroz);
                    if (i != n) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else if (entityLivingBase instanceof EntityMuspellsun) {
            if (!summer && !ragnarok) {
                return;
            }
            int i = 0;
            Random random = killer.func_70681_au();
            Intrinsics.checkNotNullExpressionValue((Object)random, (String)"killer.rng");
            int n = ASJUtilities.randInBounds((int)10, (int)16, (Random)random);
            if (i <= n) {
                while (true) {
                    EntityBlaze entityBlaze;
                    int n3;
                    int n4;
                    if (1 <= (n4 = (n3 = killer.func_70681_au().nextInt(5))) && 2 >= n4) {
                        entityBlaze = new EntityBlaze(world);
                    } else {
                        n4 = n3;
                        if (3 <= n4 && 4 >= n4) {
                            entityBlaze = new EntityMagmaCube(world);
                        } else {
                            World world5 = world;
                            Intrinsics.checkNotNullExpressionValue((Object)world5, (String)"world");
                            entityBlaze = new EntityMuspellsun(world5);
                        }
                    }
                    EntityLiving entityLiving = (EntityLiving)entityBlaze;
                    n4 = 0;
                    boolean bl = false;
                    EntityLiving $this$apply = entityLiving;
                    World world6 = world;
                    boolean bl6 = false;
                    ExtensionsKt.setPosition$default((Entity)((Entity)$this$apply), (Entity)((Entity)killer), (double)0.0, (double)0.0, (double)0.0, (int)14, null);
                    $this$apply.func_70624_b((EntityLivingBase)killer);
                    $this$apply.func_70604_c((EntityLivingBase)killer);
                    int baseHealth = $this$apply instanceof EntityMuspellsun ? 60 : 24;
                    IAttributeInstance iAttributeInstance = $this$apply.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    Intrinsics.checkNotNullExpressionValue((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026sterAttributes.maxHealth)");
                    int n5 = ExtensionsKt.getI((Number)((double)baseHealth * 1.5));
                    Random random4 = killer.func_70681_au();
                    Intrinsics.checkNotNullExpressionValue((Object)random4, (String)"killer.rng");
                    iAttributeInstance.func_111128_a(ExtensionsKt.getD((Number)ASJUtilities.randInBounds((int)baseHealth, (int)n5, (Random)random4)));
                    if ($this$apply instanceof EntityMagmaCube) {
                        ((EntityMagmaCube)$this$apply).func_70799_a(killer.func_70681_au().nextInt(3) + 2);
                    }
                    Unit unit = Unit.INSTANCE;
                    world6.func_72838_d((Entity)entityLiving);
                    if (i == n) break;
                    ++i;
                }
            }
        }
        ASJUtilities.say((ICommandSender)((ICommandSender)killer), (String)"alfheimmisc.ragnarok.betrayer", (Object[])new Object[0]);
    }

    @SubscribeEvent
    public final void controlWeather(@NotNull TickEvent.WorldTickEvent e) {
        int n;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.world.field_73011_w.field_76574_g != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        if (winter) {
            n = 0;
        } else if (summer) {
            n = Integer.MAX_VALUE;
        } else {
            return;
        }
        int time = n;
        World world = e.world;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"e.world");
        WorldInfo info = world.func_72912_H();
        if (info instanceof DerivedWorldInfo) {
            info = ((DerivedWorldInfo)info).field_76115_a;
        }
        e.world.func_72894_k(time == 0 ? 1.0f : 0.0f);
        WorldInfo worldInfo = info;
        Intrinsics.checkNotNullExpressionValue((Object)worldInfo, (String)"info");
        worldInfo.func_76080_g(time);
        info.func_76084_b(time == 0);
        e.world.func_147442_i(0.0f);
        info.func_76090_f(0);
        info.func_76069_a(false);
        AlfheimCore.Companion.getNetwork().sendToDimension((IMessage)new Message3d(Message3d.m3d.WAETHER, time == 0 ? 1.0 : 0.0, ExtensionsKt.getD((Number)time), ExtensionsKt.getD((Number)time)), e.world.field_73011_w.field_76574_g);
    }

    @NotNull
    public final Item[] getFenrirSet() {
        return fenrirSet;
    }

    @NotNull
    public final ItemArmor[] getLeatherSet() {
        return leatherSet;
    }

    @NotNull
    public final Item[] getIceSet() {
        return iceSet;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void deathFromDeadlySeason(@NotNull LivingEvent.LivingUpdateEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!isSeasonDeadly) {
            return;
        }
        if (e.entityLiving.field_71093_bK != AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            return;
        }
        if (e.entityLiving.field_70173_aa % 50 != 0) {
            return;
        }
        if (winter) {
            EntityLivingBase entityLivingBase = e.entityLiving;
            Intrinsics.checkNotNullExpressionValue((Object)entityLivingBase, (String)"e.entityLiving");
            if (RagnarokHandler.checkSet$default(this, entityLivingBase, fenrirSet, 0, 4, null)) {
                return;
            }
            DamageSource damageSource = new DamageSource("frost");
            boolean bl = false;
            boolean bl2 = false;
            DamageSource damageSource2 = damageSource;
            EntityLivingBase entityLivingBase2 = e.entityLiving;
            boolean bl3 = false;
            EntityLivingBase entityLivingBase3 = e.entityLiving;
            Intrinsics.checkNotNullExpressionValue((Object)entityLivingBase3, (String)"e.entityLiving");
            if (leatherSet == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<net.minecraft.item.Item>");
            }
            if (!RagnarokHandler.checkSet$default(INSTANCE, entityLivingBase3, (Item[])leatherSet, 0, 4, null)) {
                void $this$apply;
                $this$apply.func_76348_h();
            }
            Unit unit = Unit.INSTANCE;
            entityLivingBase2.func_70097_a(damageSource, 1.0f);
            return;
        }
        if (summer) {
            EntityLivingBase entityLivingBase = e.entityLiving;
            Intrinsics.checkNotNullExpressionValue((Object)entityLivingBase, (String)"e.entityLiving");
            if (this.checkSet(entityLivingBase, iceSet, 2)) {
                return;
            }
            e.entityLiving.func_70097_a(DamageSource.field_76370_b, 1.0f);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkSet(@NotNull EntityLivingBase e, @NotNull Item[] set, int dmg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        int n = 1;
        int n2 = 4;
        while (n <= n2) {
            ItemStack stack;
            void i;
            if (e.func_71124_b((int)i) == null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)set[i - true]) ^ true) {
                return false;
            }
            if (dmg > 0) {
                stack.func_77972_a(dmg, e);
                if (stack.field_77994_a == 0) {
                    e.func_70062_b((int)i, null);
                }
            }
            ++i;
        }
        return true;
    }

    public static /* synthetic */ boolean checkSet$default(RagnarokHandler ragnarokHandler, EntityLivingBase entityLivingBase, Item[] itemArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return ragnarokHandler.checkSet(entityLivingBase, itemArray, n);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void lockEmblemForever(@NotNull PlayerDropsEvent e) {
        int i;
        block6: {
            int n;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityPlayer entityPlayer = e.entityPlayer;
            Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"e.entityPlayer");
            if (!ExtensionsKt.hasAchievement((EntityPlayer)entityPlayer, (Achievement)AlfheimAchievements.INSTANCE.getTheEND())) {
                return;
            }
            ArrayList arrayList = e.drops;
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"e.drops");
            List $this$indexOfFirst$iv = arrayList;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                EntityItem it = (EntityItem)item$iv;
                boolean bl = false;
                EntityItem entityItem = it;
                Intrinsics.checkNotNullExpressionValue((Object)entityItem, (String)"it");
                if (ItemNBTHelper.INSTANCE.getBoolean(entityItem.func_92059_d(), "ragnarok.bound", false)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = i = -1;
        }
        if (i == -1) {
            return;
        }
        EntityItem entityItem = (EntityItem)e.drops.remove(i);
        if (entityItem == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)entityItem, (String)"e.drops.removeAt(i) ?: return");
        EntityItem entity = entityItem;
        IBaublesInventoryProvider iBaublesInventoryProvider = BaublesApiExt.getDefaultProviderFor((EntityPlayer)e.entityPlayer);
        Intrinsics.checkNotNullExpressionValue((Object)iBaublesInventoryProvider, (String)"BaublesApiExt.getDefault\u2026oviderFor(e.entityPlayer)");
        ItemStack itemStack = entity.func_92059_d();
        if (itemStack == null || (itemStack = itemStack.func_77946_l()) == null) {
            return;
        }
        iBaublesInventoryProvider.getBaublesInventory().func_70299_a(0, itemStack);
        entity.func_92058_a(null);
        entity.func_70106_y();
    }

    @SubscribeEvent
    public final void informAboutRagnarok(@NotNull PlayerEvent.PlayerLoggedInEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EntityPlayer entityPlayer = e.player;
        if (entityPlayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        }
        AlfheimCore.Companion.getNetwork().sendTo((IMessage)new Message1d(Message1d.m1d.RAGNAROK, ragnarok ? 0.0 : 1.0), (EntityPlayerMP)entityPlayer);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void makeTheHorizonRed(@NotNull EntityViewRenderEvent.FogColors e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ragnarok) {
            return;
        }
        if (e.entity.field_71093_bK == 1) {
            return;
        }
        if (fogFade > 0.0f) {
            fogFade -= 0.001f;
        }
        e.red += (1.0f - e.red) * (1.0f - fogFade);
        e.green *= fogFade;
        e.blue *= fogFade;
    }

    private RagnarokHandler() {
    }

    static {
        RagnarokHandler ragnarokHandler;
        INSTANCE = ragnarokHandler = new RagnarokHandler();
        fogFade = 1.0f;
        handsSet = new HashSet();
        ExtensionsKt.eventForge((Object)ragnarokHandler);
        ExtensionsKt.eventFML((Object)ragnarokHandler);
        Object[] objectArray = new Item[]{AlfheimItems.INSTANCE.getFenrirHelmet(), AlfheimItems.INSTANCE.getFenrirChestplate(), AlfheimItems.INSTANCE.getFenrirLeggings(), AlfheimItems.INSTANCE.getFenrirBoots()};
        boolean bl = false;
        boolean bl2 = false;
        Object[] $this$apply = objectArray;
        boolean bl3 = false;
        ArraysKt.reverse((Object[])$this$apply);
        fenrirSet = objectArray;
        objectArray = new ItemArmor[]{Items.field_151024_Q, Items.field_151027_R, Items.field_151026_S, Items.field_151021_T};
        bl = false;
        bl2 = false;
        $this$apply = objectArray;
        boolean bl4 = false;
        ArraysKt.reverse((Object[])$this$apply);
        leatherSet = objectArray;
        objectArray = new Item[]{AlfheimModularItems.INSTANCE.getSnowHelmet(), AlfheimModularItems.INSTANCE.getSnowChest(), AlfheimModularItems.INSTANCE.getSnowLeggings(), AlfheimModularItems.INSTANCE.getSnowBoots()};
        bl = false;
        bl2 = false;
        $this$apply = objectArray;
        boolean bl5 = false;
        ArraysKt.reverse((Object[])$this$apply);
        iceSet = objectArray;
    }
}

