/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alfheim.common.item.AlfheimItems;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.core.helper.MathHelper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u001eH\u0014J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0014R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u0006("}, d2={"Lalfheim/common/entity/EntityFracturedSpaceCollector;", "Lnet/minecraft/entity/Entity;", "world", "Lnet/minecraft/world/World;", "toX", "", "toY", "toZ", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/player/EntityPlayer;)V", "(Lnet/minecraft/world/World;)V", "ownerUUID", "Ljava/util/UUID;", "getOwnerUUID", "()Ljava/util/UUID;", "setOwnerUUID", "(Ljava/util/UUID;)V", "x", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "z", "getZ", "setZ", "doSparkles", "", "age", "entityInit", "getMaxInPortalTime", "onUpdate", "readEntityFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "Companion", "Alfheim"})
public final class EntityFracturedSpaceCollector
extends Entity {
    private int x;
    private int y;
    private int z;
    @Nullable
    private UUID ownerUUID;
    @NotNull
    public static final String TAG_OWNER_MOST = "ownerMost";
    @NotNull
    public static final String TAG_OWNER_LEAST = "ownerLeast";
    public static final double RADIUS = 2.0;
    public static final int MAX_AGE = 30;
    public static final float AGE_SPECIAL_START = 22.5f;
    public static final int MANA_COST_PER_ITEM = 5;
    public static final int PARTICLE_COUNT = 12;
    @Nullable
    private static final ItemStack TOOL_STACK;
    @NotNull
    public static final Companion Companion;

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getZ() {
        return this.z;
    }

    public final void setZ(int n) {
        this.z = n;
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@Nullable UUID uUID) {
        this.ownerUUID = uUID;
    }

    protected void func_70088_a() {
        this.func_70105_a(0.0f, 0.0f);
    }

    public void func_70071_h_() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70071_h_();
        int age = this.field_70173_aa;
        if (this.field_70170_p.field_72995_K && age <= 30) {
            this.doSparkles(age);
        } else if ((float)age > 22.5f) {
            List list = this.field_70170_p.func_72872_a(EntityItem.class, ExtensionsKt.boundingBox$default((Entity)this, null, (int)1, null).func_72314_b(2.0, 1.0, 2.0));
            if (list == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<net.minecraft.entity.item.EntityItem>");
            }
            List nearbyItemEnts = TypeIntrinsics.asMutableList((Object)list);
            CollectionsKt.removeAll((List)nearbyItemEnts, (Function1)((Function1)new Function1<EntityItem, Boolean>(this){
                final /* synthetic */ EntityFracturedSpaceCollector this$0;

                public final boolean invoke(@NotNull EntityItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (double)MathHelper.pointDistancePlane((double)it.field_70165_t, (double)it.field_70161_v, (double)this.this$0.field_70165_t, (double)this.this$0.field_70161_v) > 2.0 || !it.func_70089_S() || it.func_92059_d() == null || it.func_92059_d().field_77994_a <= 0;
                }
                {
                    this.this$0 = entityFracturedSpaceCollector;
                    super(1);
                }
            }));
            for (EntityItem ent : nearbyItemEnts) {
                double xDifference = this.field_70165_t - ent.field_70165_t;
                double zDifference = this.field_70161_v - ent.field_70161_v;
                ent.field_70159_w += xDifference * 0.3;
                ent.field_70179_y += zDifference * 0.3;
                ent.field_70133_I = true;
            }
            if (age >= 30) {
                if (this.ownerUUID == null) {
                    this.func_70106_y();
                    return;
                }
                EntityPlayer player = this.field_70170_p.func_152378_a(this.ownerUUID);
                if (player == null) {
                    this.func_70106_y();
                    return;
                }
                TileEntity tile = this.field_70170_p.func_147438_o(this.x, this.y, this.z);
                if (tile instanceof TileOpenCrate && ((TileOpenCrate)tile).canEject()) {
                    for (EntityItem ent : nearbyItemEnts) {
                        ItemStack stack = ent.func_92059_d();
                        int count = stack.field_77994_a;
                        int cost = count * 5;
                        if (!ManaItemHandler.requestManaExact((ItemStack)TOOL_STACK, (EntityPlayer)player, (int)cost, (boolean)false)) continue;
                        ManaItemHandler.requestManaExact((ItemStack)TOOL_STACK, (EntityPlayer)player, (int)cost, (boolean)true);
                        TileOpenCrate tileOpenCrate = (TileOpenCrate)tile;
                        ItemStack itemStack = stack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
                        Companion.fakeCrateEject(tileOpenCrate, itemStack);
                        ent.func_92058_a(null);
                        ent.func_70106_y();
                    }
                }
                this.func_70106_y();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doSparkles(int age) {
        double x;
        double ageFraction;
        double d = ageFraction = (double)age / ExtensionsKt.getD((Number)30);
        double d2 = 7.0;
        int n = 0;
        double radiusMult = 1.6 * (ageFraction - Math.pow(d, d2));
        double particleAngle = (double)age / 25.0;
        double height = radiusMult / (double)2;
        n = 0;
        int n2 = 12;
        while (n <= n2) {
            void i;
            boolean bl = false;
            x = Math.cos(particleAngle) * 2.0 * radiusMult;
            boolean bl2 = false;
            double z222 = Math.sin(particleAngle) * 2.0 * radiusMult;
            float size = ExtensionsKt.getF((Number)(1.0 + ageFraction * (double)5 * Math.random()));
            Botania.proxy.sparkleFX(this.field_70170_p, this.field_70165_t + x, this.field_70163_u + height, this.field_70161_v + z222, 0.5f, 0.15f, 0.9f, size, 5);
            particleAngle += 0.5235987755982988;
            ++i;
        }
        x = Math.random() * Math.PI * (double)2;
        boolean z222 = false;
        double x2 = Math.cos(x) * 2.0 * radiusMult;
        double z222 = Math.random() * Math.PI * (double)2;
        boolean bl = false;
        double z = Math.cos(z222) * 2.0 * radiusMult;
        Botania.proxy.wispFX(this.field_70170_p, this.field_70165_t + x2, this.field_70163_u - 0.5 + height, this.field_70161_v + z, 0.5f, 0.15f, 1.0f, 0.3f, -0.3f, 0.5f);
        if (age >= 28) {
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            int z222 = 0;
            int n3 = 4;
            while (z222 <= n3) {
                void i;
                Botania.proxy.wispFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, 0.45f, 0.9f, 2.0f, -0.1f, 0.1f);
                ++i;
            }
        }
    }

    protected void func_70014_b(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.func_74768_a("toX", this.x);
        nbt.func_74768_a("toY", this.y);
        nbt.func_74768_a("toZ", this.z);
        UUID uUID = this.ownerUUID;
        if (uUID == null) {
            uUID = new UUID(0L, 0L);
        }
        UUID uUID2 = uUID;
        boolean bl = false;
        boolean bl2 = false;
        UUID $this$apply = uUID2;
        boolean bl3 = false;
        nbt.func_74772_a(TAG_OWNER_MOST, $this$apply.getMostSignificantBits());
        nbt.func_74772_a(TAG_OWNER_LEAST, $this$apply.getLeastSignificantBits());
    }

    protected void func_70037_a(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this.x = nbt.func_74762_e("toX");
        this.y = nbt.func_74762_e("toY");
        this.z = nbt.func_74762_e("toZ");
        this.ownerUUID = new UUID(nbt.func_74763_f(TAG_OWNER_MOST), nbt.func_74763_f(TAG_OWNER_LEAST));
    }

    public int func_82145_z() {
        return Integer.MAX_VALUE;
    }

    public EntityFracturedSpaceCollector(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.y = -1;
    }

    public EntityFracturedSpaceCollector(@NotNull World world, int toX, int toY, int toZ, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this(world);
        this.x = toX;
        this.y = toY;
        this.z = toZ;
        this.ownerUUID = player.func_110124_au();
    }

    static {
        Companion = new Companion(null);
        TOOL_STACK = new ItemStack(AlfheimItems.INSTANCE.getRodBlackHole());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fJ\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lalfheim/common/entity/EntityFracturedSpaceCollector$Companion;", "", "()V", "AGE_SPECIAL_START", "", "MANA_COST_PER_ITEM", "", "MAX_AGE", "PARTICLE_COUNT", "RADIUS", "", "TAG_OWNER_LEAST", "", "TAG_OWNER_MOST", "TOOL_STACK", "Lnet/minecraft/item/ItemStack;", "getTOOL_STACK", "()Lnet/minecraft/item/ItemStack;", "fakeCrateEject", "", "Lvazkii/botania/common/block/tile/TileOpenCrate;", "stack", "isPowered", "", "Alfheim"})
    public static final class Companion {
        @Nullable
        public final ItemStack getTOOL_STACK() {
            return TOOL_STACK;
        }

        public final boolean isPowered(@NotNull TileOpenCrate $this$isPowered) {
            Intrinsics.checkNotNullParameter((Object)$this$isPowered, (String)"$this$isPowered");
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int redstoneSide = $this$isPowered.func_145831_w().func_72878_l($this$isPowered.field_145851_c + dir.offsetX, $this$isPowered.field_145848_d + dir.offsetY, $this$isPowered.field_145849_e + dir.offsetZ, dir.ordinal());
                if (redstoneSide <= 0) continue;
                return true;
            }
            return false;
        }

        public final void fakeCrateEject(@NotNull TileOpenCrate $this$fakeCrateEject, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)$this$fakeCrateEject, (String)"$this$fakeCrateEject");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            EntityItem newEnt = new EntityItem($this$fakeCrateEject.func_145831_w(), (double)$this$fakeCrateEject.field_145851_c + 0.5, (double)$this$fakeCrateEject.field_145848_d - 0.5, (double)$this$fakeCrateEject.field_145849_e + 0.5, stack);
            newEnt.field_70159_w = 0.0;
            newEnt.field_70181_x = 0.0;
            newEnt.field_70179_y = 0.0;
            if (this.isPowered($this$fakeCrateEject)) {
                newEnt.field_70292_b = -200;
            }
            $this$fakeCrateEject.func_145831_w().func_72838_d((Entity)newEnt);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

