/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.entity;

import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.security.InteractionSecurity;
import alfheim.client.render.world.VisualEffectHandlerClient;
import alfheim.common.core.handler.VisualEffectHandler;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.ItemSplashPotion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.brew.ModPotions;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0014J\u0012\u0010#\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lalfheim/common/entity/EntityThrownPotion;", "Lnet/minecraft/entity/projectile/EntityThrowable;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "st", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)V", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;)V", "value", "", "color", "getColor", "()I", "setColor", "(I)V", "effects", "", "Lnet/minecraft/potion/PotionEffect;", "getEffects", "()Ljava/util/List;", "peClear", "getPeClear", "()Lnet/minecraft/potion/PotionEffect;", "stack", "getStack", "()Lnet/minecraft/item/ItemStack;", "entityInit", "", "func_70182_d", "", "func_70183_g", "getGravityVelocity", "onImpact", "movingObject", "Lnet/minecraft/util/MovingObjectPosition;", "Alfheim"})
public final class EntityThrownPotion
extends EntityThrowable {
    @NotNull
    private final List<PotionEffect> effects;
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final PotionEffect peClear;

    @NotNull
    public final List<PotionEffect> getEffects() {
        return this.effects;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final int getColor() {
        return this.field_70180_af.func_75679_c(31);
    }

    public final void setColor(int value) {
        this.field_70180_af.func_75692_b(31, (Object)value);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_82708_h(30);
        this.field_70180_af.func_75682_a(31, (Object)0);
        this.field_70180_af.func_82708_h(31);
    }

    @NotNull
    public final PotionEffect getPeClear() {
        return this.peClear;
    }

    protected void func_70184_a(@Nullable MovingObjectPosition movingObject) {
        if (!this.field_70170_p.field_72995_K && movingObject != null) {
            Collection collection = this.effects;
            boolean bl = false;
            if (!collection.isEmpty()) {
                AxisAlignedBB axisalignedbb = this.field_70121_D.func_72314_b(5.0, 2.5, 5.0);
                List list1 = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                if (list1 != null) {
                    Collection collection2 = list1;
                    boolean bl2 = false;
                    if (!collection2.isEmpty()) {
                        for (Object e : list1) {
                            if (e == null) {
                                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.EntityLivingBase");
                            }
                            EntityLivingBase living = (EntityLivingBase)e;
                            double d0 = this.func_70068_e((Entity)living);
                            if (!(d0 < 16.0)) continue;
                            boolean bl3 = false;
                            double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                            if (living == movingObject.field_72308_g) {
                                d1 = 1.0;
                            }
                            EntityLivingBase entityLivingBase = this.field_70192_c;
                            if (entityLivingBase == null) {
                                continue;
                            }
                            if (!InteractionSecurity.INSTANCE.canDoSomethingWithEntity(entityLivingBase, (Entity)living)) continue;
                            for (PotionEffect e2 : this.effects) {
                                Potion potion = Potion.field_76425_a[e2.field_76462_a];
                                Intrinsics.checkNotNullExpressionValue((Object)potion, (String)"Potion.potionTypes[e.potionID]");
                                if (potion.func_76403_b()) {
                                    Potion.field_76425_a[e2.field_76462_a].func_76402_a(this.field_70192_c, living, e2.field_76461_c, d1);
                                    continue;
                                }
                                int j = ExtensionsKt.getI((Number)(d1 * ExtensionsKt.getD((Number)e2.field_76460_b) + 0.5));
                                if (j <= 20) continue;
                                living.func_70690_d(new PotionEffect(e2.field_76462_a, j, e2.field_76461_c));
                            }
                        }
                    }
                }
                VisualEffectHandler.INSTANCE.sendPacket(VisualEffectHandlerClient.VisualEffects.POTION, this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, ExtensionsKt.getD((Number)this.getColor()), this.effects.contains(this.peClear) ? 1.0 : 0.0, 0.0);
            }
        }
        this.func_70106_y();
    }

    protected float func_70185_h() {
        return this.field_70180_af.func_111145_d(30);
    }

    public float func_70183_g() {
        return -10.0f;
    }

    public float func_70182_d() {
        return 1.0f;
    }

    public EntityThrownPotion(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(world);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = new ItemStack(AlfheimItems.INSTANCE.getSplashPotion());
        this.effects = CollectionsKt.emptyList();
        this.setColor(0xFFFFFF);
    }

    public EntityThrownPotion(@NotNull World world, @NotNull ItemStack st) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        super(world);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = st;
        Item item = this.stack.func_77973_b();
        if (item == null) {
            throw new NullPointerException("null cannot be cast to non-null type alfheim.common.item.ItemSplashPotion");
        }
        ItemSplashPotion brew = (ItemSplashPotion)item;
        List list = brew.getBrew(this.stack).getPotionEffects(this.stack);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"brew.getBrew(stack).getPotionEffects(stack)");
        this.effects = list;
        this.setColor(brew.getColor(this.stack));
    }

    public EntityThrownPotion(@NotNull EntityPlayer player, @NotNull ItemStack st) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        super(player.field_70170_p, (EntityLivingBase)player);
        this.peClear = new PotionEffect(ModPotions.clear.field_76415_H, 0, 0);
        this.stack = st;
        Item item = this.stack.func_77973_b();
        if (item == null) {
            throw new NullPointerException("null cannot be cast to non-null type alfheim.common.item.ItemSplashPotion");
        }
        ItemSplashPotion brew = (ItemSplashPotion)item;
        List list = brew.getBrew(this.stack).getPotionEffects(this.stack);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"brew.getBrew(stack).getPotionEffects(stack)");
        this.effects = list;
        this.setColor(brew.getColor(this.stack));
    }
}

