/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.minetweaker;

import alfheim.api.AlfheimAPI;
import alfheim.api.crafting.recipe.RecipeManaInfuser;
import alfheim.common.integration.minetweaker.MinetweakerAlfheimConfig;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.alfheim.ManaInfuser")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0010"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerManaInfuser;", "", "()V", "addRecipe", "", "output", "Lminetweaker/api/item/IItemStack;", "mana", "", "inputs", "", "Lminetweaker/api/item/IIngredient;", "(Lminetweaker/api/item/IItemStack;I[Lminetweaker/api/item/IIngredient;)V", "removeRecipe", "Add", "Remove", "Alfheim"})
public final class MTHandlerManaInfuser {
    @NotNull
    public static final MTHandlerManaInfuser INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void addRecipe(@NotNull IItemStack output, int mana, @NotNull IIngredient[] inputs) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Object[] objectArray = MinetweakerAlfheimConfig.INSTANCE.getObjects(inputs);
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeManaInfuser(mana, MinetweakerAlfheimConfig.INSTANCE.getStack(output), Arrays.copyOf(objectArray, objectArray.length))));
    }

    @ZenMethod
    @JvmStatic
    public static final void removeRecipe(@NotNull IItemStack output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MineTweakerAPI.apply((IUndoableAction)new Remove(MinetweakerAlfheimConfig.INSTANCE.getStack(output)));
    }

    private MTHandlerManaInfuser() {
    }

    static {
        MTHandlerManaInfuser mTHandlerManaInfuser;
        INSTANCE = mTHandlerManaInfuser = new MTHandlerManaInfuser();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerManaInfuser$Add;", "Lminetweaker/IUndoableAction;", "recipe", "Lalfheim/api/crafting/recipe/RecipeManaInfuser;", "(Lalfheim/api/crafting/recipe/RecipeManaInfuser;)V", "apply", "", "canUndo", "", "describe", "", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Add
    implements IUndoableAction {
        private final RecipeManaInfuser recipe;

        public void apply() {
            AlfheimAPI.INSTANCE.addInfuserRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            AlfheimAPI.INSTANCE.removeInfusionRecipe(this.recipe);
        }

        @NotNull
        public String describe() {
            return "Adding Mana Infuser recipe " + (Object)((Object)this.recipe);
        }

        @NotNull
        public String describeUndo() {
            return "Removing Mana Infuser recipe " + (Object)((Object)this.recipe);
        }

        @Nullable
        public Object getOverrideKey() {
            return null;
        }

        public Add(@NotNull RecipeManaInfuser recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            this.recipe = recipe;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerManaInfuser$Remove;", "Lminetweaker/IUndoableAction;", "output", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "removed", "Ljava/util/ArrayList;", "Lalfheim/api/crafting/recipe/RecipeManaInfuser;", "getRemoved", "()Ljava/util/ArrayList;", "apply", "", "canUndo", "", "describe", "", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Remove
    implements IUndoableAction {
        @NotNull
        private final ArrayList<RecipeManaInfuser> removed;
        private final ItemStack output;

        @NotNull
        public final ArrayList<RecipeManaInfuser> getRemoved() {
            return this.removed;
        }

        public void apply() {
            RecipeManaInfuser rec = AlfheimAPI.INSTANCE.removeInfusionRecipe(this.output);
            while (rec != null) {
                this.removed.add(rec);
                rec = AlfheimAPI.INSTANCE.removeInfusionRecipe(this.output);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (RecipeManaInfuser rec : this.removed) {
                AlfheimAPI.INSTANCE.addInfuserRecipe(rec);
            }
        }

        @NotNull
        public String describe() {
            return "Removing all Mana Infuser recipes for " + this.output.func_77977_a();
        }

        @NotNull
        public String describeUndo() {
            return "Re-adding previously removed Mana Infuser recipes for " + this.output.func_77977_a();
        }

        @Nullable
        public Object getOverrideKey() {
            return null;
        }

        public Remove(@NotNull ItemStack output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.output = output;
            this.removed = new ArrayList();
        }
    }
}

