/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.minetweaker;

import alfheim.api.AlfheimAPI;
import alfheim.api.spell.SpellBase;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.alfheim.Spells")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0007J0\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a8\u0006\u0018"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells;", "", "()V", "setCastTime", "", "name", "", "time", "", "setCooldown", "cd", "setManaCost", "mana", "setParams", "damage", "", "duration", "efficiency", "", "radius", "CastTime", "Cooldown", "ManaCost", "Params", "Alfheim"})
public final class MTHandlerSpells {
    @NotNull
    public static final MTHandlerSpells INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void setManaCost(@NotNull String name, int mana) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (mana < 0) {
            throw (Throwable)new IllegalArgumentException("Manacost for " + name + " must not be negative");
        }
        MineTweakerAPI.apply((IUndoableAction)new ManaCost(name, mana));
    }

    @ZenMethod
    @JvmStatic
    public static final void setCooldown(@NotNull String name, int cd) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (cd < 0) {
            throw (Throwable)new IllegalArgumentException("Cooldown for " + name + " must not be negative");
        }
        MineTweakerAPI.apply((IUndoableAction)new Cooldown(name, cd));
    }

    @ZenMethod
    @JvmStatic
    public static final void setCastTime(@NotNull String name, int time) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (time < 0) {
            throw (Throwable)new IllegalArgumentException("Cast time for " + name + " must not be negative");
        }
        MineTweakerAPI.apply((IUndoableAction)new CastTime(name, time));
    }

    @ZenMethod
    @JvmStatic
    public static final void setParams(@NotNull String name, float damage, int duration, double efficiency, double radius) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (damage < 0.0f || duration < 0 || efficiency < 0.0 || radius < 0.0) {
            throw (Throwable)new IllegalArgumentException("Params for " + name + " must not be negative");
        }
        MineTweakerAPI.apply((IUndoableAction)new Params(name, damage, duration, efficiency, radius));
    }

    private MTHandlerSpells() {
    }

    static {
        MTHandlerSpells mTHandlerSpells;
        INSTANCE = mTHandlerSpells = new MTHandlerSpells();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$ManaCost;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "(Ljava/lang/String;I)V", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "setSpell", "(Lalfheim/api/spell/SpellBase;)V", "apply", "", "canUndo", "", "describe", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class ManaCost
    implements IUndoableAction {
        @NotNull
        private SpellBase spell;
        private int oldVal;
        private final int newVal;

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final void setSpell(@NotNull SpellBase spellBase) {
            Intrinsics.checkNotNullParameter((Object)spellBase, (String)"<set-?>");
            this.spell = spellBase;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setManaCost(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setManaCost(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting manacost to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting manacost for " + this.spell.getName() + " to old value (" + this.oldVal + ')';
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }

        public ManaCost(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$Cooldown;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "(Ljava/lang/String;I)V", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "apply", "", "canUndo", "", "describe", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Cooldown
    implements IUndoableAction {
        @NotNull
        private final SpellBase spell;
        private int oldVal;
        private final int newVal;

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setCooldown(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setCooldown(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting cooldown to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting cooldown for " + this.spell.getName() + " to old value (oldVal)";
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }

        public Cooldown(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$CastTime;", "Lminetweaker/IUndoableAction;", "name", "", "newVal", "", "(Ljava/lang/String;I)V", "oldVal", "getOldVal", "()I", "setOldVal", "(I)V", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "apply", "", "canUndo", "", "describe", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class CastTime
    implements IUndoableAction {
        @NotNull
        private final SpellBase spell;
        private int oldVal;
        private final int newVal;

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        public final int getOldVal() {
            return this.oldVal;
        }

        public final void setOldVal(int n) {
            this.oldVal = n;
        }

        public void apply() {
            this.oldVal = this.spell.setCastTime(this.newVal);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.spell.setCastTime(this.oldVal);
        }

        @NotNull
        public String describe() {
            return "Setting cast time to " + this.newVal + " for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            return "Resetting cast time for " + this.spell.getName() + " to old value (" + this.oldVal + ')';
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }

        public CastTime(@NotNull String name, int newVal) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.newVal = newVal;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSpells$Params;", "Lminetweaker/IUndoableAction;", "name", "", "damage", "", "duration", "", "efficiency", "", "radius", "(Ljava/lang/String;FIDD)V", "oldVals", "", "", "getOldVals", "()[Ljava/lang/Object;", "setOldVals", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "spell", "Lalfheim/api/spell/SpellBase;", "getSpell", "()Lalfheim/api/spell/SpellBase;", "apply", "", "canUndo", "", "describe", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Params
    implements IUndoableAction {
        @NotNull
        private final SpellBase spell;
        @NotNull
        private Object[] oldVals;
        private final float damage;
        private final int duration;
        private final double efficiency;
        private final double radius;

        @NotNull
        public final SpellBase getSpell() {
            return this.spell;
        }

        @NotNull
        public final Object[] getOldVals() {
            return this.oldVals;
        }

        public final void setOldVals(@NotNull Object[] objectArray) {
            Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
            this.oldVals = objectArray;
        }

        public void apply() {
            this.oldVals = new Object[]{Float.valueOf(this.spell.getDamage()), this.spell.getDuration(), this.spell.getEfficiency(), this.spell.getRadius()};
            this.spell.setDamage(this.damage);
            this.spell.setDuration(this.duration);
            this.spell.setEfficiency(this.efficiency);
            this.spell.setRadius(this.radius);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Object object = this.oldVals[0];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            this.spell.setDamage(((Float)object).floatValue());
            Object object2 = this.oldVals[1];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            this.spell.setDuration((Integer)object2);
            Object object3 = this.oldVals[2];
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            this.spell.setEfficiency((Double)object3);
            Object object4 = this.oldVals[3];
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            this.spell.setRadius((Double)object4);
        }

        @NotNull
        public String describe() {
            return "Setting damage [" + this.damage + "], duration [" + this.duration + "], efficiency [" + this.efficiency + "], radius [" + this.radius + "] for " + this.spell.getName();
        }

        @NotNull
        public String describeUndo() {
            StringBuilder stringBuilder = new StringBuilder().append("Resetting damage, duration, efficiency, radius for ").append(this.spell.getName()).append(" to old values (");
            Object[] objectArray = this.oldVals;
            boolean bl = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            return stringBuilder.append(string).append(')').toString();
        }

        @Nullable
        public Void getOverrideKey() {
            return null;
        }

        public Params(@NotNull String name, float damage, int duration, double efficiency, double radius) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.damage = damage;
            this.duration = duration;
            this.efficiency = efficiency;
            this.radius = radius;
            SpellBase spellBase = AlfheimAPI.INSTANCE.getSpellInstance(name);
            Intrinsics.checkNotNull((Object)spellBase);
            this.spell = spellBase;
            this.oldVals = new Object[]{Float.valueOf(0.0f), 0, 0.0, 0.0};
        }
    }
}

