/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.minetweaker;

import alfheim.api.AlfheimAPI;
import alfheim.api.crafting.recipe.RecipeTreeCrafting;
import alfheim.common.integration.minetweaker.MinetweakerAlfheimConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.alfheim.Suffuser")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0012"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSuffuser;", "", "()V", "addRecipe", "", "output", "Lminetweaker/api/item/IItemStack;", "inner", "mana", "", "speed", "inputs", "", "Lminetweaker/api/item/IIngredient;", "(Lminetweaker/api/item/IItemStack;Lminetweaker/api/item/IItemStack;II[Lminetweaker/api/item/IIngredient;)V", "removeRecipe", "Add", "Remove", "Alfheim"})
public final class MTHandlerSuffuser {
    @NotNull
    public static final MTHandlerSuffuser INSTANCE;

    @ZenMethod
    @JvmStatic
    public static final void addRecipe(@NotNull IItemStack output, @NotNull IItemStack inner, int mana, int speed, @NotNull IIngredient[] inputs) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        ItemStack out = MinetweakerAlfheimConfig.INSTANCE.getStack(output);
        ItemStack core = MinetweakerAlfheimConfig.INSTANCE.getStack(inner);
        Object[] objectArray = MinetweakerAlfheimConfig.INSTANCE.getObjects(inputs);
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeTreeCrafting(mana, out, core, speed, Arrays.copyOf(objectArray, objectArray.length))));
    }

    @ZenMethod
    @JvmStatic
    public static final void removeRecipe(@NotNull IItemStack output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        MineTweakerAPI.apply((IUndoableAction)new Remove(MinetweakerAlfheimConfig.INSTANCE.getStack(output)));
    }

    private MTHandlerSuffuser() {
    }

    static {
        MTHandlerSuffuser mTHandlerSuffuser;
        INSTANCE = mTHandlerSuffuser = new MTHandlerSuffuser();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSuffuser$Add;", "Lminetweaker/IUndoableAction;", "recipe", "Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "(Lalfheim/api/crafting/recipe/RecipeTreeCrafting;)V", "apply", "", "canUndo", "", "describe", "", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Add
    implements IUndoableAction {
        private final RecipeTreeCrafting recipe;

        public void apply() {
            AlfheimAPI.INSTANCE.addTreeRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            ItemStack itemStack = this.recipe.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"recipe.output");
            AlfheimAPI.INSTANCE.removeTreeRecipe(itemStack);
        }

        @NotNull
        public String describe() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Adding Tree Suffusion recipe %s";
            Object[] objectArray = new Object[]{this.recipe};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @NotNull
        public String describeUndo() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Removing Tree Suffusion recipe %s";
            Object[] objectArray = new Object[]{this.recipe};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @Nullable
        public Object getOverrideKey() {
            return null;
        }

        public Add(@NotNull RecipeTreeCrafting recipe) {
            Intrinsics.checkNotNullParameter((Object)((Object)recipe), (String)"recipe");
            this.recipe = recipe;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lalfheim/common/integration/minetweaker/MTHandlerSuffuser$Remove;", "Lminetweaker/IUndoableAction;", "output", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "removed", "Ljava/util/ArrayList;", "Lalfheim/api/crafting/recipe/RecipeTreeCrafting;", "getRemoved", "()Ljava/util/ArrayList;", "apply", "", "canUndo", "", "describe", "", "describeUndo", "getOverrideKey", "", "undo", "Alfheim"})
    private static final class Remove
    implements IUndoableAction {
        @NotNull
        private final ArrayList<RecipeTreeCrafting> removed;
        private final ItemStack output;

        @NotNull
        public final ArrayList<RecipeTreeCrafting> getRemoved() {
            return this.removed;
        }

        public void apply() {
            RecipeTreeCrafting rec = AlfheimAPI.INSTANCE.removeTreeRecipe(this.output);
            while (rec != null) {
                this.removed.add(rec);
                rec = AlfheimAPI.INSTANCE.removeTreeRecipe(this.output);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Iterator<RecipeTreeCrafting> iterator = this.removed.iterator();
            while (iterator.hasNext()) {
                RecipeTreeCrafting rec;
                RecipeTreeCrafting recipeTreeCrafting = rec = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)recipeTreeCrafting), (String)"rec");
                AlfheimAPI.INSTANCE.addTreeRecipe(recipeTreeCrafting);
            }
        }

        @NotNull
        public String describe() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Removing all Tree Suffusion recipes for %s";
            Object[] objectArray = new Object[]{this.output.func_77977_a()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @NotNull
        public String describeUndo() {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Re-adding previously removed Tree Suffusion recipes for %s";
            Object[] objectArray = new Object[]{this.output.func_77977_a()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        @Nullable
        public Object getOverrideKey() {
            return null;
        }

        public Remove(@NotNull ItemStack output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.output = output;
            this.removed = new ArrayList();
        }
    }
}

