/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.integration.tinkersconstruct.modifier;

import alfheim.common.integration.tinkersconstruct.TinkersConstructAlfheimModule;
import alfheim.common.integration.tinkersconstruct.modifier.ModManaRepair;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.IAmmo;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J*\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lalfheim/common/integration/tinkersconstruct/modifier/AModNatural;", "Ltconstruct/library/ActiveToolMod;", "()V", "damageTool", "", "stack", "Lnet/minecraft/item/ItemStack;", "damage", "", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "generareMana", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getRepairCost", "repair", "updateTool", "tool", "Ltconstruct/library/tools/ToolCore;", "world", "Lnet/minecraft/world/World;", "Lnet/minecraft/entity/Entity;", "Alfheim"})
public final class AModNatural
extends ActiveToolMod {
    @NotNull
    public static final AModNatural INSTANCE;

    public void updateTool(@NotNull ToolCore tool, @NotNull ItemStack stack, @NotNull World world, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Entity entity2 = entity;
        if (!(entity2 instanceof EntityPlayer)) {
            entity2 = null;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entity2;
        if (entityPlayer == null) {
            return;
        }
        EntityPlayer player = entityPlayer;
        if (tool instanceof IAmmo) {
            return;
        }
        NBTTagCompound nBTTagCompound = ItemNBTHelper.getCompound((ItemStack)stack, (String)tool.getBaseTagName(), (boolean)true);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagCompound tag = nBTTagCompound;
        this.repair(stack, tag, player);
        this.generareMana(stack, tag, player);
    }

    public final void repair(@NotNull ItemStack stack, @NotNull NBTTagCompound tag, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int damage = tag.func_74762_e("Damage");
        if (damage <= 0) {
            return;
        }
        int cost = this.getRepairCost(tag) * 2;
        if (cost > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)cost, (boolean)true)) {
            AbilityHelper.healTool((ItemStack)stack, (int)1, (EntityLivingBase)((EntityLivingBase)player), (boolean)true);
        }
    }

    public final void generareMana(@NotNull ItemStack stack, @NotNull NBTTagCompound tag, @NotNull EntityPlayer player) {
        int addDelay;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int headMaterial = tag.func_74762_e("Head");
        int n = addDelay = stack == player.func_71045_bC() ? 1 : 10;
        if (ArraysKt.contains((int[])TinkersConstructAlfheimModule.INSTANCE.getManaGenMaterials(), (int)headMaterial)) {
            int n2 = player.field_70173_aa;
            Integer n3 = TinkersConstructAlfheimModule.INSTANCE.getManaGenDelay().get(headMaterial);
            if (n3 == null) {
                n3 = 20;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"TinkersConstructAlfheimM\u2026Delay[headMaterial] ?: 20");
            if (n2 % n3 * addDelay == 0) {
                ManaItemHandler.dispatchManaExact((ItemStack)stack, (EntityPlayer)player, (int)1, (boolean)true);
            }
        }
    }

    public boolean damageTool(@NotNull ItemStack stack, int damage, @Nullable EntityLivingBase entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (damage <= 0) {
            return false;
        }
        EntityLivingBase entityLivingBase = entity;
        if (!(entityLivingBase instanceof EntityPlayer)) {
            entityLivingBase = null;
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
        if (entityPlayer == null) {
            return false;
        }
        EntityPlayer player = entityPlayer;
        Item item = stack.func_77973_b();
        if (!(item instanceof IModifyable)) {
            item = null;
        }
        IModifyable iModifyable = (IModifyable)item;
        if (iModifyable == null) {
            return false;
        }
        IModifyable item2 = iModifyable;
        Object[] objectArray = item2.getTraits();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"item.traits");
        if (ArraysKt.contains((Object[])objectArray, (Object)"ammo")) {
            return false;
        }
        NBTTagCompound nBTTagCompound = ItemNBTHelper.getCompound((ItemStack)stack, (String)item2.getBaseTagName(), (boolean)true);
        if (nBTTagCompound == null) {
            return false;
        }
        NBTTagCompound tag = nBTTagCompound;
        int mana = this.getRepairCost(tag);
        if (mana == 0) {
            return false;
        }
        return ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)mana, (boolean)true);
    }

    public final int getRepairCost(@NotNull NBTTagCompound tag) {
        int n;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int headMaterial = tag.func_74762_e("Head");
        if (ArraysKt.contains((int[])TinkersConstructAlfheimModule.INSTANCE.getManaRepairMaterials(), (int)headMaterial)) {
            Integer n2 = TinkersConstructAlfheimModule.INSTANCE.getManaRepairCost().get(headMaterial);
            if (n2 == null) {
                n2 = 10;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"TinkersConstructAlfheimM\u2026rCost[headMaterial] ?: 10");
            n = n2;
        } else {
            n = tag.func_74767_n(ModManaRepair.INSTANCE.key) ? 5 : 0;
        }
        return n;
    }

    private AModNatural() {
    }

    static {
        AModNatural aModNatural;
        INSTANCE = aModNatural = new AModNatural();
    }
}

