/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.item.relic;

import alexsocol.asjlib.ExtensionsClientKt;
import alexsocol.asjlib.render.ASJRenderHelper;
import alfheim.api.item.relic.record.AkashicRecord;
import alfheim.api.lib.LibResourceLocations;
import alfheim.common.item.AlfheimItems;
import alfheim.common.item.relic.AkashikModels;
import alfheim.common.item.relic.ItemFlugelSoul;
import alfheim.common.item.relic.record.AkashicRecordNewChance;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.relic.ItemRelic;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J2\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\rH\u0016J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lalfheim/common/item/relic/ItemAkashicRecords;", "Lvazkii/botania/common/item/relic/ItemRelic;", "()V", "getMaxItemUseDuration", "", "stack", "Lnet/minecraft/item/ItemStack;", "onEaten", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onEntitySwing", "", "living", "Lnet/minecraft/entity/EntityLivingBase;", "onItemRightClick", "onPlayerStoppedUsing", "", "left", "onUpdate", "entity", "Lnet/minecraft/entity/Entity;", "slot", "inHand", "onUsingTick", "registerIcons", "reg", "Lnet/minecraft/client/renderer/texture/IIconRegister;", "Companion", "Alfheim"})
public final class ItemAkashicRecords
extends ItemRelic {
    @NotNull
    public static final String TAG_ROTATION = "rotation";
    @NotNull
    public static final String TAG_FRAME = "frame";
    @NotNull
    public static final String TAG_MULT = "mult";
    @NotNull
    public static final String TAG_SWITCH = "switch";
    public static final int MANA_PER_RECORD = 1000000;
    public static final int MAX_RECORDS = 20;
    @NotNull
    public static final String TAG_RECORD_PREF = "record_";
    @NotNull
    public static final String TAG_RECORD_COUNT = "records";
    @NotNull
    public static final String TAG_RECORD_SELECT = "record";
    @NotNull
    private static final HashMap<String, AkashicRecord> records;
    @NotNull
    private static final HashMap<String, ResourceLocation> recordTextures;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ItemStack func_77659_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public void onUsingTick(@NotNull ItemStack stack, @NotNull EntityPlayer player, int left) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 1200;
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World world, @NotNull EntityPlayer player, int left) {
        block0: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (left <= this.func_77626_a(stack) - 20) break block0;
                if (!player.func_70093_af()) break block1;
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_SWITCH, (boolean)true);
                break block0;
            }
            if (!Companion.isOpen(stack)) break block0;
            Companion.nextRecord(player, stack);
        }
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @Nullable World world, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Companion.isOpen(stack)) {
            Companion.generateRecord(player, stack);
        }
        player.func_71041_bz();
        return stack;
    }

    public void func_77663_a(@NotNull ItemStack stack, @Nullable World world, @NotNull Entity entity, int slot, boolean inHand) {
        int frame;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.func_77663_a(stack, world, entity, slot, inHand);
        if (!inHand) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MULT, (int)-1);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_FRAME, (int)0);
            return;
        }
        if (!entity.func_70093_af()) {
            ItemNBTHelper.setFloat((ItemStack)stack, (String)TAG_ROTATION, (float)ItemFlugelSoul.Companion.getCheckingAngle(entity));
        }
        if ((frame = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_FRAME, (int)0) + ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MULT, (int)-1)) == 160) {
            frame = 60;
        }
        if ((frame % 100 == 60 || frame == -1) && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_SWITCH, (boolean)false)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MULT, (int)(ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MULT, (int)-1) * -1));
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_SWITCH, (boolean)false);
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_FRAME, (int)(frame != -1 ? 60 : 1));
        } else {
            int n = 0;
            boolean bl = false;
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_FRAME, (int)Math.max(n, frame));
        }
    }

    public boolean onEntitySwing(@NotNull EntityLivingBase living, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)living, (String)"living");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (living instanceof EntityPlayer && Companion.isOpen(stack)) {
            Companion.cast((EntityPlayer)living, stack);
        }
        return true;
    }

    public void func_94581_a(@NotNull IIconRegister reg) {
        Intrinsics.checkNotNullParameter((Object)reg, (String)"reg");
    }

    public ItemAkashicRecords() {
        super("AkashicRecords");
    }

    static {
        Companion = new Companion(null);
        records = new HashMap();
        recordTextures = new HashMap();
        MinecraftForge.EVENT_BUS.register((Object)Companion);
        Companion.registerRecord(AkashicRecordNewChance.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010#\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010#\u001a\u00020(H\u0007J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0015J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u000fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006,"}, d2={"Lalfheim/common/item/relic/ItemAkashicRecords$Companion;", "", "()V", "MANA_PER_RECORD", "", "MAX_RECORDS", "TAG_FRAME", "", "TAG_MULT", "TAG_RECORD_COUNT", "TAG_RECORD_PREF", "TAG_RECORD_SELECT", "TAG_ROTATION", "TAG_SWITCH", "recordTextures", "Ljava/util/HashMap;", "Lnet/minecraft/util/ResourceLocation;", "Lkotlin/collections/HashMap;", "getRecordTextures", "()Ljava/util/HashMap;", "records", "Lalfheim/api/item/relic/record/AkashicRecord;", "getRecords", "cast", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "stack", "Lnet/minecraft/item/ItemStack;", "generateRecord", "generateRecordActual", "", "isOpen", "nextRecord", "onDropped", "e", "Lnet/minecraftforge/event/entity/item/ItemTossEvent;", "onPickup", "Lcpw/mods/fml/common/gameevent/PlayerEvent$ItemPickupEvent;", "onRenderWorldLast", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "registerRecord", "rec", "render", "Alfheim"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, AkashicRecord> getRecords() {
            return records;
        }

        @NotNull
        public final HashMap<String, ResourceLocation> getRecordTextures() {
            return recordTextures;
        }

        public final boolean isOpen(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_FRAME, (int)0) > 60 && ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_MULT, (int)-1) == 1 && !ItemNBTHelper.getBoolean((ItemStack)stack, (String)ItemAkashicRecords.TAG_SWITCH, (boolean)false);
        }

        public final void generateRecord(@NotNull EntityPlayer player, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.generateRecordActual(player, stack);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean generateRecordActual(@NotNull EntityPlayer player, @NotNull ItemStack stack) {
            int n;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (this.getRecords().isEmpty()) {
                return false;
            }
            int contains = ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_COUNT, (int)0);
            if (contains == 20) {
                return false;
            }
            if (contains > 20) {
                throw (Throwable)new IllegalArgumentException("Records count in Akashik Records cannot be greater than 20. Holder: " + player.func_70005_c_());
            }
            Collection<AkashicRecord> collection = this.getRecords().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"records.values");
            Collection<AkashicRecord> collection2 = collection;
            int n2 = 0;
            AkashicRecord record = (AkashicRecord)CollectionsKt.random(collection2, (Random)((Random)Random.Default));
            int tries = 32;
            while (tries-- > 0 && !record.canGet(player, stack)) {
                Collection<AkashicRecord> collection3;
                Intrinsics.checkNotNullExpressionValue(this.getRecords().values(), (String)"records.values");
                n = 0;
                record = (AkashicRecord)CollectionsKt.random(collection3, (Random)((Random)Random.Default));
            }
            if (tries < 0) {
                return false;
            }
            if (!ManaItemHandler.requestManaExact((ItemStack)stack, (EntityPlayer)player, (int)1000000, (boolean)true)) {
                return false;
            }
            ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_COUNT, (int)(contains + 1));
            n2 = 0;
            n = 20;
            while (n2 < n) {
                void i;
                if (!ItemNBTHelper.verifyExistance((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + (int)i))) {
                    ItemNBTHelper.setString((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + (int)i), (String)record.getName());
                    break;
                }
                ++i;
            }
            return true;
        }

        public final void nextRecord(@NotNull EntityPlayer player, @NotNull ItemStack stack) {
            int startedAt;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            int contains = ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_COUNT, (int)0);
            if (contains <= 0) {
                return;
            }
            if (contains > 20) {
                throw (Throwable)new IllegalArgumentException("Records count in Akashik Records cannot be greater than 20. Holder: " + player.func_70005_c_());
            }
            int cycle = startedAt = ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_SELECT, (int)0);
            do {
                cycle = (cycle + 1) % 20;
            } while (!ItemNBTHelper.verifyExistance((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + cycle)) && cycle != startedAt);
            ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_SELECT, (int)cycle);
        }

        public final void cast(@NotNull EntityPlayer player, @NotNull ItemStack stack) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                AkashicRecord akashicRecord = this.getRecords().get(ItemNBTHelper.getString((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_SELECT, (int)0)), (String)""));
                if (akashicRecord == null) break block1;
                AkashicRecord akashicRecord2 = akashicRecord;
                boolean bl = false;
                boolean bl2 = false;
                AkashicRecord it = akashicRecord2;
                boolean bl3 = false;
                if (it.apply(player, stack)) {
                    stack.func_77978_p().field_74784_a.remove(ItemAkashicRecords.TAG_RECORD_PREF + ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_SELECT, (int)0));
                    ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_COUNT, (int)(ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_COUNT, (int)0) - 1));
                    Companion.nextRecord(player, stack);
                }
            }
        }

        public final void registerRecord(@NotNull AkashicRecord rec) {
            Intrinsics.checkNotNullParameter((Object)rec, (String)"rec");
            ((Map)this.getRecords()).put(rec.getName(), rec);
            ((Map)this.getRecordTextures()).put(rec.getName(), new ResourceLocation("alfheim", "textures/model/item/record/" + rec.getName() + ".png"));
        }

        @SubscribeEvent
        public final void onDropped(@NotNull ItemTossEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityItem entityItem = e.entityItem;
            if (entityItem == null || (entityItem = entityItem.func_92059_d()) == null) {
                return;
            }
            EntityItem stack = entityItem;
            if (stack.func_77973_b() == AlfheimItems.INSTANCE.getAkashicRecords()) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_MULT, (int)-1);
                ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_FRAME, (int)0);
            }
        }

        @SubscribeEvent
        public final void onPickup(@NotNull PlayerEvent.ItemPickupEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityItem entityItem = e.pickedUp;
            if (entityItem == null || (entityItem = entityItem.func_92059_d()) == null) {
                return;
            }
            EntityItem stack = entityItem;
            if (stack.func_77973_b() == AlfheimItems.INSTANCE.getAkashicRecords()) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_MULT, (int)-1);
                ItemNBTHelper.setInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_FRAME, (int)0);
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public final void onRenderWorldLast(@NotNull RenderWorldLastEvent e) {
            EntityClientPlayerMP player;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            EntityClientPlayerMP entityClientPlayerMP = player = ExtensionsClientKt.getMc().field_71439_g;
            Intrinsics.checkNotNullExpressionValue((Object)entityClientPlayerMP, (String)"player");
            ItemStack stack = entityClientPlayerMP.func_71045_bC();
            if (stack != null && stack.func_77973_b() == AlfheimItems.INSTANCE.getAkashicRecords()) {
                this.render(stack, (EntityPlayer)player);
            }
        }

        /*
         * WARNING - void declaration
         */
        @SideOnly(value=Side.CLIENT)
        public final void render(@NotNull ItemStack stack, @NotNull EntityPlayer player) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int frame = ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_FRAME, (int)0);
            if (frame <= 0) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            ASJRenderHelper.interpolatedTranslation((Entity)((Entity)player));
            GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
            GL11.glRotatef((float)(ItemNBTHelper.getFloat((ItemStack)stack, (String)ItemAkashicRecords.TAG_ROTATION, (float)0.0f) + 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            int num = 0;
            RenderHelper.func_74519_b();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            boolean bl = false;
            boolean bl2 = true;
            while (bl <= bl2) {
                void i;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)frame / 60.0f));
                GL11.glPushMatrix();
                GL11.glRotatef((float)(60.0f * (float)(i - true)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ExtensionsClientKt.getMc().field_71446_o.func_110577_a(LibResourceLocations.INSTANCE.getAkashicBox());
                AkashikModels.INSTANCE.getBoxModel().render(0.0625f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.5, (double)0.0, (double)0.5);
                int n = 0;
                int n2 = 7;
                while (n < n2) {
                    void b;
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.125f);
                    if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + num++))) {
                        if (this.getRecordTextures().get(ItemNBTHelper.getString((ItemStack)stack, (String)(ItemAkashicRecords.TAG_RECORD_PREF + (num - 1)), (String)"")) != null) {
                            ResourceLocation resourceLocation;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            ResourceLocation it = resourceLocation;
                            boolean bl5 = false;
                            ExtensionsClientKt.getMc().field_71446_o.func_110577_a(it);
                        }
                        AkashikModels.INSTANCE.getBookModel().func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                        if (ItemNBTHelper.getInt((ItemStack)stack, (String)ItemAkashicRecords.TAG_RECORD_SELECT, (int)0) == num - 1) {
                            GL11.glDisable((int)3553);
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)((float)frame / 60.0f));
                            GL11.glLineWidth((float)3.0f);
                            GL11.glPolygonMode((int)1032, (int)6913);
                            AkashikModels.INSTANCE.getBookModel().func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                            GL11.glPolygonMode((int)1032, (int)6914);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)frame / 60.0f));
                            GL11.glEnable((int)3553);
                        }
                    }
                    ++b;
                }
                GL11.glPopMatrix();
                ++i;
            }
            GL11.glAlphaFunc((int)516, (float)0.1f);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

