/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.spell.darkness;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.math.Vector3;
import alexsocol.asjlib.security.InteractionSecurity;
import alfheim.api.entity.EnumRace;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.CardinalSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lalfheim/common/spell/darkness/SpellCall;", "Lalfheim/api/spell/SpellBase;", "()V", "usableParams", "", "", "getUsableParams", "()[Ljava/lang/Object;", "performCast", "Lalfheim/api/spell/SpellBase$SpellCastResult;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
public final class SpellCall
extends SpellBase {
    @NotNull
    public static final SpellCall INSTANCE;

    @Override
    @NotNull
    public Object[] getUsableParams() {
        return new Object[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpellBase.SpellCastResult performCast(@NotNull EntityLivingBase caster) {
        void cy;
        void cx;
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        if (!(caster instanceof EntityPlayer)) {
            return SpellBase.SpellCastResult.NOTARGET;
        }
        CardinalSystem.TargetingSystem.Target tg = CardinalSystem.TargetingSystem.INSTANCE.getTarget((EntityPlayer)caster);
        EntityLivingBase tgt = null;
        if (tg.isParty()) {
            CardinalSystem.PartySystem.Party party = CardinalSystem.PartySystem.INSTANCE.getMobParty(caster);
            if (party == null) {
                return SpellBase.SpellCastResult.NOTARGET;
            }
            CardinalSystem.PartySystem.Party pt = party;
            EntityLivingBase entityLivingBase = pt.get(tg.getPartyIndex());
            if (entityLivingBase == null) {
                return SpellBase.SpellCastResult.WRONGTGT;
            }
            tgt = entityLivingBase;
        } else {
            EntityLivingBase entityLivingBase = tg.getTarget();
            if (entityLivingBase == null) {
                return SpellBase.SpellCastResult.NOTARGET;
            }
            tgt = entityLivingBase;
            if (ASJUtilities.isNotInFieldOfVision((EntityLivingBase)tgt, (EntityLivingBase)caster)) {
                return SpellBase.SpellCastResult.NOTSEEING;
            }
            if (!InteractionSecurity.INSTANCE.canDoSomethingWithEntity(caster, (Entity)tgt)) {
                return SpellBase.SpellCastResult.NOTALLOW;
            }
        }
        if (tgt == caster) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        if (!(tgt instanceof EntityPlayer) && tgt.field_71093_bK != caster.field_71093_bK) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        Vector3 vector3 = Vector3.Companion.fromEntity((Entity)caster);
        double pt = vector3.component1();
        double d = vector3.component2();
        double cz = vector3.component3();
        if (!InteractionSecurity.INSTANCE.canDoSomethingHere(caster)) {
            return SpellBase.SpellCastResult.NOTALLOW;
        }
        World world = caster.field_70170_p;
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"caster.worldObj");
        if (!InteractionSecurity.INSTANCE.canDoSomethingHere(tgt, (double)cx, (double)cy, cz, world)) {
            return SpellBase.SpellCastResult.NOTALLOW;
        }
        SpellBase.SpellCastResult result = this.checkCast(caster);
        if (result == SpellBase.SpellCastResult.OK) {
            if (tgt instanceof EntityPlayer) {
                ASJUtilities.sendToDimensionWithoutPortal((EntityPlayer)((EntityPlayer)tgt), (int)caster.field_71093_bK, (double)cx, (double)cy, (double)cz);
            } else {
                float cry = caster.field_70177_z;
                float crp = caster.field_70125_A;
                tgt.func_70012_b((double)cx, (double)cy, cz, cry, crp);
                tgt.func_70080_a((double)cx, (double)cy, cz, cry, crp);
                tgt.func_70634_a((double)cx, (double)cy, cz);
            }
        }
        return result;
    }

    private SpellCall() {
        super("call", EnumRace.IMP, 10000, 1800, 30, false, 32, null);
    }

    static {
        SpellCall spellCall;
        INSTANCE = spellCall = new SpellCall();
    }
}

