/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.spell.fire;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.security.InteractionSecurity;
import alfheim.api.entity.EnumRace;
import alfheim.api.entity.EnumRaceKt;
import alfheim.api.event.SpellCastEvent;
import alfheim.api.spell.SpellBase;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.core.handler.CardinalSystem;
import alfheim.common.spell.fire.SpellDispel;
import cpw.mods.fml.common.eventhandler.Event;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lalfheim/common/spell/fire/SpellIgnition;", "Lalfheim/api/spell/SpellBase;", "()V", "efficiency", "", "getEfficiency", "()D", "setEfficiency", "(D)V", "usableParams", "", "", "getUsableParams", "()[Ljava/lang/Object;", "performCast", "Lalfheim/api/spell/SpellBase$SpellCastResult;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "Alfheim"})
public final class SpellIgnition
extends SpellBase {
    private static double efficiency;
    @NotNull
    public static final SpellIgnition INSTANCE;

    @Override
    public double getEfficiency() {
        return efficiency;
    }

    @Override
    public void setEfficiency(double d) {
        efficiency = d;
    }

    @Override
    @NotNull
    public Object[] getUsableParams() {
        return new Object[]{this.getEfficiency(), this.getRadius()};
    }

    @Override
    @NotNull
    public SpellBase.SpellCastResult performCast(@NotNull EntityLivingBase caster) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        if (!(caster instanceof EntityPlayer)) {
            return SpellBase.SpellCastResult.NOTALLOW;
        }
        CardinalSystem.TargetingSystem.Target tg = CardinalSystem.TargetingSystem.INSTANCE.getTarget((EntityPlayer)caster);
        EntityLivingBase entityLivingBase = tg.getTarget();
        if (entityLivingBase == null) {
        } else {
            EntityLivingBase tgt = entityLivingBase;
            if (tg.isParty()) {
                return SpellBase.SpellCastResult.WRONGTGT;
            }
            if (!InteractionSecurity.INSTANCE.canDoSomethingWithEntity(caster, (Entity)tgt)) {
                return SpellBase.SpellCastResult.NOTALLOW;
            }
            if (ASJUtilities.isNotInFieldOfVision((EntityLivingBase)tgt, (EntityLivingBase)caster)) {
                return SpellBase.SpellCastResult.NOTSEEING;
            }
            SpellBase.SpellCastResult result = SpellDispel.INSTANCE.checkCastOver(caster);
            if (result == SpellBase.SpellCastResult.OK) {
                tgt.func_70015_d(ExtensionsKt.getI((Number)Float.valueOf(SpellBase.Companion.over(caster, this.getEfficiency()))));
            }
            return result;
        }
        int cost = this.getManaCost() * (this.getRace() == EnumRaceKt.getRace((EntityPlayer)caster) ? (byte)1 : AlfheimConfigHandler.INSTANCE.getRaceManaMult());
        if (!SpellBase.Companion.consumeMana((EntityPlayer)caster, cost, false, this)) {
            return SpellBase.SpellCastResult.NOMANA;
        }
        MovingObjectPosition mop = ASJUtilities.getSelectedBlock((EntityLivingBase)caster, (double)this.getRadius(), (boolean)false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mop.field_72310_e == -1) {
            return SpellBase.SpellCastResult.WRONGTGT;
        }
        switch (mop.field_72310_e) {
            case 0: {
                MovingObjectPosition movingObjectPosition = mop;
                movingObjectPosition.field_72312_c += -1;
                int cfr_ignored_0 = movingObjectPosition.field_72312_c;
                break;
            }
            case 1: {
                MovingObjectPosition movingObjectPosition = mop;
                ++movingObjectPosition.field_72312_c;
                int cfr_ignored_1 = movingObjectPosition.field_72312_c;
                break;
            }
            case 2: {
                MovingObjectPosition movingObjectPosition = mop;
                movingObjectPosition.field_72309_d += -1;
                int cfr_ignored_2 = movingObjectPosition.field_72309_d;
                break;
            }
            case 3: {
                MovingObjectPosition movingObjectPosition = mop;
                ++movingObjectPosition.field_72309_d;
                int cfr_ignored_3 = movingObjectPosition.field_72309_d;
                break;
            }
            case 4: {
                MovingObjectPosition movingObjectPosition = mop;
                movingObjectPosition.field_72311_b += -1;
                int cfr_ignored_4 = movingObjectPosition.field_72311_b;
                break;
            }
            case 5: {
                MovingObjectPosition movingObjectPosition = mop;
                ++movingObjectPosition.field_72311_b;
                int cfr_ignored_5 = movingObjectPosition.field_72311_b;
                break;
            }
        }
        if (!Blocks.field_150480_ab.func_149742_c(caster.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
            return SpellBase.SpellCastResult.OBSTRUCT;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(this, caster))) {
            return SpellBase.SpellCastResult.NOTALLOW;
        }
        ItemStack stackToPlace = new ItemStack((Block)Blocks.field_150480_ab);
        stackToPlace.func_77943_a((EntityPlayer)caster, caster.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e, ExtensionsKt.getF((Number)mop.field_72307_f.field_72450_a), ExtensionsKt.getF((Number)mop.field_72307_f.field_72448_b), ExtensionsKt.getF((Number)mop.field_72307_f.field_72449_c));
        if (stackToPlace.field_77994_a == 0) {
            SpellBase.Companion.consumeMana((EntityPlayer)caster, cost, true, this);
            return SpellBase.SpellCastResult.OK;
        }
        return SpellBase.SpellCastResult.OBSTRUCT;
    }

    private SpellIgnition() {
        super("ignition", EnumRace.SALAMANDER, 2000, 100, 5, false, 32, null);
    }

    static {
        SpellIgnition spellIgnition;
        INSTANCE = spellIgnition = new SpellIgnition();
        efficiency = 5.0;
    }
}

