/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.customgens;

import alexsocol.asjlib.SchemaUtils;
import alfheim.api.AlfheimAPI;
import alfheim.api.block.tile.SubTileAnomalyBase;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.block.tile.TileAnomaly;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.world.dim.alfheim.customgens.WorldGenAlfheim$WhenMappings;
import alfheim.common.world.dim.alfheim.structure.StructureSpawnpoint;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ8\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J&\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J.\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006$"}, d2={"Lalfheim/common/world/dim/alfheim/customgens/WorldGenAlfheim;", "Lcpw/mods/fml/common/IWorldGenerator;", "()V", "common", "Ljava/util/ArrayList;", "", "getCommon", "()Ljava/util/ArrayList;", "epic", "getEpic", "handSummer", "getHandSummer", "()Ljava/lang/String;", "handWinter", "getHandWinter", "rare", "getRare", "genRandomAnomalyOfRarity", "", "world", "Lnet/minecraft/world/World;", "chunkX", "", "chunkZ", "rand", "Ljava/util/Random;", "rarity", "Lalfheim/api/block/tile/SubTileAnomalyBase$EnumAnomalityRarity;", "generate", "chunkGenerator", "Lnet/minecraft/world/chunk/IChunkProvider;", "chunkProvider", "generateAlfheim", "generateHand", "setAnomality", "type", "Alfheim"})
public final class WorldGenAlfheim
implements IWorldGenerator {
    @NotNull
    private static final ArrayList<String> common;
    @NotNull
    private static final ArrayList<String> epic;
    @NotNull
    private static final ArrayList<String> rare;
    @NotNull
    private static final String handWinter;
    @NotNull
    private static final String handSummer;
    @NotNull
    public static final WorldGenAlfheim INSTANCE;

    @NotNull
    public final ArrayList<String> getCommon() {
        return common;
    }

    @NotNull
    public final ArrayList<String> getEpic() {
        return epic;
    }

    @NotNull
    public final ArrayList<String> getRare() {
        return rare;
    }

    @NotNull
    public final String getHandWinter() {
        return handWinter;
    }

    @NotNull
    public final String getHandSummer() {
        return handSummer;
    }

    public void generate(@NotNull Random rand, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkProvider chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
        if (world.field_73011_w.field_76574_g == AlfheimConfigHandler.INSTANCE.getDimensionIDAlfheim()) {
            this.generateAlfheim(world, chunkX, chunkZ, rand);
        }
    }

    public final void generateAlfheim(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand) {
        block3: {
            int chance;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                    Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
                    if (chunkX == 0 && chunkZ == 0 && !world.field_72995_K) {
                        StructureSpawnpoint.INSTANCE.generate(world, rand);
                    }
                    if (world.field_73012_v.nextInt(6000) == 0) {
                        this.generateHand(world, chunkX, chunkZ, rand);
                    }
                    if (AlfheimConfigHandler.INSTANCE.getAnomaliesDispersion() <= 0) {
                        return;
                    }
                    if (rand.nextInt(AlfheimConfigHandler.INSTANCE.getAnomaliesDispersion()) != 0) break block3;
                    chance = rand.nextInt(32) + 1;
                    if (chance != 32) break block4;
                    this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalityRarity.EPIC);
                    break block3;
                }
                if (chance < 24) break block5;
                this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalityRarity.RARE);
                break block3;
            }
            if (chance < 16) break block3;
            this.genRandomAnomalyOfRarity(world, chunkX, chunkZ, rand, SubTileAnomalyBase.EnumAnomalityRarity.COMMON);
        }
    }

    public final void generateHand(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
    }

    public final void genRandomAnomalyOfRarity(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand, @NotNull SubTileAnomalyBase.EnumAnomalityRarity rarity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)((Object)rarity), (String)"rarity");
        switch (WorldGenAlfheim$WhenMappings.$EnumSwitchMapping$1[rarity.ordinal()]) {
            case 1: {
                string = common.get(rand.nextInt(common.size()));
                break;
            }
            case 2: {
                string = epic.get(rand.nextInt(epic.size()));
                break;
            }
            case 3: {
                string = rare.get(rand.nextInt(rare.size()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (rarity) {\n\t\t\tEnumA\u2026d.nextInt(rare.size)]\n\t\t}");
        String type = string;
        this.setAnomality(world, chunkX, chunkZ, rand, type);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnomality(@NotNull World world, int chunkX, int chunkZ, @NotNull Random rand, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int x = chunkX * 16 + rand.nextInt(16) + 8;
        int z = chunkZ * 16 + rand.nextInt(16) + 8;
        int y = world.func_72825_h(x, z) + 1;
        world.func_147449_b(x, y, z, AlfheimBlocks.INSTANCE.getAnomaly());
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileAnomaly) {
            ((TileAnomaly)te).lock(x, y, z, world.field_73011_w.field_76574_g);
            SubTileAnomalyBase subTileAnomalyBase = SubTileAnomalyBase.Companion.forName(type);
            if (subTileAnomalyBase == null) {
                return;
            }
            SubTileAnomalyBase sub = subTileAnomalyBase;
            sub.setWorldGen(true);
            ((TileAnomaly)te).addSubTile(sub, type);
            int n = 0;
            int n2 = AlfheimConfigHandler.INSTANCE.getAnomaliesUpdate();
            while (n < n2) {
                void i;
                te.func_145845_h();
                ++i;
            }
            sub.setWorldGen(false);
        }
    }

    private WorldGenAlfheim() {
    }

    static {
        WorldGenAlfheim worldGenAlfheim;
        INSTANCE = worldGenAlfheim = new WorldGenAlfheim();
        common = new ArrayList();
        epic = new ArrayList();
        rare = new ArrayList();
        handWinter = SchemaUtils.INSTANCE.loadStructure("alfheim/schemas/WinterHand");
        handSummer = SchemaUtils.INSTANCE.loadStructure("alfheim/schemas/SummerHand");
        for (String s : AlfheimAPI.INSTANCE.getAnomalies().keySet()) {
            SubTileAnomalyBase subTileAnomalyBase = AlfheimAPI.INSTANCE.getAnomalyInstances().get(s);
            Intrinsics.checkNotNull((Object)subTileAnomalyBase);
            switch (WorldGenAlfheim$WhenMappings.$EnumSwitchMapping$0[subTileAnomalyBase.getRarity().ordinal()]) {
                case 1: {
                    common.add(s);
                    break;
                }
                case 2: {
                    epic.add(s);
                    break;
                }
                case 3: {
                    rare.add(s);
                    break;
                }
            }
        }
    }
}

