/*
 * Decompiled with CFR 0.152.
 */
package alfheim.common.world.dim.alfheim.structure;

import alexsocol.asjlib.ASJUtilities;
import alexsocol.asjlib.ExtensionsKt;
import alexsocol.asjlib.SchemaUtils;
import alfheim.AlfheimCore;
import alfheim.common.block.AlfheimBlocks;
import alfheim.common.core.handler.AlfheimConfigHandler;
import alfheim.common.item.AlfheimItems;
import alfheim.common.world.dim.alfheim.structure.AlfheimSchemas;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.item.ModItems;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J.\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint;", "", "()V", "items", "", "Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "getItems", "()[Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "[Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "generate", "", "world", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "generateSpawnCastle", "x", "", "y", "z", "generateStartBox", "RandomItemHolder", "Alfheim"})
public final class StructureSpawnpoint {
    @NotNull
    private static final RandomItemHolder[] items;
    @NotNull
    public static final StructureSpawnpoint INSTANCE;

    public final void generate(@NotNull World world, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (!AlfheimConfigHandler.INSTANCE.getEnableElvenStory() || AlfheimConfigHandler.INSTANCE.getBothSpawnStructures()) {
            this.generateSpawnCastle(world, 0, world.func_72825_h(0, 0) + 10, 0);
        }
        if (AlfheimConfigHandler.INSTANCE.getEnableElvenStory() || AlfheimConfigHandler.INSTANCE.getBothSpawnStructures()) {
            this.generateStartBox(world, 0, 248, 0, rand);
        }
        ASJUtilities.log((String)"Spawn created");
    }

    public final void generateSpawnCastle(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        world.func_72950_A(x, y, z);
        SchemaUtils.INSTANCE.generate(world, x, y, z, SchemaUtils.INSTANCE.loadStructure("alfheim/schemas/spawnpoint"));
        Block block = AlfheimCore.Companion.getWinter() ? AlfheimBlocks.INSTANCE.getSnowGrass() : (Block)Blocks.field_150349_c;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"if (AlfheimCore.winter) \u2026owGrass else Blocks.grass");
        ASJUtilities.fillGenHoles((World)world, (Block)block, (int)0, (int)(x - 11), (int)(x + 11), (int)(y - 8), (int)(z - 41), (int)(z + 1), (int)0);
    }

    public final void generateStartBox(@NotNull World world, int x, int y, int z, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        world.func_72950_A(x, y + 2, z);
        SchemaUtils.INSTANCE.generate(world, x, y, z, AlfheimSchemas.INSTANCE.getSpawnbox());
        if (!AlfheimConfigHandler.INSTANCE.getBonusChest()) {
            return;
        }
        world.func_147465_d(x, y + 2, z - 5, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntity tileEntity = world.func_147438_o(x, y + 2, z - 5);
        if (!(tileEntity instanceof TileEntityChest)) {
            tileEntity = null;
        }
        TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
        if (tileEntityChest == null) {
            return;
        }
        TileEntityChest tile = tileEntityChest;
        int count = ASJUtilities.randInBounds((int)ExtensionsKt.getI((Number)((double)items.length * 0.25)), (int)ExtensionsKt.getI((Number)((double)items.length * 0.75)), (Random)rand);
        Set itemPoses = CollectionsKt.toMutableSet((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)ArraysKt.getIndices((Object[])items))));
        Set slots = CollectionsKt.toMutableSet((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)RangesKt.until((int)0, (int)tile.func_70302_i_()))));
        while (count > 0) {
            int pos = ((Number)ExtensionsKt.removeRandom((Collection)itemPoses)).intValue();
            RandomItemHolder item = items[pos];
            if (!ASJUtilities.chance((Number)item.getChance())) {
                itemPoses.add(pos);
                continue;
            }
            --count;
            int meta = item.getMaxMeta() == -1 ? item.getMeta() : ASJUtilities.randInBounds((int)item.getMeta(), (int)item.getMaxMeta(), (Random)rand);
            int n = item.getItem().getItemStackLimit(new ItemStack(item.getItem(), 1, meta));
            int n2 = ASJUtilities.randInBounds((int)item.getCountMin(), (int)item.getCountMax(), (Random)rand);
            boolean bl = false;
            ExtensionsKt.set((IInventory)((IInventory)tile), (int)((Number)ExtensionsKt.removeRandom((Collection)slots)).intValue(), (ItemStack)new ItemStack(item.getItem(), Math.min(n, n2), meta));
        }
    }

    @NotNull
    public final RandomItemHolder[] getItems() {
        return items;
    }

    private StructureSpawnpoint() {
    }

    static {
        StructureSpawnpoint structureSpawnpoint;
        INSTANCE = structureSpawnpoint = new StructureSpawnpoint();
        RandomItemHolder[] randomItemHolderArray = new RandomItemHolder[19];
        Item item = Items.field_151039_o;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"Items.wooden_pickaxe");
        randomItemHolderArray[0] = new RandomItemHolder(item, 0, 1, 2, 50, 0, 32, null);
        Item item2 = Items.field_151053_p;
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"Items.wooden_axe");
        randomItemHolderArray[1] = new RandomItemHolder(item2, 0, 1, 2, 50, 0, 32, null);
        Item item3 = ModItems.manaResource;
        Intrinsics.checkNotNullExpressionValue((Object)item3, (String)"ModItems.manaResource");
        randomItemHolderArray[2] = new RandomItemHolder(item3, 13, 1, 4, 25, 0, 32, null);
        Item item4 = ModItems.manaResource;
        Intrinsics.checkNotNullExpressionValue((Object)item4, (String)"ModItems.manaResource");
        randomItemHolderArray[3] = new RandomItemHolder(item4, 22, 4, 8, 10, 0, 32, null);
        Item item5 = Items.field_151034_e;
        Intrinsics.checkNotNullExpressionValue((Object)item5, (String)"Items.apple");
        randomItemHolderArray[4] = new RandomItemHolder(item5, 0, 5, 10, 75, 0, 32, null);
        Item item6 = Items.field_151025_P;
        Intrinsics.checkNotNullExpressionValue((Object)item6, (String)"Items.bread");
        randomItemHolderArray[5] = new RandomItemHolder(item6, 0, 5, 10, 75, 0, 32, null);
        Item item7 = ModItems.manaBottle;
        Intrinsics.checkNotNullExpressionValue((Object)item7, (String)"ModItems.manaBottle");
        randomItemHolderArray[6] = new RandomItemHolder(item7, 0, 1, 3, 50, 0, 32, null);
        Item item8 = ModItems.blackLotus;
        Intrinsics.checkNotNullExpressionValue((Object)item8, (String)"ModItems.blackLotus");
        randomItemHolderArray[7] = new RandomItemHolder(item8, 0, 1, 2, 10, 0, 32, null);
        Item item9 = ModItems.blackLotus;
        Intrinsics.checkNotNullExpressionValue((Object)item9, (String)"ModItems.blackLotus");
        randomItemHolderArray[8] = new RandomItemHolder(item9, 1, 1, 1, 1, 0, 32, null);
        Item item10 = ModItems.fertilizer;
        Intrinsics.checkNotNullExpressionValue((Object)item10, (String)"ModItems.fertilizer");
        randomItemHolderArray[9] = new RandomItemHolder(item10, 1, 5, 15, 50, 0, 32, null);
        Block block = Blocks.field_150345_g;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"Blocks.sapling");
        Item item11 = ExtensionsKt.toItem((Block)block);
        Intrinsics.checkNotNull((Object)item11);
        randomItemHolderArray[10] = new RandomItemHolder(item11, 0, 2, 3, 50, 0, 32, null);
        Item item12 = ExtensionsKt.toItem((Block)AlfheimBlocks.INSTANCE.getDreamSapling());
        Intrinsics.checkNotNull((Object)item12);
        randomItemHolderArray[11] = new RandomItemHolder(item12, 0, 2, 3, 50, 0, 32, null);
        Item item13 = ModItems.cosmetic;
        Intrinsics.checkNotNullExpressionValue((Object)item13, (String)"ModItems.cosmetic");
        randomItemHolderArray[12] = new RandomItemHolder(item13, 0, 1, 1, 25, 31);
        Item item14 = ModItems.cosmetic;
        Intrinsics.checkNotNullExpressionValue((Object)item14, (String)"ModItems.cosmetic");
        randomItemHolderArray[13] = new RandomItemHolder(item14, 0, 1, 1, 10, 31);
        randomItemHolderArray[14] = new RandomItemHolder(AlfheimItems.INSTANCE.getCoatOfArms(), 0, 1, 1, 25, 17);
        randomItemHolderArray[15] = new RandomItemHolder(AlfheimItems.INSTANCE.getCoatOfArms(), 0, 1, 1, 25, 17);
        Block block2 = Blocks.field_150364_r;
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"Blocks.log");
        Item item15 = ExtensionsKt.toItem((Block)block2);
        Intrinsics.checkNotNull((Object)item15);
        randomItemHolderArray[16] = new RandomItemHolder(item15, 0, 8, 16, 45, 0, 32, null);
        Block block3 = Blocks.field_150363_s;
        Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"Blocks.log2");
        Item item16 = ExtensionsKt.toItem((Block)block3);
        Intrinsics.checkNotNull((Object)item16);
        randomItemHolderArray[17] = new RandomItemHolder(item16, 1, 8, 16, 45, 0, 32, null);
        Item item17 = ExtensionsKt.toItem((Block)AlfheimBlocks.INSTANCE.getAltWood1());
        Intrinsics.checkNotNull((Object)item17);
        randomItemHolderArray[18] = new RandomItemHolder(item17, 3, 8, 16, 45, 0, 32, null);
        items = randomItemHolderArray;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lalfheim/common/world/dim/alfheim/structure/StructureSpawnpoint$RandomItemHolder;", "", "item", "Lnet/minecraft/item/Item;", "meta", "", "countMin", "countMax", "chance", "maxMeta", "(Lnet/minecraft/item/Item;IIIII)V", "getChance", "()I", "getCountMax", "getCountMin", "getItem", "()Lnet/minecraft/item/Item;", "getMaxMeta", "getMeta", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Alfheim"})
    public static final class RandomItemHolder {
        @NotNull
        private final Item item;
        private final int meta;
        private final int countMin;
        private final int countMax;
        private final int chance;
        private final int maxMeta;

        @NotNull
        public final Item getItem() {
            return this.item;
        }

        public final int getMeta() {
            return this.meta;
        }

        public final int getCountMin() {
            return this.countMin;
        }

        public final int getCountMax() {
            return this.countMax;
        }

        public final int getChance() {
            return this.chance;
        }

        public final int getMaxMeta() {
            return this.maxMeta;
        }

        public RandomItemHolder(@NotNull Item item, int meta, int countMin, int countMax, int chance, int maxMeta) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.item = item;
            this.meta = meta;
            this.countMin = countMin;
            this.countMax = countMax;
            this.chance = chance;
            this.maxMeta = maxMeta;
        }

        public /* synthetic */ RandomItemHolder(Item item, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x20) != 0) {
                n5 = -1;
            }
            this(item, n, n2, n3, n4, n5);
        }

        @NotNull
        public final Item component1() {
            return this.item;
        }

        public final int component2() {
            return this.meta;
        }

        public final int component3() {
            return this.countMin;
        }

        public final int component4() {
            return this.countMax;
        }

        public final int component5() {
            return this.chance;
        }

        public final int component6() {
            return this.maxMeta;
        }

        @NotNull
        public final RandomItemHolder copy(@NotNull Item item, int meta, int countMin, int countMax, int chance, int maxMeta) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new RandomItemHolder(item, meta, countMin, countMax, chance, maxMeta);
        }

        public static /* synthetic */ RandomItemHolder copy$default(RandomItemHolder randomItemHolder, Item item, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                item = randomItemHolder.item;
            }
            if ((n6 & 2) != 0) {
                n = randomItemHolder.meta;
            }
            if ((n6 & 4) != 0) {
                n2 = randomItemHolder.countMin;
            }
            if ((n6 & 8) != 0) {
                n3 = randomItemHolder.countMax;
            }
            if ((n6 & 0x10) != 0) {
                n4 = randomItemHolder.chance;
            }
            if ((n6 & 0x20) != 0) {
                n5 = randomItemHolder.maxMeta;
            }
            return randomItemHolder.copy(item, n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "RandomItemHolder(item=" + this.item + ", meta=" + this.meta + ", countMin=" + this.countMin + ", countMax=" + this.countMax + ", chance=" + this.chance + ", maxMeta=" + this.maxMeta + ")";
        }

        public int hashCode() {
            Item item = this.item;
            return (((((item != null ? item.hashCode() : 0) * 31 + Integer.hashCode(this.meta)) * 31 + Integer.hashCode(this.countMin)) * 31 + Integer.hashCode(this.countMax)) * 31 + Integer.hashCode(this.chance)) * 31 + Integer.hashCode(this.maxMeta);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RandomItemHolder)) break block3;
                    RandomItemHolder randomItemHolder = (RandomItemHolder)object;
                    if (!Intrinsics.areEqual((Object)this.item, (Object)randomItemHolder.item) || this.meta != randomItemHolder.meta || this.countMin != randomItemHolder.countMin || this.countMax != randomItemHolder.countMax || this.chance != randomItemHolder.chance || this.maxMeta != randomItemHolder.maxMeta) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

