/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiNumberBox;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiCraftAmount
extends AEBaseGui {
    private GuiNumberBox amountToCraft;
    private GuiTabButton originalGuiBtn;
    private GuiButton next;
    private GuiButton plus1;
    private GuiButton plus10;
    private GuiButton plus100;
    private GuiButton plus1000;
    private GuiButton minus1;
    private GuiButton minus10;
    private GuiButton minus100;
    private GuiButton minus1000;
    private GuiBridge originalGui;

    public GuiCraftAmount(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftAmount(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        ItemStack stack;
        Iterator iterator;
        super.func_73866_w_();
        int a = AEConfig.instance.craftItemsByStackAmounts(0);
        int b = AEConfig.instance.craftItemsByStackAmounts(1);
        int c = AEConfig.instance.craftItemsByStackAmounts(2);
        int d = AEConfig.instance.craftItemsByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 26, 22, 20, "+" + a);
        this.field_146292_n.add(this.plus1);
        this.plus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 26, 28, 20, "+" + b);
        this.field_146292_n.add(this.plus10);
        this.plus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 26, 32, 20, "+" + c);
        this.field_146292_n.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 26, 38, 20, "+" + d);
        this.field_146292_n.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.field_147003_i + 20, this.field_147009_r + 75, 22, 20, "-" + a);
        this.field_146292_n.add(this.minus1);
        this.minus10 = new GuiButton(0, this.field_147003_i + 48, this.field_147009_r + 75, 28, 20, "-" + b);
        this.field_146292_n.add(this.minus10);
        this.minus100 = new GuiButton(0, this.field_147003_i + 82, this.field_147009_r + 75, 32, 20, "-" + c);
        this.field_146292_n.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.field_147003_i + 120, this.field_147009_r + 75, 38, 20, "-" + d);
        this.field_146292_n.add(this.minus1000);
        this.next = new GuiButton(0, this.field_147003_i + 128, this.field_147009_r + 51, 38, 20, GuiText.Next.getLocal());
        this.field_146292_n.add(this.next);
        ItemStack myIcon = null;
        Object target = ((AEBaseContainer)this.field_147002_h).getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            iterator = definitions.items().wirelessTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack wirelessTerminalStack;
                myIcon = wirelessTerminalStack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (target instanceof PartTerminal) {
            iterator = parts.terminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_ME;
        }
        if (target instanceof PartCraftingTerminal) {
            iterator = parts.craftingTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (target instanceof PartPatternTerminal) {
            iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (this.originalGui != null && myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, myIcon, myIcon.func_82833_r(), field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
        }
        this.amountToCraft = new GuiNumberBox(this.field_146289_q, this.field_147003_i + 62, this.field_147009_r + 57, 59, this.field_146289_q.field_78288_b, Integer.class);
        this.amountToCraft.func_146185_a(false);
        this.amountToCraft.func_146203_f(16);
        this.amountToCraft.func_146193_g(0xFFFFFF);
        this.amountToCraft.func_146189_e(true);
        this.amountToCraft.func_146195_b(true);
        this.amountToCraft.func_146180_a("1");
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.next.field_146126_j = GuiCraftAmount.func_146272_n() ? GuiText.Start.getLocal() : GuiText.Next.getLocal();
        this.bindTexture("guis/craftAmt.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        try {
            Long.parseLong(this.amountToCraft.func_146179_b());
            this.next.field_146124_l = this.amountToCraft.func_146179_b().length() > 0;
        }
        catch (NumberFormatException e) {
            this.next.field_146124_l = false;
        }
        this.amountToCraft.func_146194_f();
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28) {
                this.func_146284_a(this.next);
            }
            if ((key == 211 || key == 205 || key == 203 || key == 14 || character == '-' || Character.isDigit(character)) && this.amountToCraft.func_146201_a(character, key)) {
                try {
                    long result;
                    String out = this.amountToCraft.func_146179_b();
                    boolean fixed = false;
                    while (out.startsWith("0") && out.length() > 1) {
                        out = out.substring(1);
                        fixed = true;
                    }
                    if (fixed) {
                        this.amountToCraft.func_146180_a(out);
                    }
                    if (out.isEmpty()) {
                        out = "0";
                    }
                    if ((result = Long.parseLong(out)) < 0L) {
                        this.amountToCraft.func_146180_a("1");
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        boolean isMinus;
        super.func_146284_a(btn);
        try {
            if (btn == this.originalGuiBtn) {
                NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
            }
            if (btn == this.next) {
                NetworkHandler.instance.sendToServer(new PacketCraftRequest(Integer.parseInt(this.amountToCraft.func_146179_b()), GuiCraftAmount.func_146272_n()));
            }
        }
        catch (NumberFormatException e) {
            this.amountToCraft.func_146180_a("1");
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(int i) {
        try {
            long result;
            String out = this.amountToCraft.func_146179_b();
            boolean fixed = false;
            while (out.startsWith("0") && out.length() > 1) {
                out = out.substring(1);
                fixed = true;
            }
            if (fixed) {
                this.amountToCraft.func_146180_a(out);
            }
            if (out.isEmpty()) {
                out = "0";
            }
            if ((result = (long)Integer.parseInt(out)) == 1L && i > 1) {
                result = 0L;
            }
            if ((result += (long)i) < 1L) {
                result = 1L;
            }
            out = Long.toString(result);
            Integer.parseInt(out);
            this.amountToCraft.func_146180_a(out);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected String getBackground() {
        return "guis/craftAmt.png";
    }
}

