/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.client.render.RenderBlocksWorkaround;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusContainer;
import java.util.ArrayList;
import ml.luxinfine.ae.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class CableRenderHelper {
    private static final CableRenderHelper INSTANCE = new CableRenderHelper();

    public static CableRenderHelper getInstance() {
        return INSTANCE;
    }

    public void renderStatic(CableBusContainer cableBusContainer, IFacadeContainer iFacadeContainer) {
        TileEntity te = cableBusContainer.getTile();
        RenderBlocksWorkaround renderer = BusRenderer.INSTANCE.getRenderer();
        if (renderer.field_147840_d != null) {
            BusRenderHelper.INSTANCE.setPass(0);
        }
        if (renderer.field_147845_a == null) {
            renderer.field_147845_a = Minecraft.func_71410_x().field_71441_e;
        }
        for (ForgeDirection s : ModUtils.DIRECTIONS) {
            IPart part = cableBusContainer.getPart(s);
            if (part == null) continue;
            this.setSide(s);
            renderer.field_147837_f = true;
            renderer.field_147842_e = false;
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
            part.renderStatic(te.field_145851_c, te.field_145848_d, te.field_145849_e, BusRenderHelper.INSTANCE, renderer);
            renderer._faces = (byte)127;
            renderer.setCalculations(true);
            renderer.setUseTextures(true);
        }
        if (!iFacadeContainer.isEmpty()) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (ForgeDirection s : ModUtils.DIRECTIONS) {
                IPart part = cableBusContainer.getPart(s);
                if (part == null) continue;
                this.setSide(s);
                BusRenderHelper brh = BusRenderHelper.INSTANCE;
                BusCollisionHelper bch = new BusCollisionHelper(boxes, brh.getWorldX(), brh.getWorldY(), brh.getWorldZ(), null, true);
                part.getBoxes(bch);
            }
            boolean useThinFacades = false;
            double min = 0.125;
            double max = 0.875;
            for (AxisAlignedBB bb : boxes) {
                int o = 0;
                o += bb.field_72336_d > 0.875 ? 1 : 0;
                o += bb.field_72337_e > 0.875 ? 1 : 0;
                o += bb.field_72334_f > 0.875 ? 1 : 0;
                o += bb.field_72340_a < 0.125 ? 1 : 0;
                o += bb.field_72338_b < 0.125 ? 1 : 0;
                if ((o += bb.field_72339_c < 0.125 ? 1 : 0) < 2) continue;
                useThinFacades = true;
                break;
            }
            for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
                IFacadePart fPart = iFacadeContainer.getFacade(s);
                if (fPart == null) continue;
                fPart.setThinFacades(useThinFacades);
                AxisAlignedBB pb = fPart.getPrimaryBox();
                AxisAlignedBB b = null;
                for (AxisAlignedBB bb : boxes) {
                    if (!bb.func_72326_a(pb)) continue;
                    if (b == null) {
                        b = bb;
                        continue;
                    }
                    b.field_72336_d = Math.max(b.field_72336_d, bb.field_72336_d);
                    b.field_72337_e = Math.max(b.field_72337_e, bb.field_72337_e);
                    b.field_72334_f = Math.max(b.field_72334_f, bb.field_72334_f);
                    b.field_72340_a = Math.min(b.field_72340_a, bb.field_72340_a);
                    b.field_72338_b = Math.min(b.field_72338_b, bb.field_72338_b);
                    b.field_72339_c = Math.min(b.field_72339_c, bb.field_72339_c);
                }
                renderer.field_147842_e = false;
                renderer.field_147873_r = 0;
                renderer.field_147867_u = 0;
                renderer.field_147871_s = 0;
                renderer.field_147869_t = 0;
                renderer.field_147875_q = 0;
                renderer.field_147865_v = 0;
                this.setSide(s);
                fPart.renderStatic(te.field_145851_c, te.field_145848_d, te.field_145849_e, BusRenderHelper.INSTANCE, renderer, iFacadeContainer, b, cableBusContainer.getPart(s) == null);
            }
            renderer.setFacade(false);
            renderer.field_147863_w = false;
            renderer.setTexture(null);
            renderer.setCalculations(true);
        }
    }

    private void setSide(ForgeDirection s) {
        ForgeDirection az;
        ForgeDirection ay;
        ForgeDirection ax;
        switch (s) {
            case DOWN: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.NORTH;
                az = ForgeDirection.DOWN;
                break;
            }
            case UP: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.SOUTH;
                az = ForgeDirection.UP;
                break;
            }
            case EAST: {
                ax = ForgeDirection.SOUTH;
                ay = ForgeDirection.UP;
                az = ForgeDirection.EAST;
                break;
            }
            case WEST: {
                ax = ForgeDirection.NORTH;
                ay = ForgeDirection.UP;
                az = ForgeDirection.WEST;
                break;
            }
            case NORTH: {
                ax = ForgeDirection.WEST;
                ay = ForgeDirection.UP;
                az = ForgeDirection.NORTH;
                break;
            }
            default: {
                ax = ForgeDirection.EAST;
                ay = ForgeDirection.UP;
                az = ForgeDirection.SOUTH;
            }
        }
        BusRenderHelper.INSTANCE.setOrientation(ax, ay, az);
    }

    public void renderDynamic(CableBusContainer cableBusContainer, double x, double y, double z) {
        for (ForgeDirection s : ModUtils.DIRECTIONS) {
            ForgeDirection az;
            ForgeDirection ay;
            ForgeDirection ax;
            IPart part = cableBusContainer.getPart(s);
            if (part == null) continue;
            switch (s) {
                case DOWN: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.NORTH;
                    az = ForgeDirection.DOWN;
                    break;
                }
                case UP: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.SOUTH;
                    az = ForgeDirection.UP;
                    break;
                }
                case EAST: {
                    ax = ForgeDirection.SOUTH;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.EAST;
                    break;
                }
                case WEST: {
                    ax = ForgeDirection.NORTH;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.WEST;
                    break;
                }
                case NORTH: {
                    ax = ForgeDirection.WEST;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    ax = ForgeDirection.EAST;
                    ay = ForgeDirection.UP;
                    az = ForgeDirection.SOUTH;
                }
            }
            BusRenderHelper.INSTANCE.setOrientation(ax, ay, az);
            part.renderDynamic(x, y, z, BusRenderHelper.INSTANCE, BusRenderer.INSTANCE.getRenderer());
        }
    }
}

