/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.settings.TickRates;
import appeng.items.materials.MaterialType;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class AEConfig
extends Configuration
implements IConfigurableObject,
IConfigManagerHost {
    public static final double TUNNEL_POWER_LOSS = 0.05;
    public static final String VERSION = "rv3-beta-6";
    public static final String CHANNEL = "beta";
    public static final String PACKET_CHANNEL = "AE";
    public static AEConfig instance;
    public final IConfigManager settings = new ConfigManager(this);
    public final EnumSet<AEFeature> featureFlags = EnumSet.noneOf(AEFeature.class);
    private long[] featureFlagsRaw;
    public final int[] craftByStacks;
    public final int[] priorityByStacks;
    public final int[] levelByStacks;
    private final double WirelessHighWirelessCount = 64.0;
    private final File configFile;
    public int storageBiomeID;
    public int storageProviderID;
    public int formationPlaneEntityLimit;
    public float spawnChargedChance;
    public int quartzOresPerCluster;
    public int quartzOresClusterAmount;
    public final int chargedChange = 4;
    public int minMeteoriteDistance;
    public int minMeteoriteDistanceSq;
    public double spatialPowerExponent;
    public double spatialPowerMultiplier;
    public String[] grinderOres;
    public double oreDoublePercentage;
    public boolean enableEffects;
    public boolean useLargeFonts;
    public boolean useColoredCraftingStatus;
    public int wirelessTerminalBattery;
    public int entropyManipulatorBattery;
    public int matterCannonBattery;
    public int portableCellBattery;
    public int colorApplicatorBattery;
    public int chargedStaffBattery;
    public boolean disableColoredCableRecipesInNEI;
    public boolean updatable;
    public double meteoriteClusterChance;
    public double meteoriteSpawnChance;
    public int[] meteoriteDimensionWhitelist;
    public int craftingCalculationTimePerTick;
    PowerUnits selectedPowerUnit;
    private double WirelessBaseCost;
    private double WirelessCostMultiplier;
    private double WirelessTerminalDrainMultiplier;
    private double WirelessBaseRange;
    private double WirelessBoosterRangeMultiplier;
    private double WirelessBoosterExp;

    public AEConfig(File configFile) {
        super(configFile);
        List<String> version;
        try {
            Class<?> jumboSet = this.featureFlags.getClass();
            if (jumboSet.getName().equals("java.util.JumboEnumSet")) {
                Field elementsField = jumboSet.getDeclaredField("elements");
                elementsField.setAccessible(true);
                this.featureFlagsRaw = (long[])elementsField.get(this.featureFlags);
            }
        }
        catch (Throwable jumboSet) {
            // empty catch block
        }
        this.craftByStacks = new int[]{1, 10, 100, 1000};
        this.priorityByStacks = new int[]{1, 10, 100, 1000};
        this.levelByStacks = new int[]{1, 10, 100, 1000};
        this.WirelessHighWirelessCount = 64.0;
        this.storageBiomeID = -1;
        this.storageProviderID = -1;
        this.formationPlaneEntityLimit = 128;
        this.spawnChargedChance = 0.92f;
        this.quartzOresPerCluster = 4;
        this.quartzOresClusterAmount = 15;
        this.chargedChange = 4;
        this.minMeteoriteDistance = 707;
        this.minMeteoriteDistanceSq = this.minMeteoriteDistance * this.minMeteoriteDistance;
        this.spatialPowerExponent = 1.35;
        this.spatialPowerMultiplier = 1250.0;
        this.grinderOres = new String[]{"Obsidian", "Ender", "EnderPearl", "Coal", "Iron", "Gold", "Charcoal", "NetherQuartz", "Copper", "Tin", "Silver", "Lead", "Bronze", "CertusQuartz", "Wheat", "Fluix", "Brass", "Platinum", "Nickel", "Invar", "Aluminium", "Electrum", "Osmium", "Zinc"};
        this.oreDoublePercentage = 90.0;
        this.enableEffects = true;
        this.useLargeFonts = false;
        this.wirelessTerminalBattery = 1600000;
        this.entropyManipulatorBattery = 200000;
        this.matterCannonBattery = 200000;
        this.portableCellBattery = 20000;
        this.colorApplicatorBattery = 20000;
        this.chargedStaffBattery = 8000;
        this.disableColoredCableRecipesInNEI = true;
        this.updatable = false;
        this.meteoriteClusterChance = 0.1;
        this.meteoriteSpawnChance = 0.3;
        this.meteoriteDimensionWhitelist = new int[]{0};
        this.craftingCalculationTimePerTick = 5;
        this.selectedPowerUnit = PowerUnits.AE;
        this.WirelessBaseCost = 8.0;
        this.WirelessCostMultiplier = 1.0;
        this.WirelessTerminalDrainMultiplier = 1.0;
        this.WirelessBaseRange = 16.0;
        this.WirelessBoosterRangeMultiplier = 1.0;
        this.WirelessBoosterExp = 1.5;
        this.configFile = configFile;
        FMLCommonHandler.instance().bus().register((Object)this);
        double DEFAULT_MEKANISM_EXCHANGE = 0.2;
        PowerUnits.MK.conversionRatio = this.get("PowerRatios", "Mekanism", 0.2).getDouble(0.2);
        double DEFAULT_IC2_EXCHANGE = 2.0;
        PowerUnits.EU.conversionRatio = this.get("PowerRatios", "IC2", 2.0).getDouble(2.0);
        double DEFAULT_RTC_EXCHANGE = 8.884150675195451E-5;
        PowerUnits.WA.conversionRatio = this.get("PowerRatios", "RotaryCraft", 8.884150675195451E-5).getDouble(8.884150675195451E-5);
        double DEFAULT_RF_EXCHANGE = 0.5;
        PowerUnits.RF.conversionRatio = this.get("PowerRatios", "ThermalExpansion", 0.5).getDouble(0.5);
        double usageEffective = this.get("PowerRatios", "UsageMultiplier", 1.0).getDouble(1.0);
        PowerMultiplier.CONFIG.multiplier = Math.max(0.01, usageEffective);
        CondenserOutput.MATTER_BALLS.requiredPower = this.get("Condenser", "MatterBalls", 256).getInt(256);
        CondenserOutput.SINGULARITY.requiredPower = this.get("Condenser", "Singularity", 256000).getInt(256000);
        this.grinderOres = this.get("GrindStone", "grinderOres", this.grinderOres).getStringList();
        this.oreDoublePercentage = this.get("GrindStone", "oreDoublePercentage", this.oreDoublePercentage).getDouble(this.oreDoublePercentage);
        this.settings.registerSetting(Settings.SEARCH_TOOLTIPS, YesNo.YES);
        this.settings.registerSetting(Settings.TERMINAL_STYLE, TerminalStyle.TALL);
        this.settings.registerSetting(Settings.SEARCH_MODE, SearchBoxMode.AUTOSEARCH);
        this.spawnChargedChance = (float)(1.0 - this.get("worldGen", "spawnChargedChance", 1.0 - (double)this.spawnChargedChance).getDouble(1.0 - (double)this.spawnChargedChance));
        this.minMeteoriteDistance = this.get("worldGen", "minMeteoriteDistance", this.minMeteoriteDistance).getInt(this.minMeteoriteDistance);
        this.meteoriteClusterChance = this.get("worldGen", "meteoriteClusterChance", this.meteoriteClusterChance).getDouble(this.meteoriteClusterChance);
        this.meteoriteSpawnChance = this.get("worldGen", "meteoriteSpawnChance", this.meteoriteSpawnChance).getDouble(this.meteoriteSpawnChance);
        this.meteoriteDimensionWhitelist = this.get("worldGen", "meteoriteDimensionWhitelist", this.meteoriteDimensionWhitelist).getIntList();
        this.quartzOresPerCluster = this.get("worldGen", "quartzOresPerCluster", this.quartzOresPerCluster).getInt(this.quartzOresPerCluster);
        this.quartzOresClusterAmount = this.get("worldGen", "quartzOresClusterAmount", this.quartzOresClusterAmount).getInt(this.quartzOresClusterAmount);
        this.minMeteoriteDistanceSq = this.minMeteoriteDistance * this.minMeteoriteDistance;
        this.addCustomCategoryComment("wireless", "Range= WirelessBaseRange + WirelessBoosterRangeMultiplier * Math.pow( boosters, WirelessBoosterExp )\nPowerDrain= WirelessBaseCost + WirelessCostMultiplier * Math.pow( boosters, 1 + boosters / WirelessHighWirelessCount )");
        this.WirelessBaseCost = this.get("wireless", "WirelessBaseCost", this.WirelessBaseCost).getDouble(this.WirelessBaseCost);
        this.WirelessCostMultiplier = this.get("wireless", "WirelessCostMultiplier", this.WirelessCostMultiplier).getDouble(this.WirelessCostMultiplier);
        this.WirelessBaseRange = this.get("wireless", "WirelessBaseRange", this.WirelessBaseRange).getDouble(this.WirelessBaseRange);
        this.WirelessBoosterRangeMultiplier = this.get("wireless", "WirelessBoosterRangeMultiplier", this.WirelessBoosterRangeMultiplier).getDouble(this.WirelessBoosterRangeMultiplier);
        this.WirelessBoosterExp = this.get("wireless", "WirelessBoosterExp", this.WirelessBoosterExp).getDouble(this.WirelessBoosterExp);
        this.WirelessTerminalDrainMultiplier = this.get("wireless", "WirelessTerminalDrainMultiplier", this.WirelessTerminalDrainMultiplier).getDouble(this.WirelessTerminalDrainMultiplier);
        this.formationPlaneEntityLimit = this.get("automation", "formationPlaneEntityLimit", this.formationPlaneEntityLimit).getInt(this.formationPlaneEntityLimit);
        this.wirelessTerminalBattery = this.get("battery", "wirelessTerminal", this.wirelessTerminalBattery).getInt(this.wirelessTerminalBattery);
        this.chargedStaffBattery = this.get("battery", "chargedStaff", this.chargedStaffBattery).getInt(this.chargedStaffBattery);
        this.entropyManipulatorBattery = this.get("battery", "entropyManipulator", this.entropyManipulatorBattery).getInt(this.entropyManipulatorBattery);
        this.portableCellBattery = this.get("battery", "portableCell", this.portableCellBattery).getInt(this.portableCellBattery);
        this.colorApplicatorBattery = this.get("battery", "colorApplicator", this.colorApplicatorBattery).getInt(this.colorApplicatorBattery);
        this.matterCannonBattery = this.get("battery", "matterCannon", this.matterCannonBattery).getInt(this.matterCannonBattery);
        this.clientSync();
        for (AEFeature feature : AEFeature.values()) {
            if (feature.isVisible()) {
                if (!this.get("Features." + feature.category, feature.name(), feature.defaultValue).getBoolean(feature.defaultValue)) continue;
                this.featureFlags.add(feature);
                continue;
            }
            this.featureFlags.add(feature);
        }
        ModContainer imb = (ModContainer)Loader.instance().getIndexedModList().get("ImmibisCore");
        if (imb != null && (version = Arrays.asList("59.0.0", "59.0.1", "59.0.2")).contains(imb.getVersion())) {
            this.featureFlags.remove((Object)AEFeature.AlphaPass);
        }
        try {
            this.selectedPowerUnit = PowerUnits.valueOf(this.get("Client", "PowerUnit", this.selectedPowerUnit.name(), this.getListComment(this.selectedPowerUnit)).getString());
        }
        catch (Throwable t) {
            this.selectedPowerUnit = PowerUnits.AE;
        }
        for (TickRates tr : TickRates.values()) {
            tr.Load(this);
        }
        if (this.isFeatureEnabled(AEFeature.SpatialIO)) {
            this.storageBiomeID = this.get("spatialio", "storageBiomeID", this.storageBiomeID).getInt(this.storageBiomeID);
            this.storageProviderID = this.get("spatialio", "storageProviderID", this.storageProviderID).getInt(this.storageProviderID);
            this.spatialPowerMultiplier = this.get("spatialio", "spatialPowerMultiplier", this.spatialPowerMultiplier).getDouble(this.spatialPowerMultiplier);
            this.spatialPowerExponent = this.get("spatialio", "spatialPowerExponent", this.spatialPowerExponent).getDouble(this.spatialPowerExponent);
        }
        if (this.isFeatureEnabled(AEFeature.CraftingCPU)) {
            this.craftingCalculationTimePerTick = this.get("craftingCPU", "craftingCalculationTimePerTick", this.craftingCalculationTimePerTick).getInt(this.craftingCalculationTimePerTick);
        }
        this.updatable = true;
    }

    private void clientSync() {
        this.disableColoredCableRecipesInNEI = this.get("Client", "disableColoredCableRecipesInNEI", true).getBoolean(true);
        this.enableEffects = this.get("Client", "enableEffects", true).getBoolean(true);
        this.useLargeFonts = this.get("Client", "useTerminalUseLargeFont", false).getBoolean(false);
        this.useColoredCraftingStatus = this.get("Client", "useColoredCraftingStatus", true).getBoolean(true);
        for (int btnNum = 0; btnNum < 4; ++btnNum) {
            Property cmb = this.get("Client", "craftAmtButton" + (btnNum + 1), this.craftByStacks[btnNum]);
            Property pmb = this.get("Client", "priorityAmtButton" + (btnNum + 1), this.priorityByStacks[btnNum]);
            Property lmb = this.get("Client", "levelAmtButton" + (btnNum + 1), this.levelByStacks[btnNum]);
            int buttonCap = (int)(Math.pow(10.0, btnNum + 1) - 1.0);
            this.craftByStacks[btnNum] = Math.abs(cmb.getInt(this.craftByStacks[btnNum]));
            this.priorityByStacks[btnNum] = Math.abs(pmb.getInt(this.priorityByStacks[btnNum]));
            this.levelByStacks[btnNum] = Math.abs(pmb.getInt(this.levelByStacks[btnNum]));
            cmb.comment = "Controls buttons on Crafting Screen : Capped at " + buttonCap;
            pmb.comment = "Controls buttons on Priority Screen : Capped at " + buttonCap;
            lmb.comment = "Controls buttons on Level Emitter Screen : Capped at " + buttonCap;
            this.craftByStacks[btnNum] = Math.min(this.craftByStacks[btnNum], buttonCap);
            this.priorityByStacks[btnNum] = Math.min(this.priorityByStacks[btnNum], buttonCap);
            this.levelByStacks[btnNum] = Math.min(this.levelByStacks[btnNum], buttonCap);
        }
        for (Settings e : this.settings.getSettings()) {
            String Category2 = "Client";
            Enum value = this.settings.getSetting(e);
            Property p = this.get("Client", e.name(), value.name(), this.getListComment(value));
            try {
                value = Enum.valueOf(value.getClass(), p.getString());
            }
            catch (IllegalArgumentException er) {
                AELog.info("Invalid value '" + p.getString() + "' for " + e.name() + " using '" + value.name() + "' instead", new Object[0]);
            }
            this.settings.putSetting(e, value);
        }
    }

    private String getListComment(Enum value) {
        String comment = null;
        if (value != null) {
            EnumSet set = EnumSet.allOf(value.getClass());
            for (Object Oeg : set) {
                Enum eg = (Enum)Oeg;
                if (comment == null) {
                    comment = "Possible Values: " + eg.name();
                    continue;
                }
                comment = comment + ", " + eg.name();
            }
        }
        return comment;
    }

    public boolean isFeatureEnabled(AEFeature f) {
        if (this.featureFlagsRaw != null) {
            int index = f.ordinal();
            return (this.featureFlagsRaw[index >>> 6] & 1L << index) != 0L;
        }
        return this.featureFlags.contains((Object)f);
    }

    public double wireless_getDrainRate(double range) {
        return this.WirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.WirelessBaseRange + this.WirelessBoosterRangeMultiplier * Math.pow(boosters, this.WirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.WirelessBaseCost + this.WirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.WirelessHighWirelessCount);
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        Property prop = super.get(category, key, defaultValue, comment, type);
        if (prop != null && !category.equals("Client")) {
            prop.setRequiresMcRestart(true);
        }
        return prop;
    }

    public void save() {
        if (this.isFeatureEnabled(AEFeature.SpatialIO)) {
            this.get("spatialio", "storageBiomeID", this.storageBiomeID).set(this.storageBiomeID);
            this.get("spatialio", "storageProviderID", this.storageProviderID).set(this.storageProviderID);
        }
        this.get("Client", "PowerUnit", this.selectedPowerUnit.name(), this.getListComment(this.selectedPowerUnit)).set(this.selectedPowerUnit.name());
        if (this.hasChanged()) {
            super.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("appliedenergistics2")) {
            this.clientSync();
        }
    }

    public boolean disableColoredCableRecipesInNEI() {
        return this.disableColoredCableRecipesInNEI;
    }

    public String getFilePath() {
        return this.configFile.toString();
    }

    public boolean useAEVersion(MaterialType mt) {
        if (this.isFeatureEnabled(AEFeature.WebsiteRecipes)) {
            return true;
        }
        this.setCategoryComment("OreCamouflage", "AE2 Automatically uses alternative ores present in your instance of MC to blend better with its surroundings, if you prefer you can disable this selectively using these flags; Its important to note, that some if these items even if enabled may not be craftable in game because other items are overriding their recipes.");
        Property p = this.get("OreCamouflage", mt.name(), true);
        p.comment = "OreDictionary Names: " + mt.getOreName();
        return !p.getBoolean(true);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum setting, Enum newValue) {
        for (Settings e : this.settings.getSettings()) {
            if (e != setting) continue;
            String Category2 = "Client";
            Property p = this.get("Client", e.name(), this.settings.getSetting(e).name(), this.getListComment(newValue));
            p.set(newValue.name());
        }
        if (this.updatable) {
            this.save();
        }
    }

    public int getFreeMaterial(int varID) {
        return this.getFreeIDSLot(varID, "materials");
    }

    public int getFreeIDSLot(int varID, String category) {
        boolean alreadyUsed = false;
        int min = 0;
        for (Property p : this.getCategory(category).getValues().values()) {
            int thisInt = p.getInt();
            if (varID == thisInt) {
                alreadyUsed = true;
            }
            min = Math.max(min, thisInt + 1);
        }
        if (alreadyUsed) {
            if (min < 16383) {
                min = 16383;
            }
            return min;
        }
        return varID;
    }

    public int getFreePart(int varID) {
        return this.getFreeIDSLot(varID, "parts");
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    public boolean useTerminalUseLargeFont() {
        return this.useLargeFonts;
    }

    public int craftItemsByStackAmounts(int i) {
        return this.craftByStacks[i];
    }

    public int priorityByStacksAmounts(int i) {
        return this.priorityByStacks[i];
    }

    public int levelByStackAmounts(int i) {
        return this.levelByStacks[i];
    }

    public Enum getSetting(String category, Class<? extends Enum> class1, Enum myDefault) {
        String name = class1.getSimpleName();
        Property p = this.get(category, name, myDefault.name());
        try {
            return (Enum)class1.getField(p.toString()).get(class1);
        }
        catch (Throwable throwable) {
            return myDefault;
        }
    }

    public void setSetting(String category, Enum s) {
        String name = s.getClass().getSimpleName();
        this.get(category, name, s.name()).set(s.name());
        this.save();
    }

    public PowerUnits selectedPowerUnit() {
        return this.selectedPowerUnit;
    }

    public void nextPowerUnit(boolean backwards) {
        this.selectedPowerUnit = Platform.rotateEnum(this.selectedPowerUnit, backwards, Settings.POWER_UNITS.getPossibleValues());
        this.save();
    }
}

