/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiNetworkStatus;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketMEInventoryUpdate
extends AppEngPacket {
    private List<IAEItemStack> list;
    private final NBTTagList nbtStacks = new NBTTagList();
    private final byte ref;
    private boolean empty = true;

    public PacketMEInventoryUpdate(ByteBuf stream) throws IOException {
        this.ref = stream.readByte();
        byte[] data = new byte[stream.readableBytes()];
        stream.readBytes(data);
        NBTTagList innerList = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a).func_150295_c("l", 10);
        int s = innerList.func_74745_c();
        this.list = new ArrayList<IAEItemStack>(s + (s >> 1) + 1);
        for (int i = 0; i < s; ++i) {
            NBTTagCompound entry = innerList.func_150305_b(i);
            Item item = Item.func_150899_d((int)entry.func_74765_d("i"));
            if (item == null) continue;
            long size = entry.func_74763_f("s");
            long countRequestable = entry.func_74763_f("r");
            boolean craftable = entry.func_74767_n("c");
            short damage = entry.func_74765_d("d");
            ItemStack mcItem = new ItemStack(item, 1, (int)damage);
            mcItem.field_77990_d = (NBTTagCompound)entry.func_74781_a("t");
            this.list.add((IAEItemStack)((IAEItemStack)((IAEItemStack)AEItemStack.create(mcItem).setStackSize(size)).setCountRequestable(countRequestable)).setCraftable(craftable));
        }
        this.empty = this.list.isEmpty();
    }

    public PacketMEInventoryUpdate() throws IOException {
        this(0);
    }

    public PacketMEInventoryUpdate(byte ref) throws IOException {
        this.ref = ref;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiCraftConfirm) {
            ((GuiCraftConfirm)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiCraftingCPU) {
            ((GuiCraftingCPU)gs).postUpdate(this.list, this.ref);
        }
        if (gs instanceof GuiMEMonitorable) {
            ((GuiMEMonitorable)gs).postUpdate(this.list);
        }
        if (gs instanceof GuiNetworkStatus) {
            ((GuiNetworkStatus)gs).postUpdate(this.list);
        }
    }

    @Override
    @Nullable
    public FMLProxyPacket getProxy() {
        try {
            NBTTagCompound tagsData = new NBTTagCompound();
            tagsData.func_74782_a("l", (NBTBase)this.nbtStacks);
            byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)tagsData);
            ByteBuf data = Unpooled.buffer((int)(bytes.length + 4 + 1));
            data.writeInt(this.getPacketID());
            data.writeByte((int)this.ref);
            data.writeBytes(bytes);
            this.configureWrite(data);
            return super.getProxy();
        }
        catch (IOException e) {
            AELog.debug(e);
            return null;
        }
    }

    public void appendItem(IAEItemStack is) throws IOException, BufferOverflowException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("s", is.getStackSize());
        tag.func_74772_a("r", is.getCountRequestable());
        tag.func_74757_a("c", is.isCraftable());
        tag.func_74777_a("i", (short)Item.func_150891_b((Item)is.getItem()));
        tag.func_74777_a("d", (short)is.getItemDamage());
        NBTBase tags = (NBTBase)is.getTagCompound();
        if (tags != null) {
            tag.func_74782_a("t", tags);
        }
        this.nbtStacks.func_74742_a((NBTBase)tag);
        this.empty = false;
    }

    public int getLength() {
        return 0;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

