/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import tuhljin.automagy.gui.ContainerGreedyChestConfig;
import tuhljin.automagy.gui.GuiButtonCheckbox;
import tuhljin.automagy.gui.GuiButtonScaledText;
import tuhljin.automagy.gui.GuiTextFieldWithReporting;
import tuhljin.automagy.gui.ModGuiContainer;
import tuhljin.automagy.gui.SlotRestrictedWithReporting;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.MessageGUIGreedyChestConfig;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.tiles.TileEntityGreedyChest;

public class GUIGreedyChestConfig
extends ModGuiContainer {
    public TileEntityGreedyChest te;
    public final ResourceLocation texture = new ResourceLocation("Automagy:textures/gui/greedyChest.png");
    public GuiTextFieldWithReporting percentTextField;
    public GuiTextFieldWithReporting amountTextField;
    public static final String[] strMode = new String[]{StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.mode.0"), StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.mode.1"), StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.mode.2"), StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.mode.3")};
    private String strPercent = "50" + TjUtil.decimalSeparator + "00";
    private String strAmount = "64";
    private boolean showingPercentField = true;
    private GuiButtonScaledText buttonMode;
    private boolean filterExtraText = false;
    private boolean filterIsBlacklist = false;

    private GUIGreedyChestConfig(InventoryPlayer inventoryPlayer, TileEntityGreedyChest te, ContainerGreedyChestConfig container) {
        super(container);
        this.te = te;
        container.attachToGui(this);
    }

    public GUIGreedyChestConfig(InventoryPlayer inventoryPlayer, TileEntityGreedyChest te) {
        this(inventoryPlayer, te, new ContainerGreedyChestConfig(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int height = (int)(20.0f * this.scaleFactor);
        this.field_146292_n.add(new GuiButtonCheckbox(0, this.field_147003_i + 50, this.field_147009_r + 65, this.te.directions[1], this.texture, this.field_146999_f, 0));
        this.field_146292_n.add(new GuiButtonCheckbox(1, this.field_147003_i + 5, this.field_147009_r + 65, this.te.directions[0], this.texture, this.field_146999_f, 0));
        this.field_146292_n.add(new GuiButtonCheckbox(2, this.field_147003_i + 5, this.field_147009_r + 44, this.te.directions[2], this.texture, this.field_146999_f, 0));
        this.field_146292_n.add(new GuiButtonCheckbox(3, this.field_147003_i + 50, this.field_147009_r + 45, this.te.directions[3], this.texture, this.field_146999_f, 0));
        this.field_146292_n.add(new GuiButtonCheckbox(4, this.field_147003_i + 5, this.field_147009_r + 55, this.te.directions[4], this.texture, this.field_146999_f, 0));
        this.field_146292_n.add(new GuiButtonCheckbox(5, this.field_147003_i + 50, this.field_147009_r + 55, this.te.directions[5], this.texture, this.field_146999_f, 0));
        this.buttonMode = new GuiButtonScaledText(6, this.field_147003_i, this.field_147009_r + 10, 95, height, strMode[0], this.scaleFactor);
        this.field_146292_n.add(this.buttonMode);
        this.percentTextField = new GuiTextFieldWithReporting(7, this, this.field_146289_q, (int)((float)(this.field_147003_i + 102) / this.scaleFactorTextField), (int)((float)(this.field_147009_r + 11) / this.scaleFactorTextField), 38, 16);
        this.percentTextField.func_146180_a(this.strPercent);
        this.percentTextField.func_146203_f(5);
        this.textFieldList.add(this.percentTextField);
        this.amountTextField = new GuiTextFieldWithReporting(8, this, this.field_146289_q, (int)((float)(this.field_147003_i + 102) / this.scaleFactorTextField), (int)((float)(this.field_147009_r + 11) / this.scaleFactorTextField), 38, 16);
        this.amountTextField.func_146180_a(this.strAmount);
        this.amountTextField.func_146203_f(5);
        this.textFieldList.add(this.amountTextField);
        this.updateTextFieldVisibility();
    }

    private void updateTextFieldVisibility() {
        String s = this.buttonMode.field_146126_j;
        if (s.equals(strMode[0]) || s.equals(strMode[1])) {
            this.showingPercentField = true;
            this.percentTextField.func_146189_e(true);
            this.percentTextField.func_146184_c(true);
            this.amountTextField.func_146189_e(false);
            this.amountTextField.func_146184_c(false);
        } else {
            this.showingPercentField = false;
            this.percentTextField.func_146189_e(false);
            this.percentTextField.func_146184_c(false);
            this.amountTextField.func_146189_e(true);
            this.amountTextField.func_146184_c(true);
        }
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.mode.name"), this.field_147003_i + 2, this.field_147009_r + 1, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.name"), this.field_147003_i + 2, this.field_147009_r + 32, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.N"), this.field_147003_i + 17, this.field_147009_r + 46, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.W"), this.field_147003_i + 17, this.field_147009_r + 56, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.U"), this.field_147003_i + 17, this.field_147009_r + 66, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.S"), this.field_147003_i + 62, this.field_147009_r + 46, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.E"), this.field_147003_i + 62, this.field_147009_r + 56, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.dir.D"), this.field_147003_i + 62, this.field_147009_r + 66, 0xFFFFFF);
        if (this.showingPercentField) {
            this.drawStringScaled(this.field_146289_q, "%", this.field_147003_i + 133, this.field_147009_r + 14, 0xFFFFFF);
        }
        GL11.glPopMatrix();
        if (this.filterExtraText) {
            float old = this.scaleFactor;
            this.scaleFactor *= 0.7f;
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
            this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.greedyChest.quantityResult.open"), this.field_147003_i + 120, this.field_147009_r + 54, 0xFFFFFF);
            String s = "Automagy.gui.greedyChest.quantityResult.";
            switch (this.te.modePilfer) {
                case 0: 
                case 1: {
                    s = s + (this.filterIsBlacklist ? "leave" : "limit");
                    break;
                }
                case 2: {
                    s = s + (this.filterIsBlacklist ? "override" : "limit");
                    break;
                }
                case 3: {
                    s = s + (this.filterIsBlacklist ? "leave" : "override");
                }
            }
            this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)s), this.field_147003_i + 120, this.field_147009_r + 60, 0xFFFFFF);
            GL11.glPopMatrix();
            this.scaleFactor = old;
        }
        super.func_146976_a(var1, var2, var3);
    }

    public void func_73863_a(int x, int y, float p_73863_3_) {
        super.func_73863_a(x, y, p_73863_3_);
        for (int i = 0; i < 6; ++i) {
            if (!((GuiButtonCheckbox)((Object)this.field_146292_n.get(i))).func_146116_c(this.field_146297_k, x, y)) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            World world = this.te.func_145831_w();
            String name = TjUtil.getBlockNameAt(world, this.te.field_145851_c + dir.offsetX, this.te.field_145848_d + dir.offsetY, this.te.field_145849_e + dir.offsetZ);
            if (name == null) break;
            boolean isAir = world.func_147437_c(this.te.field_145851_c + dir.offsetX, this.te.field_145848_d + dir.offsetY, this.te.field_145849_e + dir.offsetZ);
            name = " " + name + " ";
            ArrayList<String> lines = new ArrayList<String>();
            lines.add((isAir ? EnumChatFormatting.GRAY : EnumChatFormatting.AQUA) + name);
            GL11.glPushMatrix();
            GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
            this.drawScaledHoveringText(lines, x - (int)((float)this.field_146289_q.func_78256_a(name) * this.scaleFactor) - 15, y + 7, this.field_146289_q);
            GL11.glPopMatrix();
            break;
        }
    }

    @Override
    protected void buttonClicked(GuiButton button, boolean rightClick) {
        if (button.field_146127_k == 6) {
            int i = Arrays.asList(strMode).indexOf(button.field_146126_j);
            if (rightClick) {
                if (--i < 0) {
                    i = strMode.length - 1;
                }
            } else if (++i >= strMode.length) {
                i = 0;
            }
            button.field_146126_j = strMode[i];
            this.updateTextFieldVisibility();
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIGreedyChestConfig(button.field_146127_k, i));
            return;
        }
        if (button instanceof GuiButtonCheckbox) {
            GuiButtonCheckbox checkbox = (GuiButtonCheckbox)button;
            checkbox.checked = !checkbox.checked;
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIGreedyChestConfig(button.field_146127_k, checkbox.checked ? 1.0f : 0.0f));
        }
    }

    public void updatePercentage(String s) {
        this.percentTextField.func_146180_a(s);
        this.makeTextFieldValid(this.percentTextField);
    }

    public void updateButton(int id, int stringIndex) {
        GuiButton button;
        if (id == 8) {
            this.amountTextField.func_146180_a(String.valueOf(stringIndex));
            this.makeTextFieldValid(this.amountTextField);
            return;
        }
        try {
            button = (GuiButton)this.field_146292_n.get(id);
        }
        catch (Exception ex) {
            FMLLog.warning((String)("[Automagy] GUIGreedyChestConfig updateButton request was invalid. (id=" + id + ")"), (Object[])new Object[0]);
            return;
        }
        if (button instanceof GuiButtonCheckbox) {
            ((GuiButtonCheckbox)button).checked = stringIndex == 1;
            return;
        }
        if (id != 6) {
            FMLLog.warning((String)("[Automagy] Unexpected GUIGreedyChestConfig updateButton request. Ignoring. (id=" + id + ")"), (Object[])new Object[0]);
            return;
        }
        if (stringIndex < 0 || stringIndex >= strMode.length) {
            FMLLog.warning((String)("[Automagy] GUIGreedyChestConfig updateButton request was invalid. Ignoring. (stringIndex=" + stringIndex + ")"), (Object[])new Object[0]);
            return;
        }
        button.field_146126_j = strMode[stringIndex];
        this.updateTextFieldVisibility();
    }

    @Override
    protected boolean textFieldAllowsCharacter(GuiTextField textField, char c, String currentText) {
        if (c == TjUtil.decimalSeparator) {
            return textField == this.percentTextField && !currentText.contains(String.valueOf(TjUtil.decimalSeparator));
        }
        return Character.isDigit(c);
    }

    @Override
    public void onTextFieldLostFocus(GuiTextFieldWithReporting textField) {
        if (this.makeTextFieldValid(textField)) {
            if (textField.id == 7) {
                Float f = null;
                try {
                    f = Float.valueOf(Float.valueOf(textField.func_146179_b()).floatValue() / 100.0f);
                }
                catch (Exception ex) {
                    FMLLog.severe((String)"[Automagy] GUIGreedyChestConfig failed to prepare packet. Invalid value for fraction.", (Object[])new Object[0]);
                    return;
                }
                if (f.floatValue() < 0.001f) {
                    f = Float.valueOf(0.0f);
                }
                if (!TjUtil.areFloatsAlmostEqual_lowprec(this.te.fractionWanted, f.floatValue())) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIGreedyChestConfig(textField.id, f.floatValue()));
                }
            } else if (textField.id == 8) {
                Integer i = null;
                try {
                    i = Integer.valueOf(textField.func_146179_b());
                }
                catch (Exception ex) {
                    FMLLog.severe((String)"[Automagy] GUIGreedyChestConfig failed to prepare packet. Invalid value for amount.", (Object[])new Object[0]);
                    return;
                }
                if (this.te.amountWanted != i) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIGreedyChestConfig(textField.id, i.intValue()));
                }
            }
        }
    }

    private boolean makeTextFieldValid(GuiTextFieldWithReporting textField) {
        boolean percentMode = textField.id == 7;
        boolean usedPrev = false;
        String text = textField.func_146179_b();
        Float f = null;
        try {
            f = Float.valueOf(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null) {
            try {
                f = Float.valueOf(percentMode ? this.strPercent : this.strAmount);
                usedPrev = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f == null) {
                f = Float.valueOf(0.0f);
            }
        }
        if (f.floatValue() < 0.1f) {
            f = Float.valueOf(0.0f);
        } else if (percentMode && f.floatValue() > 100.0f) {
            f = Float.valueOf(100.0f);
        }
        if (percentMode) {
            if (f.floatValue() < 0.001f) {
                f = Float.valueOf(0.0f);
            }
            this.strPercent = String.valueOf(f);
            if (!text.equals(this.strPercent)) {
                textField.func_146180_a(this.strPercent);
            }
        } else {
            this.strAmount = String.valueOf(MathHelper.func_76141_d((float)f.floatValue()));
            if (!text.equals(this.strAmount)) {
                textField.func_146180_a(this.strAmount);
            }
        }
        return !usedPrev;
    }

    @Override
    public void onSlotChanged(SlotRestrictedWithReporting slot) {
        ItemStack stack = slot.func_75211_c();
        if (stack != null) {
            this.filterIsBlacklist = ItemEnchantedPaper.stackIsBlacklist(stack);
            InventoryWithFilterOptions inv = ItemEnchantedPaper.getFilterInventory(stack);
            if (inv != null) {
                this.filterExtraText = inv.useItemCount;
                return;
            }
        }
        this.filterExtraText = false;
    }
}

