/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.items;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tuhljin.automagy.items.InventoryForItem;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;

public class CachedFilterData {
    public static String NBT_KEY = "AutomagyFilterID";
    private static Map<String, CachedFilterData> map = new HashMap<String, CachedFilterData>();
    private static long prefix;
    private static int count;
    public InventoryForItem inventoryOfFilters;
    private int numFilters;
    private InventoryWithFilterOptions[] filter;
    private boolean[] filterIsBlacklist;
    private Pattern[] filterNamePattern;

    public CachedFilterData(ItemStack stack, int numFilters) {
        this.numFilters = numFilters;
        this.filter = new InventoryWithFilterOptions[numFilters];
        this.filterIsBlacklist = new boolean[numFilters];
        this.filterNamePattern = new Pattern[numFilters];
        this.populateFilter(stack);
    }

    public CachedFilterData(ItemStack stack) {
        this(stack, 2);
    }

    public void populateFilter(ItemStack stack) {
        this.inventoryOfFilters = new InventoryForItem(stack, "FilterInv", this.numFilters);
        for (int slot = 0; slot < this.numFilters; ++slot) {
            ItemStack filterStack = this.inventoryOfFilters.func_70301_a(slot);
            if (filterStack == null) {
                this.filter[slot] = null;
                continue;
            }
            this.filter[slot] = ItemEnchantedPaper.getFilterInventory(filterStack);
            if (this.filter[slot] == null) continue;
            this.filterIsBlacklist[slot] = ItemEnchantedPaper.stackIsBlacklist(filterStack);
            this.filterNamePattern[slot] = this.filter[slot].nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter[slot].nameFilter.toLowerCase());
        }
    }

    public static void newCache() {
        prefix = System.currentTimeMillis();
        count = 0;
        map.clear();
    }

    public static CachedFilterData getData(ItemStack stack) {
        String id;
        CachedFilterData data;
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        } else if (stack.field_77990_d.func_74764_b(NBT_KEY) && (data = map.get(id = stack.field_77990_d.func_74779_i(NBT_KEY))) != null) {
            return data;
        }
        data = new CachedFilterData(stack);
        String key = prefix + "-" + ++count;
        map.put(key, data);
        stack.field_77990_d.func_74778_a(NBT_KEY, key);
        return data;
    }

    public static void clearData(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b(NBT_KEY)) {
            String id = stack.field_77990_d.func_74779_i(NBT_KEY);
            stack.field_77990_d.func_82580_o(NBT_KEY);
            map.remove(id);
        }
    }

    public int getMaxToMoveAfterFilter(HashableItemWithoutSize item, FilteringItemList source, FilteringItemList dest, boolean defaultZero) {
        int fs;
        ItemStack keyStack = null;
        ItemStack stack = null;
        int found = -1;
        block0: for (fs = 0; fs < this.numFilters; ++fs) {
            if (this.filter[fs] == null) continue;
            for (int i = 0; i < this.filter[fs].func_70302_i_(); ++i) {
                stack = this.filter[fs].func_70301_a(i);
                if (stack == null || stack.func_77973_b() != item.getItem() || !this.filter[fs].ignoreMetadata && stack.func_77960_j() != item.damage) continue;
                if (this.filter[fs].ignoreNBT) {
                    found = fs;
                    break block0;
                }
                if (keyStack == null) {
                    keyStack = item.getItemStack(1);
                }
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)keyStack)) continue;
                found = fs;
                break block0;
            }
        }
        if (found == -1) {
            for (fs = 0; fs < this.numFilters; ++fs) {
                String name;
                Matcher m;
                if (this.filter[fs] == null || this.filterNamePattern[fs] == null) continue;
                if (keyStack == null) {
                    keyStack = item.getItemStack(1);
                }
                if (!(m = this.filterNamePattern[fs].matcher(name = keyStack.func_82833_r().toLowerCase())).matches()) continue;
                return this.filterIsBlacklist[fs] ? 0 : Integer.MAX_VALUE;
            }
            if (defaultZero) {
                return 0;
            }
            for (fs = 0; fs < this.numFilters; ++fs) {
                if (this.filter[fs] == null || this.filterIsBlacklist[fs]) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        if (!this.filter[found].useItemCount) {
            return this.filterIsBlacklist[found] ? 0 : Integer.MAX_VALUE;
        }
        if (this.filterIsBlacklist[found]) {
            if (source == null) {
                return 0;
            }
            int qtySource = source.get(item, this.filter[found].ignoreMetadata, this.filter[found].ignoreNBT);
            return qtySource - stack.field_77994_a;
        }
        if (dest == null) {
            return stack.field_77994_a;
        }
        int qtyDestination = dest.get(item, this.filter[found].ignoreMetadata, this.filter[found].ignoreNBT);
        return stack.field_77994_a - qtyDestination;
    }

    public int getMaxToMoveFromPlayer(FilteringItemList playerInvMap, HashableItemWithoutSize item) {
        return this.getMaxToMoveAfterFilter(item, playerInvMap, null, true);
    }

    public static FilteringItemList getPlayerInvMap(EntityPlayer player, HashableItemWithoutSize item, int amount) {
        FilteringItemList playerInvMap = new FilteringItemList().populateFromInventory((IInventory)player.field_71071_by, false);
        playerInvMap.add(item, amount);
        return playerInvMap;
    }
}

