/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tuhljin.automagy.gui.GUIScribe;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.network.TemplateMessageItemStacksList;
import tuhljin.automagy.tiles.IReceivesItemListPacket;

public class MessageItemStacksList
extends TemplateMessageItemStacksList<MessageItemStacksList> {
    protected boolean local;

    public MessageItemStacksList() {
    }

    public MessageItemStacksList(int dim, int x, int y, int z, ArrayList<ItemStack> list, boolean partial, boolean local) {
        super(dim, x, y, z, list, partial);
        this.local = local;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.local = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.local);
    }

    @Override
    public void onReceived(World world) {
        if (GUIScribe.alwaysTreatChunkAsUnloaded || !GUIScribe.chunkLoaded || !TjUtil.isChunkLoaded(world, this.x, this.z)) {
            GUIScribe.handleStacksForUnloadedChunk(this.list, this.partial, false, this.local);
        } else {
            TileEntity te = world.func_147438_o(this.x, this.y, this.z);
            if (te instanceof IReceivesItemListPacket) {
                ((IReceivesItemListPacket)te).receiveItemListPacket(this.list, this.partial);
            }
        }
    }

    public static void sendToClient(EntityPlayerMP player, World world, int x, int y, int z, ArrayList<ItemStack> list, boolean partial, boolean local) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageItemStacksList(dim, x, y, z, list, partial, local), player);
    }

    public static void sendToClient(EntityPlayer player, World world, int x, int y, int z, ArrayList<ItemStack> list, boolean partial, boolean local) {
        if (player instanceof EntityPlayerMP) {
            MessageItemStacksList.sendToClient((EntityPlayerMP)player, world, x, y, z, list, partial, local);
        } else {
            FMLLog.warning((String)"[Automagy] Could not send item list packet to client. Player object was the wrong type!", (Object[])new Object[0]);
        }
    }

    public static void sendToClient(EntityPlayerMP player, int dim, int x, int y, int z, ArrayList<ItemStack> list, boolean partial, boolean local) {
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageItemStacksList(dim, x, y, z, list, partial, local), player);
    }

    public static void sendToClient(EntityPlayer player, int dim, int x, int y, int z, ArrayList<ItemStack> list, boolean partial, boolean local) {
        if (player instanceof EntityPlayerMP) {
            MessageItemStacksList.sendToClient((EntityPlayerMP)player, dim, x, y, z, list, partial, local);
        } else {
            FMLLog.warning((String)"[Automagy] Could not send item list packet to client. Player object was the wrong type!", (Object[])new Object[0]);
        }
    }
}

