/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tuhljin.automagy.codechicken.lib.vec.BlockCoord;
import tuhljin.automagy.items.ItemCrystalEye;
import tuhljin.automagy.lib.IAutomagyLocationLink;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.InventorySimple;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.IContainsEyes;

public class InventoryObjectEyes
extends InventorySimple {
    protected boolean checkCoordinates;
    private IContainsEyes parent;

    public InventoryObjectEyes(IContainsEyes parent, String name, int numSlots, boolean checkCoordinates) {
        super(name, numSlots, "CrystalEyeItems");
        this.parent = parent;
        this.checkCoordinates = checkCoordinates;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        WorldSpecificCoordinates coord;
        Item item;
        if (stack != null && (item = stack.func_77973_b()) instanceof ItemCrystalEye && (coord = ((ItemCrystalEye)item).getLinkLocation(stack)) != null) {
            return !this.checkCoordinates || this.coordinatesAreInRange(coord);
        }
        return false;
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        this.parent.onEyesInventoryChanged(slot, prevStack);
    }

    public boolean coordinatesAreInRange(WorldSpecificCoordinates coord) {
        int range;
        if (coord != null && coord.dim == this.parent.getDimensionID() && (range = this.parent.getMaxDistance()) >= 0) {
            BlockCoord parentPos = this.parent.getPosition();
            if (coord.x == parentPos.x && coord.y == parentPos.y && coord.z == parentPos.z) {
                return false;
            }
            float distance = TjUtil.getDistanceBetweenPoints(parentPos.x, parentPos.y, parentPos.z, coord.x, coord.y, coord.z);
            return distance <= (float)range;
        }
        return false;
    }

    public ArrayList<ItemStack> removeInvalidEyes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int size = this.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || this.func_94041_b(i, stack)) continue;
            list.add(stack);
            this.func_70299_a(i, null);
        }
        return list;
    }

    public void organizeSlots() {
        ItemStack[] newSlots = new ItemStack[this.numSlots];
        int count = 0;
        for (int i = 0; i < this.numSlots; ++i) {
            if (this.inventorySlots[i] == null) continue;
            newSlots[count] = this.inventorySlots[i];
            ++count;
        }
        this.inventorySlots = newSlots;
    }

    public WorldSpecificCoordinates getCoordinates(int i) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null && stack.func_77973_b() instanceof IAutomagyLocationLink) {
            return ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack);
        }
        return null;
    }
}

