/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.entities.GolemLink;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.tiles.IGolemLinkableDevice;
import tuhljin.automagy.tiles.ModTileEntity;

public class TileEntityGolemInhibitor
extends ModTileEntity
implements IGolemLinkableDevice {
    public static int rangeIncrements = 5;
    public static int maxRangeIncrementors = 4;
    public static int MAX_LINKS = 6;
    public boolean matchOmitsGolem = true;
    public int numLinksSeen = 0;
    private String linkName = null;
    public static int rotationSpeedFactor = 3240;
    public static double clientRenderFloatingTop = 0.3;
    public int clientRenderRotationHelper = 0;
    public double clientRenderFloatingDistance = 0.0;
    private String linkID = null;

    public boolean toggleMatchOmitsGolem() {
        this.matchOmitsGolem = !this.matchOmitsGolem;
        this.func_70296_d();
        return this.matchOmitsGolem;
    }

    public boolean isActive() {
        return ThaumcraftExtension.blockIsFetter(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, true);
    }

    public int getRange() {
        int count = 0;
        while (ThaumcraftExtension.blockIsFetter(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1 - count, this.field_145849_e, true) && ++count != maxRangeIncrementors) {
        }
        return count * rangeIncrements;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        int linksSeen = 0;
        boolean active = this.isActive();
        if (active) {
            int grabRange = this.getRange();
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - grabRange), (double)((double)this.field_145848_d - 1.5), (double)(this.field_145849_e - grabRange), (double)(this.field_145851_c + grabRange + 1), (double)(this.field_145848_d + grabRange), (double)(this.field_145849_e + grabRange + 1));
            List entities = this.field_145850_b.func_72872_a(EntityGolemBase.class, box);
            for (Entity entity : entities) {
                EntityGolemBase golem = (EntityGolemBase)entity;
                if (this.field_145850_b.field_72995_K) {
                    // empty if block
                }
                if (golem.inactive) continue;
                if (linksSeen < MAX_LINKS && GolemLink.golemLinkedTo(golem, this)) {
                    ++linksSeen;
                    if (this.matchOmitsGolem) continue;
                    golem.inactive = true;
                    continue;
                }
                if (!this.matchOmitsGolem) continue;
                golem.inactive = true;
            }
        }
        this.numLinksSeen = linksSeen;
        if (this.field_145850_b.field_72995_K) {
            if (active) {
                if (this.clientRenderFloatingDistance < clientRenderFloatingTop) {
                    this.clientRenderFloatingDistance += 0.008;
                }
                if (this.clientRenderFloatingDistance > clientRenderFloatingTop / 2.0) {
                    this.clientRenderRotationHelper += 5;
                    if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                        this.clientRenderRotationHelper -= rotationSpeedFactor;
                    }
                }
            } else {
                if (this.clientRenderRotationHelper != 0) {
                    this.clientRenderRotationHelper = this.clientRenderRotationHelper > rotationSpeedFactor / 2 ? (this.clientRenderRotationHelper += 16) : (this.clientRenderRotationHelper -= 16);
                    if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                        this.clientRenderRotationHelper -= rotationSpeedFactor;
                    }
                    if (this.clientRenderRotationHelper <= 16) {
                        this.clientRenderRotationHelper = 0;
                    }
                } else if (this.clientRenderFloatingDistance > 0.0) {
                    this.clientRenderFloatingDistance -= 0.005;
                    if (this.clientRenderFloatingDistance < 0.01) {
                        this.clientRenderFloatingDistance = 0.0;
                    }
                }
                return;
            }
        }
    }

    @Override
    public String getGolemLinkID() {
        if (this.linkID == null) {
            if (this.linkName == null || this.linkName.isEmpty()) {
                if (this.field_145850_b.field_72995_K) {
                    return null;
                }
                int t = (int)(System.currentTimeMillis() / 1000L);
                this.linkName = Integer.toHexString(t);
                this.func_70296_d();
            }
            this.linkID = this.linkName + ":" + this.field_145850_b.field_73011_w.field_76574_g + "," + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e;
        }
        return this.linkID;
    }

    @Override
    public void forgetGolemLinkID() {
        int t = (int)(System.currentTimeMillis() / 1000L);
        this.linkName = Integer.toHexString(t);
        this.linkID = null;
        this.func_70296_d();
        if (this.numLinksSeen > 0) {
            Thaumcraft.proxy.sparkle((float)this.field_145851_c + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.field_145848_d + 0.2f, (float)this.field_145849_e + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, 1.0f, 5, -0.1f);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("matchOmitsGolem", this.matchOmitsGolem);
        if (this.linkName == null && this.getGolemLinkID() == null) {
            return;
        }
        nbttagcompound.func_74778_a("linkName", this.linkName);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.matchOmitsGolem = nbttagcompound.func_74767_n("matchOmitsGolem");
        String newLinkName = nbttagcompound.func_74779_i("linkName");
        if (!newLinkName.equals(this.linkName)) {
            this.linkName = newLinkName;
            this.linkID = null;
        }
    }
}

